/*
 * calibrate : Modem calibration utility
 *
 * Most code is portion of beacon.c of the standard ax25-utils package
 *
 * F1OAT 980321
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <signal.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <linux/ax25.h>
#include <linux/rose.h>

#include "axutils.h"
#include "axconfig.h"
#include "daemon.h"
#include "version.h"

static char message[] = "Le bruit de la mer empeche les petits poissons de dormir RYRYRYRYRYRYRYRYRYRYRYRRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYYRYRYRY";

static void Usage(void)
{
	fprintf(stderr, "Usage : calibrate port\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	struct full_sockaddr_ax25 dest;
	struct full_sockaddr_ax25 src;
	int s, dlen, len;
	char *port;
	char *srccall = NULL, *destcall = "TEST";

	if (argc != 2) Usage();
	
	port    = argv[1];
	
	if (ax25_config_load_ports() == 0) {
		fprintf(stderr, "calibrate: no AX.25 ports defined\n");
		return 1;
	}

	if ((srccall = ax25_config_get_addr(port)) == NULL) {
		fprintf(stderr, "calibrate: invalid AX.25 port setting - %s\n", port);
		return 1;
	}

	if ((dlen = convert_call(destcall, &dest)) == -1) {
		fprintf(stderr, "calibrate: unable to convert callsign '%s'\n", destcall);
		return 1;
	}

	if ((len = convert_call(srccall, &src)) == -1) {
		fprintf(stderr, "calibrate: unable to convert callsign '%s'\n", srccall);
		return 1;
	}

	if ((s = socket(AF_AX25, SOCK_DGRAM, 0)) == -1) {
		perror("socket");
		return 1;
	}

	if (bind(s, (struct sockaddr *)&src, len) == -1) {
		perror("bind");
		return 1;
	}
	
	printf("Press return to stop calibrate\n");
		
	while (1) {
		fd_set rfds;
		struct timeval tv = {0, 200000};
		
		FD_ZERO(&rfds);
		FD_SET(0, &rfds);

		if (select(1, &rfds, NULL, NULL, &tv) == 1) break;	
		
		if (sendto(s, message, strlen(message), 0, (struct sockaddr *)&dest, dlen) == -1) {
			perror("sendto");
		}
	}
	
	close(s);

	return 0;
}
