/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.dataImpl;

import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;

public class RangeImpl {
    public static Range bound(Range range, Column min, Column max, boolean returnEmptyRangeWhenDisjoint) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("min column > max column " + String.valueOf(min) + " " + String.valueOf(max));
        }
        Key sk = range.getStartKey();
        boolean ski = range.isStartKeyInclusive();
        if (sk != null) {
            ByteSequence cf = sk.getColumnFamilyData();
            ByteSequence cq = sk.getColumnQualifierData();
            ArrayByteSequence mincf = new ArrayByteSequence(min.getColumnFamily());
            ArrayByteSequence mincq = min.getColumnQualifier() != null ? new ArrayByteSequence(min.getColumnQualifier()) : new ArrayByteSequence(new byte[0]);
            int cmp = cf.compareTo(mincf);
            if (cmp < 0 || cmp == 0 && cq.compareTo(mincq) < 0) {
                ski = true;
                sk = new Key(sk.getRowData().toArray(), ((ByteSequence)mincf).toArray(), ((ByteSequence)mincq).toArray(), new byte[0], Long.MAX_VALUE, true);
            }
        }
        Key ek = range.getEndKey();
        boolean eki = range.isEndKeyInclusive();
        if (ek != null) {
            ByteSequence row = ek.getRowData();
            ByteSequence cf = ek.getColumnFamilyData();
            ByteSequence cq = ek.getColumnQualifierData();
            ByteSequence cv = ek.getColumnVisibilityData();
            ArrayByteSequence maxcf = new ArrayByteSequence(max.getColumnFamily());
            ArrayByteSequence maxcq = null;
            if (max.getColumnQualifier() != null) {
                maxcq = new ArrayByteSequence(max.getColumnQualifier());
            }
            boolean set = false;
            int comp = cf.compareTo(maxcf);
            if (comp > 0) {
                set = true;
            } else if (comp == 0 && maxcq != null && cq.compareTo(maxcq) > 0) {
                set = true;
            } else if (!eki && row.length() > 0 && row.byteAt(row.length() - 1) == 0 && cf.length() == 0 && cq.length() == 0 && cv.length() == 0 && ek.getTimestamp() == Long.MAX_VALUE) {
                row = row.subSequence(0, row.length() - 1);
                set = true;
            }
            if (set) {
                eki = false;
                ek = maxcq == null ? new Key(row.toArray(), ((ByteSequence)maxcf).toArray(), new byte[0], new byte[0], 0L, false).followingKey(PartialKey.ROW_COLFAM) : new Key(row.toArray(), ((ByteSequence)maxcf).toArray(), ((ByteSequence)maxcq).toArray(), new byte[0], 0L, false).followingKey(PartialKey.ROW_COLFAM_COLQUAL);
            }
        }
        if (returnEmptyRangeWhenDisjoint && sk != null && ek != null && sk.compareTo(ek) > 0) {
            return new Range(sk, true, sk, false);
        }
        return new Range(sk, ski, ek, eki);
    }
}

