/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.spring.util.CamelContextResolverHelper;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.RemoteExporter;

public class CamelServiceExporter
extends RemoteExporter
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
CamelContextAware {
    private String uri;
    private CamelContext camelContext;
    private String camelContextId;
    private Consumer consumer;
    private String serviceRef;
    private ApplicationContext applicationContext;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }

    public String getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(String serviceRef) {
        this.serviceRef = serviceRef;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.uri, (String)"uri");
        if (ObjectHelper.isNotEmpty((Object)this.camelContextId)) {
            this.camelContext = CamelContextResolverHelper.getCamelContextWithId(this.applicationContext, this.camelContextId);
        }
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        if (this.serviceRef != null && this.getService() == null && this.applicationContext != null) {
            this.setService(this.applicationContext.getBean(this.serviceRef));
        }
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)this.camelContext, (String)this.uri);
        ObjectHelper.notNull((Object)this.getService(), (String)"service");
        Object proxy = this.getProxyForService();
        try {
            ServiceHelper.startService((Service)endpoint);
            this.consumer = endpoint.createConsumer((Processor)new BeanProcessor(proxy, this.camelContext));
            this.camelContext.addService((Object)this.consumer, true, true);
        }
        catch (Exception e) {
            throw new FailedToCreateConsumerException(endpoint, (Throwable)e);
        }
    }

    public void destroy() throws Exception {
    }
}

