/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.app;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.model.app.BeanPropertiesDefinition;
import org.apache.camel.model.app.BeanPropertyDefinition;

public class BeanPropertiesAdapter
extends XmlAdapter<BeanPropertiesDefinition, Map<String, Object>> {
    public Map<String, Object> unmarshal(BeanPropertiesDefinition v) {
        if (v == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (BeanPropertyDefinition pd : v.getProperties()) {
            if (pd.getProperties() != null) {
                result.put(pd.getKey(), this.unmarshal(pd.getProperties()));
                continue;
            }
            result.put(pd.getKey(), pd.getValue());
        }
        return result;
    }

    public BeanPropertiesDefinition marshal(Map<String, Object> v) {
        if (v == null) {
            return null;
        }
        BeanPropertyDefinition[] result = new BeanPropertyDefinition[v.size()];
        int pos = 0;
        for (Map.Entry<String, Object> entry : v.entrySet()) {
            String k = entry.getKey();
            Object value = entry.getValue();
            BeanPropertyDefinition pd = new BeanPropertyDefinition();
            pd.setKey(k);
            if (value instanceof Map) {
                pd.setProperties(this.marshal((Map)value));
            } else {
                pd.setValue(value.toString());
            }
            result[pos++] = pd;
        }
        BeanPropertiesDefinition propertiesDefinition = new BeanPropertiesDefinition();
        propertiesDefinition.setProperties(Arrays.asList(result));
        return propertiesDefinition;
    }
}

