/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;

public class Wss10
extends AbstractSecurityAssertion {
    private boolean mustSupportRefKeyIdentifier;
    private boolean MustSupportRefIssuerSerial;
    private boolean MustSupportRefExternalURI;
    private boolean MustSupportRefEmbeddedToken;

    public Wss10(int version) {
        this.setVersion(version);
    }

    public boolean isMustSupportRefEmbeddedToken() {
        return this.MustSupportRefEmbeddedToken;
    }

    public void setMustSupportRefEmbeddedToken(boolean mustSupportRefEmbeddedToken) {
        this.MustSupportRefEmbeddedToken = mustSupportRefEmbeddedToken;
    }

    public boolean isMustSupportRefExternalURI() {
        return this.MustSupportRefExternalURI;
    }

    public void setMustSupportRefExternalURI(boolean mustSupportRefExternalURI) {
        this.MustSupportRefExternalURI = mustSupportRefExternalURI;
    }

    public boolean isMustSupportRefIssuerSerial() {
        return this.MustSupportRefIssuerSerial;
    }

    public void setMustSupportRefIssuerSerial(boolean mustSupportRefIssuerSerial) {
        this.MustSupportRefIssuerSerial = mustSupportRefIssuerSerial;
    }

    public boolean isMustSupportRefKeyIdentifier() {
        return this.mustSupportRefKeyIdentifier;
    }

    public void setMustSupportRefKeyIdentifier(boolean mustSupportRefKeyIdentifier) {
        this.mustSupportRefKeyIdentifier = mustSupportRefKeyIdentifier;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.WSS10;
        }
        return SP11Constants.WSS10;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        Wss10.writeStartElement(writer, prefix, localname, namespaceURI);
        Wss10.writeStartElement(writer, SPConstants.POLICY);
        if (this.isMustSupportRefKeyIdentifier()) {
            Wss10.writeEmptyElement(writer, prefix, "MustSupportRefKeyIdentifier", namespaceURI);
        }
        if (this.isMustSupportRefIssuerSerial()) {
            Wss10.writeEmptyElement(writer, prefix, "MustSupportRefIssuerSerial", namespaceURI);
        }
        if (this.isMustSupportRefExternalURI()) {
            Wss10.writeEmptyElement(writer, prefix, "MustSupportRefExternalURI", namespaceURI);
        }
        if (this.isMustSupportRefEmbeddedToken()) {
            Wss10.writeEmptyElement(writer, prefix, "MustSupportRefEmbeddedToken", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

