/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform natural language processing using AWS Comprehend and AWS SDK version
 * 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Comprehend2EndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Comprehend component.
     */
    public interface Comprehend2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedComprehend2EndpointBuilder advanced() {
            return (AdvancedComprehend2EndpointBuilder) this;
        }

        /**
         * The Amazon Resource Name (ARN) of the endpoint to use for document
         * classification. Required for classifyDocument operation.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param endpointArn the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder endpointArn(String endpointArn) {
            doSetProperty("endpointArn", endpointArn);
            return this;
        }
        /**
         * The language code of the input text. Required for all operations
         * except detectDominantLanguage. Use a 2-letter ISO 639-1 code (e.g.,
         * 'en' for English, 'es' for Spanish).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param languageCode the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder languageCode(String languageCode) {
            doSetProperty("languageCode", languageCode);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.comprehend.Comprehend2Operations</code> type.
         * 
         * Required: true
         * Default: detectDominantLanguage
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder operation(org.apache.camel.component.aws2.comprehend.Comprehend2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.comprehend.Comprehend2Operations</code> type.
         * 
         * Required: true
         * Default: detectDominantLanguage
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * The region in which the Comprehend client needs to work. When using
         * this parameter, the configuration will expect the lowercase name of
         * the region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Comprehend client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Comprehend client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Comprehend client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Comprehend client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Comprehend client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the Comprehend client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Comprehend client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Comprehend client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Comprehend client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Comprehend client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Comprehend.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Comprehend client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Comprehend.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Comprehend component.
     */
    public interface AdvancedComprehend2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Comprehend2EndpointBuilder basic() {
            return (Comprehend2EndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedComprehend2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedComprehend2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use an existing configured AWS Comprehend client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.comprehend.ComprehendClient</code> type.
         * 
         * Group: advanced
         * 
         * @param comprehendClient the value to set
         * @return the dsl builder
         */
        default AdvancedComprehend2EndpointBuilder comprehendClient(software.amazon.awssdk.services.comprehend.ComprehendClient comprehendClient) {
            doSetProperty("comprehendClient", comprehendClient);
            return this;
        }
        /**
         * To use an existing configured AWS Comprehend client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.comprehend.ComprehendClient</code> type.
         * 
         * Group: advanced
         * 
         * @param comprehendClient the value to set
         * @return the dsl builder
         */
        default AdvancedComprehend2EndpointBuilder comprehendClient(String comprehendClient) {
            doSetProperty("comprehendClient", comprehendClient);
            return this;
        }
    }

    public interface Comprehend2Builders {
        /**
         * AWS Comprehend (camel-aws2-comprehend)
         * Perform natural language processing using AWS Comprehend and AWS SDK
         * version 2.x.
         * 
         * Category: cloud,ai
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws2-comprehend
         * 
         * @return the dsl builder for the headers' name.
         */
        default Comprehend2HeaderNameBuilder aws2Comprehend() {
            return Comprehend2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Comprehend (camel-aws2-comprehend)
         * Perform natural language processing using AWS Comprehend and AWS SDK
         * version 2.x.
         * 
         * Category: cloud,ai
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws2-comprehend
         * 
         * Syntax: <code>aws2-comprehend:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder aws2Comprehend(String path) {
            return Comprehend2EndpointBuilderFactory.endpointBuilder("aws2-comprehend", path);
        }
        /**
         * AWS Comprehend (camel-aws2-comprehend)
         * Perform natural language processing using AWS Comprehend and AWS SDK
         * version 2.x.
         * 
         * Category: cloud,ai
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws2-comprehend
         * 
         * Syntax: <code>aws2-comprehend:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default Comprehend2EndpointBuilder aws2Comprehend(String componentName, String path) {
            return Comprehend2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Comprehend component.
     */
    public static class Comprehend2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Comprehend2HeaderNameBuilder INSTANCE = new Comprehend2HeaderNameBuilder();

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsComprehendOperation}.
         */
        public String awsComprehendOperation() {
            return "CamelAwsComprehendOperation";
        }
        /**
         * The language code of the input text.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsComprehendLanguageCode}.
         */
        public String awsComprehendLanguageCode() {
            return "CamelAwsComprehendLanguageCode";
        }
        /**
         * The Amazon Resource Name (ARN) of the endpoint to use for document
         * classification.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsComprehendEndpointArn}.
         */
        public String awsComprehendEndpointArn() {
            return "CamelAwsComprehendEndpointArn";
        }
        /**
         * The detected dominant language.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsComprehendDetectedLanguage}.
         */
        public String awsComprehendDetectedLanguage() {
            return "CamelAwsComprehendDetectedLanguage";
        }
        /**
         * The detected dominant language score.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsComprehendDetectedLanguageScore}.
         */
        public String awsComprehendDetectedLanguageScore() {
            return "CamelAwsComprehendDetectedLanguageScore";
        }
        /**
         * The detected sentiment.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsComprehendDetectedSentiment}.
         */
        public String awsComprehendDetectedSentiment() {
            return "CamelAwsComprehendDetectedSentiment";
        }
        /**
         * The detected sentiment scores.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.comprehend.model.SentimentScore}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsComprehendDetectedSentimentScore}.
         */
        public String awsComprehendDetectedSentimentScore() {
            return "CamelAwsComprehendDetectedSentimentScore";
        }
    }
    static Comprehend2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Comprehend2EndpointBuilderImpl extends AbstractEndpointBuilder implements Comprehend2EndpointBuilder, AdvancedComprehend2EndpointBuilder {
            public Comprehend2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Comprehend2EndpointBuilderImpl(path);
    }
}