/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.dsl.yaml.validator;

import java.io.File;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CamelYamlParserTest {

    private static CamelYamlParser parser;

    @BeforeAll
    public static void setup() throws Exception {
        parser = new CamelYamlParser();
    }

    @Test
    public void testParseOk() throws Exception {
        Assertions.assertTrue(parser.parse(new File("src/test/resources/foo.yaml")).isEmpty());
    }

    @Test
    public void testParseBad() throws Exception {
        var report = parser.parse(new File("src/test/resources/bad.yaml"));
        Assertions.assertFalse(report.isEmpty());
        Assertions.assertEquals(1, report.size());
        Assertions.assertTrue(report.get(0).getMessage().contains("Unknown node id: setCheese"));
        Assertions.assertTrue(report.get(0).getMessage().contains("- setCheese:"));
    }
}
