/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.PermissionsManagementStatement;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class GrantPermissionsStatement
extends PermissionsManagementStatement {
    public GrantPermissionsStatement(Set<Permission> permissions, IResource resource, RoleName grantee) {
        super(permissions, resource, grantee);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        DataResource data;
        super.validate(state);
        if (this.resource instanceof DataResource && !(data = (DataResource)this.resource).isRootLevel() && Schema.isSystemKeyspace(data.getKeyspace()) && !Collections.disjoint(this.permissions, Permission.INVALID_FOR_SYSTEM_KEYSPACES)) {
            throw new UnauthorizedException("Granting permissions on system keyspaces is strictly limited, this operation is not permitted");
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        DatabaseDescriptor.getAuthorizer().grant(state.getUser(), this.permissions, this.resource, this.grantee);
        return null;
    }
}

