/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.Operation;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.FBUtilities;

public class FilterTree {
    protected final Operation.BooleanOperator baseOperator;
    protected final Operation.Expressions expressions;
    protected final List<FilterTree> children = new ArrayList<FilterTree>();
    private final boolean isStrict;
    private final QueryContext context;

    FilterTree(Operation.BooleanOperator baseOperator, Operation.Expressions expressions, boolean isStrict, QueryContext context) {
        this.baseOperator = baseOperator;
        this.expressions = expressions;
        this.isStrict = isStrict;
        this.context = context;
    }

    void addChild(FilterTree child) {
        this.children.add(child);
    }

    public boolean restrictsNonStaticRow() {
        for (ColumnMetadata column : this.expressions.columns()) {
            if (column.isStatic()) continue;
            return true;
        }
        for (FilterTree child : this.children) {
            if (!child.restrictsNonStaticRow()) continue;
            return true;
        }
        return false;
    }

    public boolean isSatisfiedBy(DecoratedKey key, Row row, Row staticRow) {
        boolean result = this.localSatisfiedBy(key, row, staticRow);
        for (FilterTree child : this.children) {
            result = this.baseOperator.apply(result, child.isSatisfiedBy(key, row, staticRow));
        }
        return result;
    }

    private boolean localSatisfiedBy(DecoratedKey key, Row row, Row staticRow) {
        if (row == null) {
            return false;
        }
        long now = FBUtilities.nowInSeconds();
        Operation.BooleanOperator localOperator = this.isStrict || !this.context.hasUnrepairedMatches ? this.baseOperator : Operation.BooleanOperator.OR;
        boolean result = localOperator == Operation.BooleanOperator.AND;
        boolean isolateUnindexed = !this.context.hasUnrepairedMatches && !this.isStrict && this.expressions.hasMultipleUnindexedColumns();
        boolean unindexedResult = false;
        for (ColumnMetadata column : this.expressions.columns()) {
            Expression filter;
            Row localRow = column.kind == ColumnMetadata.Kind.STATIC ? staticRow : row;
            List<Expression> filters = this.expressions.expressionsFor(column);
            ListIterator<Expression> filterIterator = filters.listIterator(filters.size());
            if (isolateUnindexed && this.expressions.isUnindexed(column)) {
                if (unindexedResult) continue;
                while (filterIterator.hasPrevious()) {
                    filter = filterIterator.previous();
                    unindexedResult = this.applyFilter(key, now, Operation.BooleanOperator.OR, unindexedResult, localRow, filter);
                }
                continue;
            }
            while (filterIterator.hasPrevious()) {
                filter = filterIterator.previous();
                result = this.applyFilter(key, now, localOperator, result, localRow, filter);
                if (localOperator == Operation.BooleanOperator.AND && !result) {
                    return false;
                }
                if (localOperator != Operation.BooleanOperator.OR || !result) continue;
                return true;
            }
        }
        if (isolateUnindexed) {
            return localOperator == Operation.BooleanOperator.AND ? unindexedResult : result || unindexedResult;
        }
        return result;
    }

    private boolean applyFilter(DecoratedKey key, long now, Operation.BooleanOperator operator, boolean result, Row row, Expression expression) {
        if (expression.getIndexTermType().isNonFrozenCollection()) {
            Iterator<ByteBuffer> valueIterator = expression.getIndexTermType().valuesOf(row, now);
            return operator.apply(result, this.collectionMatch(valueIterator, expression));
        }
        ByteBuffer value = expression.getIndexTermType().valueOf(key, row, now);
        return operator.apply(result, this.singletonMatch(value, expression));
    }

    private boolean singletonMatch(ByteBuffer value, Expression filter) {
        return value != null && filter.isSatisfiedBy(value);
    }

    private boolean collectionMatch(Iterator<ByteBuffer> valueIterator, Expression filter) {
        if (valueIterator == null) {
            return false;
        }
        while (valueIterator.hasNext()) {
            ByteBuffer value = valueIterator.next();
            if (value == null || !filter.isSatisfiedBy(value)) continue;
            return true;
        }
        return false;
    }
}

