/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.virtual;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.StorageAttachedIndexGroup;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;

public class ColumnIndexesSystemView
extends AbstractVirtualTable {
    public static final String NAME = "sai_column_indexes";
    static final String KEYSPACE_NAME = "keyspace_name";
    static final String INDEX_NAME = "index_name";
    static final String TABLE_NAME = "table_name";
    static final String COLUMN_NAME = "column_name";
    static final String IS_QUERYABLE = "is_queryable";
    static final String IS_BUILDING = "is_building";
    static final String IS_STRING = "is_string";
    static final String ANALYZER = "analyzer";

    public ColumnIndexesSystemView(String keyspace) {
        super(TableMetadata.builder(keyspace, NAME).partitioner(new LocalPartitioner(UTF8Type.instance)).comment("Storage-attached column index metadata").kind(TableMetadata.Kind.VIRTUAL).addPartitionKeyColumn(KEYSPACE_NAME, UTF8Type.instance).addClusteringColumn(INDEX_NAME, UTF8Type.instance).addRegularColumn(TABLE_NAME, UTF8Type.instance).addRegularColumn(COLUMN_NAME, UTF8Type.instance).addRegularColumn(IS_QUERYABLE, BooleanType.instance).addRegularColumn(IS_BUILDING, BooleanType.instance).addRegularColumn(IS_STRING, BooleanType.instance).addRegularColumn(ANALYZER, UTF8Type.instance).build());
    }

    @Override
    public void apply(PartitionUpdate update) {
        throw new InvalidRequestException("Modification is not supported by table " + this.metadata);
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet dataset = new SimpleDataSet(this.metadata());
        for (String ks : Schema.instance.getUserKeyspaces()) {
            Keyspace keyspace = Schema.instance.getKeyspaceInstance(ks);
            if (keyspace == null) {
                throw new IllegalArgumentException("Unknown keyspace " + ks);
            }
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                SecondaryIndexManager manager = cfs.indexManager;
                StorageAttachedIndexGroup group = StorageAttachedIndexGroup.getIndexGroup(cfs);
                if (group == null) continue;
                group.getIndexes().forEach(i -> {
                    StorageAttachedIndex index = (StorageAttachedIndex)i;
                    String indexName = index.identifier().indexName;
                    dataset.row(ks, indexName).column(TABLE_NAME, cfs.name).column(COLUMN_NAME, index.termType().columnName()).column(IS_QUERYABLE, manager.isIndexQueryable(index)).column(IS_BUILDING, manager.isIndexBuilding(indexName)).column(IS_STRING, index.termType().isLiteral()).column(ANALYZER, index.hasAnalyzer() ? index.analyzer().toString() : "NoOpAnalyzer");
                });
            }
        }
        return dataset;
    }
}

