/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.livemigration;

import java.util.HashMap;
import java.util.Map;

public enum LiveMigrationDirType {
    CDC_RAW_DIR("cdc_raw"),
    COMMIT_LOG_DIR("commitlog"),
    DATA_FIlE_DIR("data"),
    HINTS_DIR("hints"),
    LOCAL_SYSTEM_DATA_FILE_DIR("local_system_data"),
    SAVED_CACHES_DIR("saved_caches");

    private static final Map<String, LiveMigrationDirType> DIR_TYPE_MAP;
    public final String dirType;

    private LiveMigrationDirType(String dirType) {
        this.dirType = dirType;
    }

    public static LiveMigrationDirType find(String dirType) {
        return DIR_TYPE_MAP.get(dirType);
    }

    static {
        DIR_TYPE_MAP = new HashMap<String, LiveMigrationDirType>();
        for (LiveMigrationDirType type : LiveMigrationDirType.values()) {
            DIR_TYPE_MAP.put(type.dirType, type);
        }
    }
}

