/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractCellExtractorTest;
import org.apache.commons.collections4.bloomfilter.CellExtractor;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.LayeredBloomFilter;
import org.apache.commons.collections4.bloomfilter.LayeredBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;

public class CellExtractorFromLayeredBloomFilterTest
extends AbstractCellExtractorTest {
    protected Shape shape = Shape.fromKM((int)17, (int)72);

    @Override
    protected CellExtractor createEmptyExtractor() {
        return CellExtractor.from(LayeredBloomFilterTest.fixed(this.shape, 10));
    }

    @Override
    protected CellExtractor createExtractor() {
        IncrementingHasher hasher = new IncrementingHasher(3L, 2L);
        LayeredBloomFilter<SimpleBloomFilter> bf = LayeredBloomFilterTest.fixed(this.shape, 10);
        bf.merge((Hasher)hasher);
        return CellExtractor.from(bf);
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35};
    }

    @Override
    protected int[] getExpectedValues() {
        return new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    }
}

