/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConnectionBridge
extends BridgeImpl {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterConnection clusterConnection;
    private final ClusterManager clusterManager;
    private final MessageFlowRecord flowRecord;
    private final SimpleString managementAddress;
    private final SimpleString managementNotificationAddress;
    private ClientConsumer notifConsumer;
    private final SimpleString idsHeaderName;
    private final long targetNodeEventUID;
    private final StorageManager storageManager;
    private final ServerLocatorInternal discoveryLocator;
    private final String storeAndForwardPrefix;
    private TopologyMemberImpl member;

    public ClusterConnectionBridge(ClusterConnection clusterConnection, ClusterManager clusterManager, ServerLocatorInternal targetLocator, ServerLocatorInternal discoveryLocator, int initialConnectAttempts, int reconnectAttempts, long retryInterval, double retryMultiplier, long maxRetryInterval, UUID nodeUUID, long targetNodeEventUID, String targetNodeID, SimpleString name, Queue queue, Executor executor, Filter filterString, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, TransformerConfiguration transformer, boolean useDuplicateDetection, String user, String password, ActiveMQServer server, SimpleString managementAddress, SimpleString managementNotificationAddress, MessageFlowRecord flowRecord, TransportConfiguration connector, String storeAndForwardPrefix, StorageManager storageManager, String clientId) throws ActiveMQException {
        super(targetLocator, new BridgeConfiguration().setName(name == null ? null : name.toString()).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setReconnectAttemptsOnSameNode(0).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryMultiplier).setMaxRetryInterval(maxRetryInterval).setFilterString(filterString == null ? null : filterString.toString()).setForwardingAddress(forwardingAddress == null ? null : forwardingAddress.toString()).setUseDuplicateDetection(useDuplicateDetection).setUser(user).setPassword(password).setTransformerConfiguration(transformer).setRoutingType(ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultBridgeRoutingType())).setClientId(clientId), nodeUUID, queue, executor, scheduledExecutor, server);
        this.discoveryLocator = discoveryLocator;
        this.idsHeaderName = Message.HDR_ROUTE_TO_IDS.concat(name);
        this.clusterConnection = clusterConnection;
        this.clusterManager = clusterManager;
        this.targetNodeEventUID = targetNodeEventUID;
        this.targetNodeID = targetNodeID;
        this.managementAddress = managementAddress;
        this.managementNotificationAddress = managementNotificationAddress;
        this.flowRecord = flowRecord;
        if (logger.isTraceEnabled()) {
            logger.trace("Setting up bridge between {} and {}", new Object[]{clusterConnection.getConnector(), targetLocator, new Exception("trace")});
        }
        this.storeAndForwardPrefix = storeAndForwardPrefix;
        this.storageManager = storageManager;
    }

    @Override
    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        this.serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.serverLocator, this.storageManager));
        ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory(this.targetNodeID);
        if (factory == null && (factory = this.reconnectOnOriginalNode()) == null) {
            return null;
        }
        this.setSessionFactory(factory);
        if (factory == null) {
            return null;
        }
        factory.setReconnectAttempts(0);
        factory.getConnection().addFailureListener((FailureListener)this);
        return factory;
    }

    @Override
    protected Message beforeForward(Message message, SimpleString forwardingAddress) {
        Message messageCopy = message.copy();
        logger.trace("Clustered bridge  copied message {} as {} before delivery", (Object)message, (Object)messageCopy);
        HashSet propNames = new HashSet(messageCopy.getPropertyNames());
        byte[] queueIds = message.getExtraBytesProperty(this.idsHeaderName);
        if (queueIds == null) {
            ActiveMQServerLogger.LOGGER.noQueueIdDefined(message, messageCopy, this.idsHeaderName);
            throw new IllegalStateException("no queueIDs defined");
        }
        for (SimpleString propName : propNames) {
            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
            messageCopy.removeProperty(propName);
        }
        messageCopy.putExtraBytesProperty(Message.HDR_ROUTE_TO_IDS, queueIds);
        messageCopy = super.beforeForwardingNoCopy(messageCopy, forwardingAddress);
        return messageCopy;
    }

    private void setupNotificationConsumer() throws Exception {
        if (this.flowRecord != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting up notificationConsumer between {} and {} clusterConnection = {} on server {}", new Object[]{this.clusterConnection.getConnector(), this.flowRecord.getBridge().getForwardingConnection(), this.clusterConnection.getName(), this.clusterConnection.getServer()});
            }
            this.flowRecord.reset();
            if (this.notifConsumer != null) {
                try {
                    logger.debug("Closing notification Consumer for reopening {} on bridge {}", (Object)this.notifConsumer, (Object)this.getName());
                    this.notifConsumer.close();
                    this.notifConsumer = null;
                }
                catch (ActiveMQException e) {
                    ActiveMQServerLogger.LOGGER.errorClosingConsumer((Exception)((Object)e));
                }
            }
            String qName = "notif." + UUIDGenerator.getInstance().generateStringUUID() + "." + this.clusterConnection.getServer().toString().replaceAll("::", "_");
            SimpleString notifQueueName = SimpleString.of((String)qName);
            SimpleString filter = SimpleString.of((String)("(" + ManagementHelper.HDR_BINDING_TYPE + " <> " + BindingType.DIVERT.toInt() + " OR " + ManagementHelper.HDR_BINDING_TYPE + " IS NULL) AND " + ManagementHelper.HDR_NOTIFICATION_TYPE + " IN ('" + CoreNotificationType.SESSION_CREATED + "', '" + CoreNotificationType.BINDING_ADDED + "', '" + CoreNotificationType.BINDING_REMOVED + "', '" + CoreNotificationType.BINDING_UPDATED + "', '" + CoreNotificationType.CONSUMER_CREATED + "', '" + CoreNotificationType.CONSUMER_CLOSED + "', '" + CoreNotificationType.PROPOSAL + "', '" + CoreNotificationType.PROPOSAL_RESPONSE + "', '" + CoreNotificationType.UNPROPOSAL + "') AND " + ManagementHelper.HDR_DISTANCE + " < " + this.flowRecord.getMaxHops() + " AND (" + ClusterConnectionBridge.createSelectorFromAddress(this.appendIgnoresToFilter(this.flowRecord.getAddress())) + ") AND (" + this.createPermissiveManagementNotificationToFilter() + ")"));
            this.sessionConsumer.createQueue(QueueConfiguration.of((SimpleString)notifQueueName).setAddress(this.managementNotificationAddress).setFilterString(filter).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)).setRoutingType(RoutingType.MULTICAST));
            this.notifConsumer = this.sessionConsumer.createConsumer(notifQueueName);
            this.notifConsumer.setMessageHandler((MessageHandler)this.flowRecord);
            this.sessionConsumer.start();
            ClientMessage message = this.sessionConsumer.createMessage(false);
            if (logger.isTraceEnabled()) {
                logger.trace("Requesting sendQueueInfoToQueue through {}", (Object)this, (Object)new Exception("trace"));
            }
            ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"sendQueueInfoToQueue", (Object[])new Object[]{notifQueueName.toString(), this.flowRecord.getAddress()});
            try (ClientProducer prod = this.sessionConsumer.createProducer(this.managementAddress);){
                logger.debug("Cluster connection bridge on {} requesting information on queues", (Object)this.clusterConnection);
                prod.send((Message)message);
            }
        }
    }

    public static String createSelectorFromAddress(String address) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!address.contains(",")) {
            if (address.startsWith("!")) {
                stringBuilder.append(ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address.substring(1, address.length()) + "%'");
            } else {
                stringBuilder.append(ManagementHelper.HDR_ADDRESS + " LIKE '" + address + "%'");
            }
            return stringBuilder.toString();
        }
        return ClusterConnectionBridge.buildSelectorFromArray(address.split(","));
    }

    public static String buildSelectorFromArray(String[] list) {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String s : list) {
            if (s.startsWith("!")) {
                excludes.add(s.substring(1, s.length()));
                continue;
            }
            includes.add(s);
        }
        StringBuilder builder = new StringBuilder("(");
        if (includes.size() > 0) {
            if (excludes.size() > 0) {
                builder.append("(");
            }
            for (i = 0; i < includes.size(); ++i) {
                builder.append("(" + ManagementHelper.HDR_ADDRESS + " LIKE '" + (String)includes.get(i) + "%')");
                if (i >= includes.size() - 1) continue;
                builder.append(" OR ");
            }
            if (excludes.size() > 0) {
                builder.append(")");
            }
        }
        if (excludes.size() > 0) {
            if (includes.size() > 0) {
                builder.append(" AND (");
            }
            for (i = 0; i < excludes.size(); ++i) {
                builder.append("(" + ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + (String)excludes.get(i) + "%')");
                if (i >= excludes.size() - 1) continue;
                builder.append(" AND ");
            }
            if (includes.size() > 0) {
                builder.append(")");
            }
        }
        builder.append(")");
        return builder.toString();
    }

    private String appendIgnoresToFilter(String filterString) {
        if (filterString != null && !((String)filterString).isEmpty()) {
            filterString = (String)filterString + ",";
        }
        filterString = (String)filterString + "!" + this.storeAndForwardPrefix;
        filterString = (String)filterString + ",!" + this.managementAddress;
        for (String ignoreAddress : this.clusterManager.getProtocolIgnoredAddresses()) {
            filterString = (String)filterString + ",!" + ignoreAddress;
        }
        return filterString;
    }

    private String createPermissiveManagementNotificationToFilter() {
        StringBuilder filterBuilder = new StringBuilder((CharSequence)ManagementHelper.HDR_NOTIFICATION_TYPE).append(" = '").append(CoreNotificationType.SESSION_CREATED).append("' OR (").append((CharSequence)ManagementHelper.HDR_ADDRESS).append(" NOT LIKE '").append((CharSequence)this.managementNotificationAddress).append("%')");
        return filterBuilder.toString();
    }

    @Override
    protected void nodeUP(TopologyMember member, boolean last) {
        if (member != null && this.targetNodeID != null && !this.targetNodeID.equals(member.getNodeId())) {
            return;
        }
        super.nodeUP(member, last);
    }

    @Override
    protected void afterConnect() throws Exception {
        super.afterConnect();
        this.setupNotificationConsumer();
    }

    @Override
    protected void tryScheduleRetryReconnect(ActiveMQExceptionType type) {
        if (type != ActiveMQExceptionType.DISCONNECTED) {
            this.scheduleRetryConnect();
        }
    }

    @Override
    protected void fail(boolean permanently, boolean scaleDown) {
        logger.debug("Cluster Bridge {} failed, permanently={}", (Object)this.getName(), (Object)permanently);
        super.fail(permanently, scaleDown);
        if (permanently) {
            logger.debug("cluster node for bridge {} is permanently down", (Object)this.getName());
            this.clusterConnection.removeRecord(this.targetNodeID);
            if (scaleDown) {
                this.executor.execute(() -> {
                    logger.debug("Scaling down queue {}", (Object)this.queue);
                    try {
                        this.queue.deleteQueue(true);
                        this.queue.removeAddress();
                    }
                    catch (ActiveMQAddressDoesNotExistException e) {
                        logger.debug("ActiveMQAddressDoesNotExistException during scale down for queue {}", (Object)this.queue);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                });
            }
        } else {
            this.clusterConnection.disconnectRecord(this.targetNodeID);
        }
    }
}

