/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption.keys.content;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.xml.security.encryption.AgreementMethod;
import org.apache.xml.security.encryption.KeyDerivationMethod;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.encryption.keys.OriginatorKeyInfo;
import org.apache.xml.security.encryption.keys.RecipientKeyInfo;
import org.apache.xml.security.encryption.keys.content.derivedKey.ConcatKDFParamsImpl;
import org.apache.xml.security.encryption.keys.content.derivedKey.HKDFParamsImpl;
import org.apache.xml.security.encryption.keys.content.derivedKey.KDFParams;
import org.apache.xml.security.encryption.keys.content.derivedKey.KeyDerivationMethodImpl;
import org.apache.xml.security.encryption.params.ConcatKDFParams;
import org.apache.xml.security.encryption.params.HKDFParams;
import org.apache.xml.security.encryption.params.KeyAgreementParameters;
import org.apache.xml.security.encryption.params.KeyDerivationParameters;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.KeyInfoContent;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.EncryptionElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AgreementMethodImpl
extends EncryptionElementProxy
implements KeyInfoContent,
AgreementMethod {
    protected static final System.Logger LOG = System.getLogger(AgreementMethodImpl.class.getName());
    private byte[] kaNonce;
    private List<Element> agreementMethodInformation;
    private KeyDerivationMethod keyDerivationMethod;
    private OriginatorKeyInfo originatorKeyInfo;
    private RecipientKeyInfo recipientKeyInfo;
    private String algorithmURI;

    public AgreementMethodImpl(Document doc, KeyAgreementParameters keyAgreementParameter) throws XMLEncryptionException {
        this(doc, keyAgreementParameter.getKeyAgreementAlgorithm());
        if (keyAgreementParameter.getKeyDerivationParameter() != null) {
            KeyDerivationMethod keyDerivationMethod = this.createKeyDerivationMethod(keyAgreementParameter);
            this.setKeyDerivationMethod(keyDerivationMethod);
        }
        if (keyAgreementParameter.getOriginatorPublicKey() != null) {
            this.setOriginatorPublicKey(keyAgreementParameter.getOriginatorPublicKey());
        }
        RecipientKeyInfo recipientKeyInfo = new RecipientKeyInfo(this.getDocument());
        this.setRecipientKeyInfo(recipientKeyInfo);
    }

    public AgreementMethodImpl(Document doc, String algorithm) {
        super(doc);
        URI tmpAlgorithm;
        this.agreementMethodInformation = new LinkedList<Element>();
        try {
            tmpAlgorithm = new URI(algorithm);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Algorithm [" + algorithm + "] is not URI ", ex);
        }
        this.algorithmURI = tmpAlgorithm.toString();
        this.setLocalAttribute("Algorithm", this.algorithmURI);
    }

    public AgreementMethodImpl(Element element) throws XMLSecurityException {
        super(element, "http://www.w3.org/2001/04/xmlenc#");
    }

    @Override
    public byte[] getKANonce() {
        return this.kaNonce;
    }

    @Override
    public void setKANonce(byte[] kanonce) {
        this.kaNonce = kanonce;
    }

    @Override
    public Iterator<Element> getAgreementMethodInformation() {
        return this.agreementMethodInformation.iterator();
    }

    @Override
    public void addAgreementMethodInformation(Element info) {
        this.agreementMethodInformation.add(info);
    }

    @Override
    public void removeAgreementMethodInformation(Element info) {
        this.agreementMethodInformation.remove(info);
    }

    @Override
    public KeyDerivationMethod getKeyDerivationMethod() throws XMLSecurityException {
        if (this.keyDerivationMethod != null) {
            LOG.log(System.Logger.Level.DEBUG, "Returning cached KeyDerivationMethod");
            return this.keyDerivationMethod;
        }
        Element keyDerivationMethodElement = XMLUtils.selectXenc11Node(this.getElement().getFirstChild(), "KeyDerivationMethod", 0);
        if (keyDerivationMethodElement == null) {
            LOG.log(System.Logger.Level.DEBUG, "No KeyDerivationMethod element found!");
            return null;
        }
        this.keyDerivationMethod = new KeyDerivationMethodImpl(keyDerivationMethodElement, this.baseURI);
        return this.keyDerivationMethod;
    }

    @Override
    public void setKeyDerivationMethod(KeyDerivationMethod keyDerivationMethod) {
        this.keyDerivationMethod = keyDerivationMethod;
        if (keyDerivationMethod instanceof ElementProxy) {
            this.appendSelf((ElementProxy)((Object)keyDerivationMethod));
            this.addReturnToSelf();
        } else {
            LOG.log(System.Logger.Level.WARNING, "KeyDerivationMethod [{0}] is set but is not an instance of ElementProxy. The DOM node is lost upon serialization.", keyDerivationMethod);
        }
    }

    @Override
    public OriginatorKeyInfo getOriginatorKeyInfo() throws XMLSecurityException {
        if (this.originatorKeyInfo != null) {
            LOG.log(System.Logger.Level.DEBUG, "Returning cached OriginatorKeyInfo");
            return this.originatorKeyInfo;
        }
        Element originatorKeyInfoElement = XMLUtils.selectXencNode(this.getElement().getFirstChild(), "OriginatorKeyInfo", 0);
        if (originatorKeyInfoElement == null) {
            LOG.log(System.Logger.Level.DEBUG, "No OriginatorKeyInfo element found!");
            return null;
        }
        this.originatorKeyInfo = new OriginatorKeyInfo(originatorKeyInfoElement, this.baseURI);
        return this.originatorKeyInfo;
    }

    @Override
    public void setOriginatorKeyInfo(OriginatorKeyInfo keyInfo) {
        this.originatorKeyInfo = keyInfo;
        this.appendSelf(keyInfo);
        this.addReturnToSelf();
    }

    @Override
    public void setOriginatorPublicKey(PublicKey publicKey) {
        OriginatorKeyInfo originatorKeyInfo = new OriginatorKeyInfo(this.getDocument());
        originatorKeyInfo.add(publicKey);
        this.setOriginatorKeyInfo(originatorKeyInfo);
    }

    @Override
    public RecipientKeyInfo getRecipientKeyInfo() throws XMLSecurityException {
        if (this.recipientKeyInfo != null) {
            LOG.log(System.Logger.Level.DEBUG, "Returning cached RecipientKeyInfo");
            return this.recipientKeyInfo;
        }
        Element recipientKeyInfoElement = XMLUtils.selectXencNode(this.getElement().getFirstChild(), "RecipientKeyInfo", 0);
        if (recipientKeyInfoElement == null) {
            LOG.log(System.Logger.Level.DEBUG, "No RecipientKeyInfo element found!");
            return null;
        }
        this.recipientKeyInfo = new RecipientKeyInfo(recipientKeyInfoElement, this.baseURI);
        return this.recipientKeyInfo;
    }

    @Override
    public void setRecipientKeyInfo(RecipientKeyInfo keyInfo) {
        this.recipientKeyInfo = keyInfo;
        this.appendSelf(keyInfo);
        this.addReturnToSelf();
    }

    @Override
    public String getAlgorithm() {
        if (this.algorithmURI == null) {
            this.algorithmURI = this.getLocalAttribute("Algorithm");
        }
        return this.algorithmURI;
    }

    @Override
    public String getBaseLocalName() {
        return "AgreementMethod";
    }

    private KeyDerivationMethod createKeyDerivationMethod(KeyAgreementParameters keyAgreementParameter) throws XMLEncryptionException {
        ElementProxy kdfParams;
        KeyDerivationParameters kdfParameters = keyAgreementParameter.getKeyDerivationParameter();
        if (kdfParameters == null) {
            throw new IllegalArgumentException("KeyAgreementParameters must have KeyDerivationParameters set!");
        }
        KeyDerivationMethodImpl keyDerivationMethod = new KeyDerivationMethodImpl(this.getDocument());
        keyDerivationMethod.setAlgorithm(kdfParameters.getAlgorithm());
        switch (kdfParameters.getAlgorithm()) {
            case "http://www.w3.org/2009/xmlenc11#ConcatKDF": {
                kdfParams = this.getConcatKDFParams(kdfParameters);
                break;
            }
            case "http://www.w3.org/2021/04/xmldsig-more#hkdf": {
                kdfParams = this.getHKDFParams(kdfParameters);
                break;
            }
            default: {
                throw new XMLEncryptionException("KeyDerivation.UnsupportedAlgorithm", kdfParameters.getAlgorithm(), kdfParameters.getClass().getName());
            }
        }
        keyDerivationMethod.setKDFParams((KDFParams)((Object)kdfParams));
        return keyDerivationMethod;
    }

    private ConcatKDFParamsImpl getConcatKDFParams(KeyDerivationParameters parameter) {
        if (!(parameter instanceof ConcatKDFParams)) {
            throw new IllegalArgumentException("KDF Parameter must be instance of ConcatKDFParams");
        }
        ConcatKDFParams kdfParameters = (ConcatKDFParams)parameter;
        ConcatKDFParamsImpl concatKDFParams = new ConcatKDFParamsImpl(this.getDocument());
        concatKDFParams.setDigestMethod(kdfParameters.getDigestAlgorithm());
        concatKDFParams.setAlgorithmId(kdfParameters.getAlgorithmID());
        concatKDFParams.setPartyUInfo(kdfParameters.getPartyUInfo());
        concatKDFParams.setPartyVInfo(kdfParameters.getPartyVInfo());
        concatKDFParams.setSuppPubInfo(kdfParameters.getSuppPubInfo());
        concatKDFParams.setSuppPrivInfo(kdfParameters.getSuppPrivInfo());
        return concatKDFParams;
    }

    private HKDFParamsImpl getHKDFParams(KeyDerivationParameters parameter) {
        if (!(parameter instanceof HKDFParams)) {
            throw new IllegalArgumentException("KDF Parameter must be instance of HKDFParams");
        }
        HKDFParams kdfParameters = (HKDFParams)parameter;
        HKDFParamsImpl kdfParams = new HKDFParamsImpl(this.getDocument());
        kdfParams.setPRFAlgorithm(kdfParameters.getHmacHashAlgorithm());
        Base64.Encoder base64Encoder = Base64.getEncoder();
        if (kdfParameters.getSalt() != null) {
            kdfParams.setSalt(base64Encoder.encodeToString(kdfParameters.getSalt()));
        }
        if (kdfParameters.getInfo() != null) {
            kdfParams.setInfo(base64Encoder.encodeToString(kdfParameters.getInfo()));
        }
        kdfParams.setKeyLength(kdfParameters.getKeyBitLength() / 8);
        return kdfParams;
    }
}

