/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicateLambda;
import net.sf.saxon.z.IntPredicateProxy;

public final class AnyNodeTest
extends NodeTest
implements QNameTest {
    private static final AnyNodeTest THE_INSTANCE = new AnyNodeTest();

    public static AnyNodeTest getInstance() {
        return THE_INSTANCE;
    }

    private AnyNodeTest() {
    }

    @Override
    public UType getUType() {
        return UType.ANY_NODE;
    }

    @Override
    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return nodeKind != 12;
    }

    @Override
    public IntPredicateProxy getMatcher(NodeVectorTree tree) {
        byte[] nodeKindArray = tree.getNodeKindArray();
        return IntPredicateLambda.of(nodeNr -> nodeKindArray[nodeNr] != 12);
    }

    @Override
    public boolean test(NodeInfo node) {
        return true;
    }

    @Override
    public boolean matches(StructuredQName qname) {
        return true;
    }

    @Override
    public boolean matchesFingerprint(NamePool namePool, int fp) {
        return true;
    }

    @Override
    public final double getDefaultPriority() {
        return -0.5;
    }

    public String toString() {
        return "node()";
    }

    @Override
    public String exportQNameTest() {
        return "*";
    }
}

