/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.MetricsClient;
import com.azure.resourcemanager.monitor.fluent.models.ResponseInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.ResultType;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class MetricsClientImpl
implements MetricsClient {
    private final MetricsService service;
    private final MonitorClientImpl client;

    MetricsClientImpl(MonitorClientImpl client) {
        this.service = (MetricsService)RestProxy.create(MetricsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResponseInner>> listWithResponseAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, "2018-01-01", metricnamespace, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResponseInner>> listWithResponseAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, "2018-01-01", metricnamespace, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseInner> listAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace) {
        return this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace).flatMap(res -> Mono.justOrEmpty((Object)((ResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseInner> listAsync(String resourceUri) {
        String timespan = null;
        Duration interval = null;
        String metricnames = null;
        String aggregation = null;
        Integer top = null;
        String orderBy = null;
        String filter = null;
        ResultType resultType = null;
        String metricnamespace = null;
        return this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace).flatMap(res -> Mono.justOrEmpty((Object)((ResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseInner list(String resourceUri) {
        String timespan = null;
        Duration interval = null;
        String metricnames = null;
        String aggregation = null;
        Integer top = null;
        String orderBy = null;
        String filter = null;
        ResultType resultType = null;
        String metricnamespace = null;
        return (ResponseInner)this.listAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResponseInner> listWithResponse(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Context context) {
        return (Response)this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientMetrics")
    private static interface MetricsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResponseInner>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="timespan") String var3, @QueryParam(value="interval") Duration var4, @QueryParam(value="metricnames") String var5, @QueryParam(value="aggregation") String var6, @QueryParam(value="top") Integer var7, @QueryParam(value="orderby") String var8, @QueryParam(value="$filter") String var9, @QueryParam(value="resultType") ResultType var10, @QueryParam(value="api-version") String var11, @QueryParam(value="metricnamespace") String var12, @HeaderParam(value="Accept") String var13, Context var14);
    }
}

