/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow;

import lombok.Generated;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.executor.workflow.IExecutorDelegate;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.SerialCommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class StopWorkflowInstanceExecutorDelegate
implements IExecutorDelegate<StopWorkflowInstanceOperation, Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StopWorkflowInstanceExecutorDelegate.class);
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SerialCommandDao serialCommandDao;

    @Override
    public Void execute(StopWorkflowInstanceOperation workflowInstanceControlRequest) {
        WorkflowInstance workflowInstance = workflowInstanceControlRequest.workflowInstance;
        this.exceptionIfWorkflowInstanceCannotStop(workflowInstance);
        if (workflowInstance.getState().isCanDirectStopInDB()) {
            this.directStopInDB(workflowInstance);
        } else {
            this.stopInMaster(workflowInstance);
        }
        return null;
    }

    void exceptionIfWorkflowInstanceCannotStop(WorkflowInstance workflowInstance) {
        WorkflowExecutionStatus workflowInstanceState = workflowInstance.getState();
        if (workflowInstanceState.isCanStop()) {
            return;
        }
        throw new ServiceException("The workflow instance: " + workflowInstance.getName() + " status is " + workflowInstanceState + ", can not stop");
    }

    void directStopInDB(WorkflowInstance workflowInstance) {
        this.transactionTemplate.execute(status -> {
            this.workflowInstanceDao.updateWorkflowInstanceState(workflowInstance.getId(), workflowInstance.getState(), WorkflowExecutionStatus.STOP);
            this.serialCommandDao.deleteByWorkflowInstanceId(workflowInstance.getId());
            return null;
        });
        log.info("Update workflow instance {} state from: {} to {} success", new Object[]{workflowInstance.getName(), workflowInstance.getState().name(), WorkflowExecutionStatus.STOP.name()});
    }

    void stopInMaster(WorkflowInstance workflowInstance) {
        try {
            WorkflowInstanceStopResponse stopResponse = ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(workflowInstance.getHost())).stopWorkflowInstance(new WorkflowInstanceStopRequest(workflowInstance.getId()));
            if (stopResponse == null || !stopResponse.isSuccess()) {
                throw new ServiceException("WorkflowInstance: " + workflowInstance.getName() + " stop failed: " + stopResponse);
            }
            log.info("WorkflowInstance: {} stop success", (Object)workflowInstance.getName());
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(String.format("WorkflowInstance: %s stop failed", workflowInstance.getName()), e);
        }
    }

    public static class StopWorkflowInstanceOperation {
        private final StopWorkflowInstanceExecutorDelegate stopWorkflowInstanceExecutorDelegate;
        private WorkflowInstance workflowInstance;
        private User executeUser;

        public StopWorkflowInstanceOperation(StopWorkflowInstanceExecutorDelegate stopWorkflowInstanceExecutorDelegate) {
            this.stopWorkflowInstanceExecutorDelegate = stopWorkflowInstanceExecutorDelegate;
        }

        public StopWorkflowInstanceOperation onWorkflowInstance(WorkflowInstance workflowInstance) {
            this.workflowInstance = workflowInstance;
            return this;
        }

        public StopWorkflowInstanceOperation byUser(User executeUser) {
            this.executeUser = executeUser;
            return this;
        }

        public void execute() {
            this.stopWorkflowInstanceExecutorDelegate.execute(this);
        }
    }
}

