/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.WorkflowLineageService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.dao.entity.DependentLineageTask;
import org.apache.dolphinscheduler.dao.entity.DependentWorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkFlowLineage;
import org.apache.dolphinscheduler.dao.entity.WorkFlowRelation;
import org.apache.dolphinscheduler.dao.entity.WorkFlowRelationDetail;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskLineage;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.repository.WorkflowTaskLineageDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WorkflowLineageServiceImpl
extends BaseServiceImpl
implements WorkflowLineageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowLineageServiceImpl.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private WorkflowTaskLineageDao workflowTaskLineageDao;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;

    @Override
    public List<WorkFlowRelationDetail> queryWorkFlowLineageByName(long projectCode, String workflowDefinitionName) {
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            throw new ServiceException(Status.PROJECT_NOT_FOUND, projectCode);
        }
        return this.workflowTaskLineageDao.queryWorkFlowLineageByName(projectCode, workflowDefinitionName);
    }

    @Override
    public WorkFlowLineage queryWorkFlowLineageByCode(long projectCode, long workflowDefinitionCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            throw new ServiceException(Status.PROJECT_NOT_FOUND, projectCode);
        }
        List upstreamWorkflowTaskLineageList = this.workflowTaskLineageDao.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        List downstreamWorkflowTaskLineageList = this.workflowTaskLineageDao.queryWorkFlowLineageByDept(projectCode, workflowDefinitionCode, 0L);
        List<WorkflowTaskLineage> totalWorkflowTaskLineageList = Stream.of(upstreamWorkflowTaskLineageList, downstreamWorkflowTaskLineageList).flatMap(Collection::stream).collect(Collectors.toList());
        List<WorkFlowRelation> workFlowRelationList = this.getWorkFlowRelations(totalWorkflowTaskLineageList);
        List<WorkFlowRelationDetail> workFlowRelationDetailList = this.getWorkflowRelationDetails(totalWorkflowTaskLineageList.stream().flatMap(pl -> {
            ArrayList<Long> workflowDefinitionCodes = new ArrayList<Long>();
            workflowDefinitionCodes.add(pl.getWorkflowDefinitionCode());
            workflowDefinitionCodes.add(pl.getDeptWorkflowDefinitionCode());
            return workflowDefinitionCodes.stream();
        }).distinct().collect(Collectors.toList()));
        WorkFlowLineage workFlowLineage = new WorkFlowLineage();
        workFlowLineage.setWorkFlowRelationDetailList(workFlowRelationDetailList);
        workFlowLineage.setWorkFlowRelationList(workFlowRelationList);
        return workFlowLineage;
    }

    @Override
    public WorkFlowLineage queryWorkFlowLineage(long projectCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            throw new ServiceException(Status.PROJECT_NOT_FOUND, projectCode);
        }
        List workflowTaskLineageList = this.workflowTaskLineageDao.queryByProjectCode(projectCode);
        List<WorkFlowRelation> workFlowRelationList = this.getWorkFlowRelations(workflowTaskLineageList);
        List<WorkFlowRelationDetail> workFlowRelationDetailList = this.getWorkflowRelationDetails(workflowTaskLineageList.stream().flatMap(pl -> {
            ArrayList<Long> workflowDefinitionCodes = new ArrayList<Long>();
            workflowDefinitionCodes.add(pl.getWorkflowDefinitionCode());
            workflowDefinitionCodes.add(pl.getDeptWorkflowDefinitionCode());
            return workflowDefinitionCodes.stream();
        }).distinct().collect(Collectors.toList()));
        WorkFlowLineage workFlowLineage = new WorkFlowLineage();
        workFlowLineage.setWorkFlowRelationList(workFlowRelationList);
        workFlowLineage.setWorkFlowRelationDetailList(workFlowRelationDetailList);
        return workFlowLineage;
    }

    private List<WorkFlowRelation> getWorkFlowRelations(List<WorkflowTaskLineage> workflowTaskLineageList) {
        ArrayList<WorkFlowRelation> workFlowRelations = new ArrayList<WorkFlowRelation>();
        List workflowDefinitionCodes = workflowTaskLineageList.stream().map(WorkflowTaskLineage::getWorkflowDefinitionCode).distinct().collect(Collectors.toList());
        for (WorkflowTaskLineage workflowTaskLineage : workflowTaskLineageList) {
            workFlowRelations.add(new WorkFlowRelation(workflowTaskLineage.getDeptWorkflowDefinitionCode(), workflowTaskLineage.getWorkflowDefinitionCode()));
            if (workflowDefinitionCodes.contains(workflowTaskLineage.getDeptWorkflowDefinitionCode())) continue;
            workFlowRelations.add(new WorkFlowRelation(0L, workflowTaskLineage.getWorkflowDefinitionCode()));
        }
        return workFlowRelations;
    }

    private List<WorkFlowRelationDetail> getWorkflowRelationDetails(List<Long> workflowDefinitionCodes) {
        ArrayList<WorkFlowRelationDetail> workFlowRelationDetails = new ArrayList<WorkFlowRelationDetail>();
        for (Long workflowDefinitionCode : workflowDefinitionCodes) {
            List workFlowRelationDetailList = this.workflowTaskLineageDao.queryWorkFlowLineageByCode(workflowDefinitionCode.longValue());
            workFlowRelationDetails.addAll(workFlowRelationDetailList);
        }
        return workFlowRelationDetails;
    }

    @Override
    public Optional<String> taskDependentMsg(long projectCode, long workflowDefinitionCode, long taskCode) {
        List dependentWorkflowList;
        long queryTaskCode = 0L;
        if (taskCode != 0L) {
            queryTaskCode = taskCode;
        }
        if (CollectionUtils.isEmpty((Collection)(dependentWorkflowList = this.workflowTaskLineageDao.queryWorkFlowLineageByDept(projectCode, workflowDefinitionCode, queryTaskCode)))) {
            return Optional.empty();
        }
        ArrayList<String> taskDepStrList = new ArrayList<String>();
        for (WorkflowTaskLineage workflowTaskLineage : dependentWorkflowList) {
            WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowTaskLineage.getDeptWorkflowDefinitionCode());
            String taskName = "";
            if (workflowTaskLineage.getTaskDefinitionCode() != 0L) {
                TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(workflowTaskLineage.getTaskDefinitionCode());
                if (taskDefinition == null) {
                    log.warn("Orphaned lineage record detected: taskDefinitionCode {} not found, workflowTaskLineageId: {}. This dirty data should be cleaned up by a background task.", (Object)workflowTaskLineage.getTaskDefinitionCode(), (Object)workflowTaskLineage.getId());
                    continue;
                }
                taskName = taskDefinition.getName();
            }
            taskDepStrList.add(String.format("%s:%s", workflowDefinition.getName(), taskName));
        }
        if (taskDepStrList.isEmpty()) {
            return Optional.empty();
        }
        String taskDepStr = String.join((CharSequence)",", taskDepStrList);
        if (taskCode != 0L) {
            TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
            return Optional.of(MessageFormat.format(Status.DELETE_TASK_USE_BY_OTHER_FAIL.getMsg(), taskDefinition.getName(), taskDepStr));
        }
        return Optional.of(MessageFormat.format(Status.DELETE_TASK_USE_BY_OTHER_FAIL.getMsg(), "", taskDepStr));
    }

    @Override
    public List<DependentWorkflowDefinition> queryDownstreamDependentWorkflowDefinitions(Long workflowDefinitionCode) {
        ArrayList<DependentWorkflowDefinition> dependentWorkflowDefinitionList = new ArrayList<DependentWorkflowDefinition>();
        List workflowTaskLineageList = this.workflowTaskLineageDao.queryWorkFlowLineageByDept(0L, workflowDefinitionCode.longValue(), 0L);
        if (workflowTaskLineageList.isEmpty()) {
            return dependentWorkflowDefinitionList;
        }
        List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes((Collection)workflowTaskLineageList.stream().map(WorkflowTaskLineage::getWorkflowDefinitionCode).distinct().collect(Collectors.toList()));
        List taskDefinitionList = this.taskDefinitionMapper.queryByCodeList((Collection)workflowTaskLineageList.stream().map(WorkflowTaskLineage::getTaskDefinitionCode).filter(code -> code != 0L).distinct().collect(Collectors.toList()));
        for (WorkflowTaskLineage workflowLineage : workflowTaskLineageList) {
            DependentWorkflowDefinition dependentWorkflowDefinition = new DependentWorkflowDefinition();
            dependentWorkflowDefinition.setWorkflowDefinitionCode(workflowLineage.getWorkflowDefinitionCode());
            dependentWorkflowDefinition.setTaskDefinitionCode(workflowLineage.getTaskDefinitionCode());
            if (workflowLineage.getTaskDefinitionCode() != 0L) {
                taskDefinitionList.stream().filter(taskDefinition -> taskDefinition.getCode() == workflowLineage.getTaskDefinitionCode()).findFirst().ifPresent(taskDefinition -> {
                    dependentWorkflowDefinition.setTaskParams(taskDefinition.getTaskParams());
                    dependentWorkflowDefinition.setWorkerGroup(taskDefinition.getWorkerGroup());
                });
            }
            workflowDefinitionList.stream().filter(workflowDefinition -> workflowDefinition.getCode() == workflowLineage.getWorkflowDefinitionCode()).findFirst().ifPresent(workflowDefinition -> dependentWorkflowDefinition.setWorkflowDefinitionVersion(workflowDefinition.getVersion()));
            dependentWorkflowDefinitionList.add(dependentWorkflowDefinition);
        }
        return dependentWorkflowDefinitionList;
    }

    @Override
    public List<DependentLineageTask> queryDependentWorkflowDefinitions(long projectCode, long workflowDefinitionCode, Long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            throw new ServiceException(Status.PROJECT_NOT_FOUND, projectCode);
        }
        ArrayList<DependentLineageTask> dependentLineageTaskList = new ArrayList<DependentLineageTask>();
        List workflowTaskLineageList = this.workflowTaskLineageDao.queryWorkFlowLineageByDept(projectCode, workflowDefinitionCode, taskCode == null ? 0L : taskCode);
        if (workflowTaskLineageList.isEmpty()) {
            return dependentLineageTaskList;
        }
        List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes((Collection)workflowTaskLineageList.stream().map(WorkflowTaskLineage::getWorkflowDefinitionCode).distinct().collect(Collectors.toList()));
        List taskDefinitionList = this.taskDefinitionMapper.queryByCodeList((Collection)workflowTaskLineageList.stream().map(WorkflowTaskLineage::getTaskDefinitionCode).filter(code -> code != 0L).distinct().collect(Collectors.toList()));
        for (WorkflowTaskLineage workflowTaskLineage : workflowTaskLineageList) {
            DependentLineageTask dependentLineageTask = new DependentLineageTask();
            taskDefinitionList.stream().filter(taskDefinition -> taskDefinition.getCode() == workflowTaskLineage.getTaskDefinitionCode()).findFirst().ifPresent(taskDefinition -> {
                dependentLineageTask.setTaskDefinitionCode(taskDefinition.getCode());
                dependentLineageTask.setTaskDefinitionName(taskDefinition.getName());
            });
            workflowDefinitionList.stream().filter(workflowDefinition -> workflowDefinition.getCode() == workflowTaskLineage.getWorkflowDefinitionCode()).findFirst().ifPresent(workflowDefinition -> {
                dependentLineageTask.setWorkflowDefinitionCode(workflowDefinition.getCode());
                dependentLineageTask.setWorkflowDefinitionName(workflowDefinition.getName());
                dependentLineageTask.setProjectCode(workflowDefinition.getProjectCode());
            });
            dependentLineageTaskList.add(dependentLineageTask);
        }
        return dependentLineageTaskList;
    }

    @Override
    public int createWorkflowLineage(List<WorkflowTaskLineage> workflowTaskLineages) {
        return this.workflowTaskLineageDao.batchInsert(workflowTaskLineages);
    }

    @Override
    public int updateWorkflowLineage(long workflowDefinitionCode, List<WorkflowTaskLineage> workflowTaskLineages) {
        this.workflowTaskLineageDao.batchDeleteByWorkflowDefinitionCode(Collections.singletonList(workflowDefinitionCode));
        if (CollectionUtils.isEmpty(workflowTaskLineages)) {
            log.info("Current lineage is empty, workflowDefinitionCode: {}", (Object)workflowDefinitionCode);
            return 0;
        }
        int insertResult = this.workflowTaskLineageDao.batchInsert(workflowTaskLineages);
        if (insertResult <= 0) {
            log.error("Save workflow lineage error, workflowDefinitionCode: {}", (Object)workflowDefinitionCode);
            throw new ServiceException(Status.CREATE_WORKFLOW_LINEAGE_ERROR);
        }
        log.info("Save workflow lineage complete, workflowDefinitionCode: {}, inserted rows: {}", (Object)workflowDefinitionCode, (Object)insertResult);
        return insertResult;
    }

    @Override
    public int deleteWorkflowLineage(List<Long> workflowDefinitionCodes) {
        return this.workflowTaskLineageDao.batchDeleteByWorkflowDefinitionCode(workflowDefinitionCodes);
    }
}

