/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.privatedns.fluent.RecordSetsClient;
import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsManagementClientImpl;
import com.azure.resourcemanager.privatedns.models.RecordSetListResult;
import com.azure.resourcemanager.privatedns.models.RecordType;
import reactor.core.publisher.Mono;

public final class RecordSetsClientImpl
implements RecordSetsClient {
    private final RecordSetsService service;
    private final PrivateDnsManagementClientImpl client;

    RecordSetsClientImpl(PrivateDnsManagementClientImpl client) {
        this.service = (RecordSetsService)RestProxy.create(RecordSetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner createOrUpdate(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (RecordSetInner)((Object)this.createOrUpdateAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, ifNoneMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> createOrUpdateWithResponse(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, ifNoneMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> updateWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> updateWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> updateAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch) {
        return this.updateWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> updateAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters) {
        String ifMatch = null;
        return this.updateWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner update(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters) {
        String ifMatch = null;
        return (RecordSetInner)((Object)this.updateAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> updateWithResponse(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, RecordSetInner parameters, String ifMatch, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        String ifMatch = null;
        return this.deleteWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        String ifMatch = null;
        this.deleteAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> getWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> getWithResponseAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, relativeRecordSetName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> getAsync(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        return this.getWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner get(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        return (RecordSetInner)((Object)this.getAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> getWithResponse(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(String resourceGroupName, String privateZoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByType(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(String resourceGroupName, String privateZoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByType(this.client.getEndpoint(), resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String privateZoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String privateZoneName, RecordType recordType) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String privateZoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix, context), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(String resourceGroupName, String privateZoneName, RecordType recordType) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedIterable(this.listByTypeAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(String resourceGroupName, String privateZoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedIterable(this.listByTypeAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listSinglePageAsync(String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, privateZoneName, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listSinglePageAsync(String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, privateZoneName, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAsync(String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAsync(String resourceGroupName, String privateZoneName) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listAsync(String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> list(String resourceGroupName, String privateZoneName) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedIterable(this.listAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> list(String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTypeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTypeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PrivateDnsManagement")
    private static interface RecordSetsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="recordType") RecordType var4, @PathParam(value="relativeRecordSetName", encoded=true) String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @BodyParam(value="application/json") RecordSetInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="recordType") RecordType var4, @PathParam(value="relativeRecordSetName", encoded=true) String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") RecordSetInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="recordType") RecordType var4, @PathParam(value="relativeRecordSetName", encoded=true) String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="recordType") RecordType var4, @PathParam(value="relativeRecordSetName", encoded=true) String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByType(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="recordType") RecordType var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$recordsetnamesuffix") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/ALL")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$recordsetnamesuffix") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByTypeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

