/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.authentication.aws.AmazonS3ClientFactory;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3RemoteLogHandler
implements RemoteLogHandler,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3RemoteLogHandler.class);
    private final String bucketName = this.readBucketName();
    private final AmazonS3 s3Client = this.buildS3Client();
    private static S3RemoteLogHandler instance;

    private S3RemoteLogHandler() {
        this.checkBucketNameExists(this.bucketName);
    }

    public static synchronized S3RemoteLogHandler getInstance() {
        if (instance == null) {
            instance = new S3RemoteLogHandler();
        }
        return instance;
    }

    protected AmazonS3 buildS3Client() {
        Map<String, String> awsProperties = PropertyUtils.getByPrefix("aws.s3.", "");
        return AmazonS3ClientFactory.createAmazonS3Client(awsProperties);
    }

    @Override
    public void close() throws IOException {
        this.s3Client.shutdown();
    }

    @Override
    public void sendRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("send remote log {} to S3 {}", (Object)logPath, (Object)objectName);
            this.s3Client.putObject(this.bucketName, objectName, new File(logPath));
        }
        catch (Exception e) {
            log.error("error while sending remote log {} to S3 {}", new Object[]{logPath, objectName, e});
        }
    }

    @Override
    public void getRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("get remote log on S3 {} to {}", (Object)objectName, (Object)logPath);
            S3Object o = this.s3Client.getObject(this.bucketName, objectName);
            try (S3ObjectInputStream s3is = o.getObjectContent();
                 FileOutputStream fos = new FileOutputStream(logPath);){
                byte[] readBuf = new byte[1024];
                int readLen = 0;
                while ((readLen = s3is.read(readBuf)) > 0) {
                    fos.write(readBuf, 0, readLen);
                }
            }
        }
        catch (Exception e) {
            log.error("error while getting remote log on S3 {} to {}", new Object[]{objectName, logPath, e});
        }
    }

    protected String readBucketName() {
        return PropertyUtils.getString("aws.s3.bucket.name");
    }

    public void checkBucketNameExists(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("remote.logging.s3.bucket.name is blank");
        }
        boolean existsBucket = this.s3Client.doesBucketExistV2(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found, the current regionName is {}", (Object)bucketName, (Object)this.s3Client.getRegionName());
    }
}

