/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

final class DateTimeSerializer
extends JsonSerializer<OffsetDateTime> {
    private static final SimpleModule MODULE = new SimpleModule().addSerializer(OffsetDateTime.class, (JsonSerializer)new DateTimeSerializer());

    DateTimeSerializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    public void serialize(OffsetDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeNumber(value.toInstant().toEpochMilli());
        } else {
            jgen.writeString(DateTimeSerializer.toString(value));
        }
    }

    public static String toString(OffsetDateTime offsetDateTime) {
        String result = null;
        if (offsetDateTime != null && (result = DateTimeFormatter.ISO_INSTANT.format(offsetDateTime = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC))).startsWith("+")) {
            result = result.substring(1);
        }
        return result;
    }
}

