/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.journalentry.data.ClientTransactionDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForClientTransactions;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.organisation.office.domain.Office;
import org.springframework.stereotype.Component;

@Component
public class CashBasedAccountingProcessorForClientTransactions
implements AccountingProcessorForClientTransactions {
    private final AccountingProcessorHelper helper;

    public void createJournalEntriesForClientTransaction(ClientTransactionDTO clientTransactionDTO) {
        if (clientTransactionDTO.isAccountingEnabled()) {
            GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(clientTransactionDTO.getOfficeId().longValue());
            LocalDate transactionDate = clientTransactionDTO.getTransactionDate();
            Office office = this.helper.getOfficeById(clientTransactionDTO.getOfficeId().longValue());
            this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
            if (clientTransactionDTO.isChargePayment()) {
                this.createJournalEntriesForChargePayments(clientTransactionDTO, office);
            }
        }
    }

    private void createJournalEntriesForChargePayments(ClientTransactionDTO clientTransactionDTO, Office office) {
        Long clientId = clientTransactionDTO.getClientId();
        String currencyCode = clientTransactionDTO.getCurrencyCode();
        Long transactionId = clientTransactionDTO.getTransactionId();
        LocalDate transactionDate = clientTransactionDTO.getTransactionDate();
        BigDecimal amount = clientTransactionDTO.getAmount();
        boolean isReversal = clientTransactionDTO.isReversed();
        if (amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal totalCreditedAmount = this.helper.createCreditJournalEntryOrReversalForClientPayments(office, currencyCode, clientId, transactionId, transactionDate, Boolean.valueOf(isReversal), clientTransactionDTO.getChargePayments());
            this.helper.createDebitJournalEntryOrReversalForClientChargePayments(office, currencyCode, clientId, transactionId, transactionDate, totalCreditedAmount, Boolean.valueOf(isReversal));
        }
    }

    @Generated
    public CashBasedAccountingProcessorForClientTransactions(AccountingProcessorHelper helper) {
        this.helper = helper;
    }
}

