/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccount;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccountRepositoryWrapper;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.accounting.glaccount.service.GLAccountReadPlatformService;
import org.apache.fineract.accounting.journalentry.data.JournalEntryAssociationParametersData;
import org.apache.fineract.accounting.journalentry.data.JournalEntryData;
import org.apache.fineract.accounting.journalentry.data.OfficeOpeningBalancesData;
import org.apache.fineract.accounting.journalentry.exception.JournalEntriesNotFoundException;
import org.apache.fineract.accounting.journalentry.service.JournalEntryReadPlatformService;
import org.apache.fineract.accounting.journalentry.service.JournalEntryReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class JournalEntryReadPlatformServiceImpl
implements JournalEntryReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final GLAccountReadPlatformService glAccountReadPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final ColumnValidator columnValidator;
    private final FinancialActivityAccountRepositoryWrapper financialActivityAccountRepositoryWrapper;
    private final PaginationHelper paginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public Page<JournalEntryData> retrieveAll(SearchParameters searchParameters, Long glAccountId, Boolean onlyManualEntries, LocalDate fromDate, LocalDate toDate, LocalDate submittedOnDateFrom, LocalDate submittedOnDateTo, String transactionId, Integer entityType, JournalEntryAssociationParametersData associationParametersData) {
        GLJournalEntryMapper rm = this.getGlJournalEntryMapper(associationParametersData);
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select ").append(this.sqlGenerator.calcFoundRows()).append(" ");
        sqlBuilder.append(rm.schema());
        Object[] objectArray = new Object[15];
        int arrayPos = 0;
        String whereClose = " where ";
        if (StringUtils.isNotBlank((CharSequence)transactionId)) {
            sqlBuilder.append(whereClose).append(" journalEntry.transaction_id = ?");
            objectArray[arrayPos] = transactionId;
            ++arrayPos;
            whereClose = " and ";
        }
        if (entityType != null && entityType != 0 && onlyManualEntries == null) {
            sqlBuilder.append(whereClose).append(" journalEntry.entity_type_enum = ?");
            objectArray[arrayPos] = entityType;
            ++arrayPos;
            whereClose = " and ";
        }
        if (searchParameters.hasOfficeId()) {
            sqlBuilder.append(whereClose).append(" journalEntry.office_id = ?");
            objectArray[arrayPos] = searchParameters.getOfficeId();
            ++arrayPos;
            whereClose = " and ";
        }
        if (searchParameters.hasCurrencyCode()) {
            sqlBuilder.append(whereClose).append(" journalEntry.currency_code = ?");
            objectArray[arrayPos] = searchParameters.getCurrencyCode();
            ++arrayPos;
            whereClose = " and ";
        }
        if (glAccountId != null && glAccountId != 0L) {
            sqlBuilder.append(whereClose).append(" journalEntry.account_id = ?");
            objectArray[arrayPos] = glAccountId;
            ++arrayPos;
            whereClose = " and ";
        }
        if (fromDate != null || toDate != null) {
            if (fromDate != null && toDate != null) {
                sqlBuilder.append(whereClose).append(" journalEntry.entry_date between ? and ? ");
                whereClose = " and ";
                objectArray[arrayPos] = fromDate;
                objectArray[++arrayPos] = toDate;
                ++arrayPos;
            } else if (fromDate != null) {
                sqlBuilder.append(whereClose).append(" journalEntry.entry_date >= ? ");
                whereClose = " and ";
                objectArray[arrayPos] = fromDate;
                ++arrayPos;
            } else {
                sqlBuilder.append(whereClose).append(" journalEntry.entry_date <= ? ");
                whereClose = " and ";
                objectArray[arrayPos] = toDate;
                ++arrayPos;
            }
        }
        if (submittedOnDateFrom != null || submittedOnDateTo != null) {
            if (submittedOnDateFrom != null && submittedOnDateTo != null) {
                sqlBuilder.append(whereClose).append(" journalEntry.submitted_on_date between ? and ? ");
                whereClose = " and ";
                objectArray[arrayPos] = submittedOnDateFrom;
                objectArray[++arrayPos] = submittedOnDateTo;
                ++arrayPos;
            } else if (fromDate != null) {
                sqlBuilder.append(whereClose).append(" journalEntry.submitted_on_date >= ? ");
                whereClose = " and ";
                objectArray[arrayPos] = submittedOnDateFrom;
                ++arrayPos;
            } else {
                sqlBuilder.append(whereClose).append(" journalEntry.submitted_on_date <= ? ");
                whereClose = " and ";
                objectArray[arrayPos] = submittedOnDateTo;
                ++arrayPos;
            }
        }
        if (onlyManualEntries != null && onlyManualEntries.booleanValue()) {
            sqlBuilder.append(whereClose).append(" journalEntry.manual_entry = ?");
            whereClose = " and ";
            objectArray[arrayPos] = Boolean.TRUE;
            ++arrayPos;
        }
        if (searchParameters.hasLoanId()) {
            sqlBuilder.append(whereClose).append(" journalEntry.loan_transaction_id  in (select id from m_loan_transaction where loan_id = ?)");
            objectArray[arrayPos] = searchParameters.getLoanId();
            ++arrayPos;
            whereClose = " and ";
        }
        if (searchParameters.hasSavingsId()) {
            sqlBuilder.append(whereClose).append(" journalEntry.savings_transaction_id in (select id from m_savings_account_transaction where savings_account_id = ?)");
            objectArray[arrayPos] = searchParameters.getSavingsId();
            ++arrayPos;
        }
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            }
        } else {
            sqlBuilder.append(" order by journalEntry.entry_date, journalEntry.id");
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        Object[] finalObjectArray = Arrays.copyOf(objectArray, arrayPos);
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)rm);
    }

    protected GLJournalEntryMapper getGlJournalEntryMapper(JournalEntryAssociationParametersData associationParametersData) {
        return new GLJournalEntryMapper(associationParametersData);
    }

    public JournalEntryData retrieveGLJournalEntryById(long glJournalEntryId, JournalEntryAssociationParametersData associationParametersData) {
        try {
            GLJournalEntryMapper rm = this.getGlJournalEntryMapper(associationParametersData);
            String sql = "select " + rm.schema() + " where journalEntry.id = ?";
            return (JournalEntryData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{glJournalEntryId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new JournalEntriesNotFoundException(Long.valueOf(glJournalEntryId), e);
        }
    }

    public OfficeOpeningBalancesData retrieveOfficeOpeningBalances(Long officeId, String currencyCode) {
        FinancialActivityAccount financialActivityAccountId = this.financialActivityAccountRepositoryWrapper.findByFinancialActivityTypeWithNotFoundDetection(300);
        Long contraId = (Long)financialActivityAccountId.getGlAccount().getId();
        if (contraId == null) {
            throw new GeneralPlatformDomainRuleException("error.msg.financial.activity.mapping.opening.balance.contra.account.cannot.be.null", "office-opening-balances-contra-account value can not be null", new Object[]{"office-opening-balances-contra-account"});
        }
        JournalEntryAssociationParametersData associationParametersData = new JournalEntryAssociationParametersData();
        GLAccountData contraAccount = this.glAccountReadPlatformService.retrieveGLAccountById(contraId.longValue(), associationParametersData);
        if (!GLAccountType.fromInt((Integer)Objects.requireNonNull((Long)Objects.requireNonNull(contraAccount.getType()).getId()).intValue()).isEquityType()) {
            throw new GeneralPlatformDomainRuleException("error.msg.configuration.opening.balance.contra.account.value.is.invalid.account.type", "Global configuration 'office-opening-balances-contra-account' value is not an equity type account", new Object[]{contraId});
        }
        OfficeData officeData = this.officeReadPlatformService.retrieveOffice(officeId);
        List allOpeningTransactions = this.populateAllTransactionsFromGLAccounts(contraId);
        String contraTransactionId = this.retrieveContraAccountTransactionId(officeId, contraId, currencyCode);
        List existingOpeningBalanceTransactions = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)contraTransactionId)) {
            existingOpeningBalanceTransactions = this.retrieveOfficeBalanceTransactions(officeId, contraTransactionId, currencyCode);
        }
        List transactions = this.populateOpeningBalances(existingOpeningBalanceTransactions, allOpeningTransactions);
        ArrayList<JournalEntryData> assetAccountOpeningBalances = new ArrayList<JournalEntryData>();
        ArrayList<JournalEntryData> liabilityAccountOpeningBalances = new ArrayList<JournalEntryData>();
        ArrayList<JournalEntryData> incomeAccountOpeningBalances = new ArrayList<JournalEntryData>();
        ArrayList<JournalEntryData> equityAccountOpeningBalances = new ArrayList<JournalEntryData>();
        ArrayList<JournalEntryData> expenseAccountOpeningBalances = new ArrayList<JournalEntryData>();
        for (JournalEntryData journalEntryData : transactions) {
            GLAccountType type = GLAccountType.fromInt((Integer)((Long)journalEntryData.getGlAccountType().getId()).intValue());
            if (type.isAssetType()) {
                assetAccountOpeningBalances.add(journalEntryData);
                continue;
            }
            if (type.isLiabilityType()) {
                liabilityAccountOpeningBalances.add(journalEntryData);
                continue;
            }
            if (type.isEquityType()) {
                equityAccountOpeningBalances.add(journalEntryData);
                continue;
            }
            if (type.isIncomeType()) {
                incomeAccountOpeningBalances.add(journalEntryData);
                continue;
            }
            if (!type.isExpenseType()) continue;
            expenseAccountOpeningBalances.add(journalEntryData);
        }
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        return OfficeOpeningBalancesData.createNew((Long)officeId, (String)officeData.getName(), (LocalDate)transactionDate, (GLAccountData)contraAccount, assetAccountOpeningBalances, liabilityAccountOpeningBalances, incomeAccountOpeningBalances, equityAccountOpeningBalances, expenseAccountOpeningBalances);
    }

    private List<JournalEntryData> populateOpeningBalances(List<JournalEntryData> existingOpeningBalanceTransactions, List<JournalEntryData> allOpeningTransactions) {
        ArrayList<JournalEntryData> allOpeningBalanceTransactions = new ArrayList<JournalEntryData>(allOpeningTransactions.size());
        for (JournalEntryData newOpeningBalanceTransaction : allOpeningTransactions) {
            boolean isNewTransactionAddedToCollection = false;
            for (JournalEntryData existingOpeningBalanceTransaction : existingOpeningBalanceTransactions) {
                if (!newOpeningBalanceTransaction.getGlAccountId().equals(existingOpeningBalanceTransaction.getGlAccountId())) continue;
                allOpeningBalanceTransactions.add(existingOpeningBalanceTransaction);
                isNewTransactionAddedToCollection = true;
                break;
            }
            if (isNewTransactionAddedToCollection) continue;
            allOpeningBalanceTransactions.add(newOpeningBalanceTransaction);
        }
        return allOpeningBalanceTransactions;
    }

    private List<JournalEntryData> populateAllTransactionsFromGLAccounts(Long contraId) {
        List glAccounts = this.glAccountReadPlatformService.retrieveAllEnabledDetailGLAccounts();
        ArrayList<JournalEntryData> openingBalanceTransactions = new ArrayList<JournalEntryData>(glAccounts.size());
        for (GLAccountData glAccountData : glAccounts) {
            if (contraId.equals(glAccountData.getId())) continue;
            JournalEntryData openingBalanceTransaction = JournalEntryData.fromGLAccountData((GLAccountData)glAccountData);
            openingBalanceTransactions.add(openingBalanceTransaction);
        }
        return openingBalanceTransactions;
    }

    private List<JournalEntryData> retrieveOfficeBalanceTransactions(Long officeId, String transactionId, String currencyCode) {
        Long contraId = null;
        return this.retrieveContraTransactions(officeId, contraId, transactionId, currencyCode).getPageItems();
    }

    private String retrieveContraAccountTransactionId(Long officeId, Long contraId, String currencyCode) {
        String transactionId = "";
        Page contraJournalEntries = this.retrieveContraTransactions(officeId, contraId, "", currencyCode);
        if (!CollectionUtils.isEmpty((Collection)contraJournalEntries.getPageItems())) {
            JournalEntryData contraTransaction = (JournalEntryData)contraJournalEntries.getPageItems().get(contraJournalEntries.getPageItems().size() - 1);
            return contraTransaction.getTransactionId();
        }
        return "";
    }

    private Page<JournalEntryData> retrieveContraTransactions(Long officeId, Long contraId, String transactionId, String currencyCode) {
        Integer entityType = null;
        Boolean onlyManualEntries = null;
        LocalDate fromDate = null;
        LocalDate toDate = null;
        LocalDate submittedOnDateFrom = null;
        LocalDate submittedOnDateTo = null;
        JournalEntryAssociationParametersData associationParametersData = null;
        SearchParameters searchParameters = SearchParameters.builder().orphansOnly(Boolean.valueOf(false)).officeId(officeId).offset(Integer.valueOf(0)).orderBy("journalEntry.id").sortOrder("ASC").currencyCode(currencyCode).build();
        return this.retrieveAll(searchParameters, contraId, onlyManualEntries, fromDate, toDate, submittedOnDateFrom, submittedOnDateTo, transactionId, entityType, associationParametersData);
    }

    public Page<JournalEntryData> retrieveJournalEntriesByEntityId(String transactionId, Long entityId, Integer entityType) {
        JournalEntryAssociationParametersData associationParametersData = new JournalEntryAssociationParametersData(true, true);
        try {
            GLJournalEntryMapper rm = this.getGlJournalEntryMapper(associationParametersData);
            String sql = "select " + rm.schema() + " where journalEntry.transaction_id = ? and journalEntry.entity_id = ? and journalEntry.entity_type_enum = ?";
            Object[] data = new Object[]{transactionId, entityId, entityType};
            return this.paginationHelper.fetchPage(this.jdbcTemplate, sql, data, (RowMapper)rm);
        }
        catch (EmptyResultDataAccessException e) {
            throw new JournalEntriesNotFoundException(entityId, e);
        }
    }

    @Generated
    public JournalEntryReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, GLAccountReadPlatformService glAccountReadPlatformService, OfficeReadPlatformService officeReadPlatformService, ColumnValidator columnValidator, FinancialActivityAccountRepositoryWrapper financialActivityAccountRepositoryWrapper, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.jdbcTemplate = jdbcTemplate;
        this.glAccountReadPlatformService = glAccountReadPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.columnValidator = columnValidator;
        this.financialActivityAccountRepositoryWrapper = financialActivityAccountRepositoryWrapper;
        this.paginationHelper = paginationHelper;
        this.sqlGenerator = sqlGenerator;
    }
}

