/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.api.MutableUriInfo;
import org.apache.fineract.infrastructure.dataqueries.api.DatatablesApiResource;
import org.springframework.stereotype.Component;

@Component
public class GetDatatableEntryByAppTableIdAndDataTableIdCommandStrategy
implements CommandStrategy {
    private final DatatablesApiResource dataTablesApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        MutableUriInfo parameterizedUriInfo = new MutableUriInfo(uriInfo);
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        String relativeUrlSubString = StringUtils.substringAfter((String)relativeUrl, (String)"/");
        String[] resources = StringUtils.split((String)relativeUrlSubString, (String)"/");
        String dataTableName = resources[0];
        Long appTableId = Long.parseLong(resources[1]);
        Long dataTableId = Long.parseLong(StringUtils.substringBefore((String)resources[2], (String)"?"));
        boolean genericResultSet = false;
        if (relativeUrl.indexOf(63) > 0) {
            Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            if (queryParameters.containsKey("genericResultSet")) {
                genericResultSet = Boolean.parseBoolean((String)queryParameters.get("genericResultSet"));
            }
            CommandStrategyUtils.addQueryParametersToUriInfo((MutableUriInfo)parameterizedUriInfo, (Map)queryParameters);
        }
        String responseBody = this.dataTablesApiResource.getDatatableManyEntry(dataTableName, appTableId, dataTableId, null, genericResultSet, (UriInfo)parameterizedUriInfo);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public GetDatatableEntryByAppTableIdAndDataTableIdCommandStrategy(DatatablesApiResource dataTablesApiResource) {
        this.dataTablesApiResource = dataTablesApiResource;
    }
}

