/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;
import org.springframework.lang.NonNull;

public class ContextAwareTaskDecorator
implements TaskDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextAwareTaskDecorator.class);

    @NonNull
    public Runnable decorate(@NonNull Runnable runnable) {
        FineractContext context = ThreadLocalContextUtil.getContext();
        return () -> {
            try {
                log.debug("Initializing thread context for decorated task");
                ThreadLocalContextUtil.init((FineractContext)context);
                runnable.run();
            }
            finally {
                ThreadLocalContextUtil.reset();
            }
        };
    }
}

