/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.accountnumberformat.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.accountnumberformat.data.AccountNumberFormatDataValidator;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatEnumerations;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountNumberFormatDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Logger LOG = LoggerFactory.getLogger(AccountNumberFormatDataValidator.class);
    private static final Set<String> ACCOUNT_NUMBER_FORMAT_CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("accountType", "prefixType", "prefixCharacter"));
    private static final Set<String> ACCOUNT_NUMBER_FORMAT_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("prefixType", "prefixCharacter"));

    @Autowired
    public AccountNumberFormatDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ACCOUNT_NUMBER_FORMAT_CREATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("accountNumberFormat");
        Integer accountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("accountType", element);
        baseDataValidator.reset().parameter("accountType").value((Object)accountType).notNull().integerGreaterThanZero().inMinMaxRange(Integer.valueOf(EntityAccountType.getMinValue()), Integer.valueOf(EntityAccountType.getMaxValue()));
        if (this.fromApiJsonHelper.parameterExists("prefixType", element)) {
            Integer prefixType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("prefixType", element);
            DataValidatorBuilder dataValidatorForValidatingPrefixType = baseDataValidator.reset().parameter("prefixType").value((Object)prefixType).notNull().integerGreaterThanZero();
            if (prefixType.equals(AccountNumberFormatEnumerations.AccountNumberPrefixType.PREFIX_SHORT_NAME.getValue())) {
                String prefixCharacter = this.fromApiJsonHelper.extractStringNamed("prefixCharacter", element);
                baseDataValidator.reset().parameter("prefixType").value((Object)prefixCharacter).notBlank();
            }
            boolean areAccountTypeAndPrefixTypeValid = true;
            for (ApiParameterError apiParameterError : dataValidationErrors) {
                if (!apiParameterError.getParameterName().equalsIgnoreCase("accountType") && !apiParameterError.getParameterName().equalsIgnoreCase("prefixType")) continue;
                areAccountTypeAndPrefixTypeValid = false;
            }
            if (areAccountTypeAndPrefixTypeValid) {
                EntityAccountType entityAccountType = EntityAccountType.fromInt((int)accountType);
                Set validAccountNumberPrefixes = this.determineValidAccountNumberPrefixes(entityAccountType);
                dataValidatorForValidatingPrefixType.isOneOfTheseValues(validAccountNumberPrefixes.toArray());
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public Set<Integer> determineValidAccountNumberPrefixes(EntityAccountType entityAccountType) {
        Set<Object> validAccountNumberPrefixes = new HashSet();
        switch (3.$SwitchMap$org$apache$fineract$infrastructure$accountnumberformat$domain$EntityAccountType[entityAccountType.ordinal()]) {
            case 1: {
                validAccountNumberPrefixes = AccountNumberFormatEnumerations.accountNumberPrefixesForClientAccounts;
                break;
            }
            case 2: {
                validAccountNumberPrefixes = AccountNumberFormatEnumerations.accountNumberPrefixesForLoanAccounts;
                break;
            }
            case 3: {
                validAccountNumberPrefixes = AccountNumberFormatEnumerations.accountNumberPrefixesForSavingsAccounts;
                break;
            }
            case 4: {
                validAccountNumberPrefixes = AccountNumberFormatEnumerations.accountNumberPrefixesForCenters;
                break;
            }
            case 5: {
                validAccountNumberPrefixes = AccountNumberFormatEnumerations.accountNumberPrefixesForGroups;
                break;
            }
            case 6: {
                validAccountNumberPrefixes = Collections.emptySet();
            }
        }
        HashSet<Integer> validAccountNumberPrefixValues = new HashSet<Integer>();
        for (AccountNumberFormatEnumerations.AccountNumberPrefixType accountNumberPrefixType : validAccountNumberPrefixes) {
            validAccountNumberPrefixValues.add(accountNumberPrefixType.getValue());
        }
        return validAccountNumberPrefixValues;
    }

    public void validateForUpdate(String json, EntityAccountType entityAccountType) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ACCOUNT_NUMBER_FORMAT_UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("accountNumberFormat");
        boolean atLeastOneParameterPassedForUpdate = false;
        if (this.fromApiJsonHelper.parameterExists("prefixType", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Set validAccountNumberPrefixes = this.determineValidAccountNumberPrefixes(entityAccountType);
            Integer prefixType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("prefixType", element);
            baseDataValidator.reset().parameter("prefixType").value((Object)prefixType).notNull().integerGreaterThanZero().isOneOfTheseValues(validAccountNumberPrefixes.toArray());
        }
        if (!atLeastOneParameterPassedForUpdate) {
            Object forceError = null;
            baseDataValidator.reset().anyOfNotNull(new Object[]{forceError});
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

