/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.staff;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class StaffWorkbookPopulator
extends AbstractWorkbookPopulator {
    private OfficeSheetPopulator officeSheetPopulator;

    public StaffWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator) {
        this.officeSheetPopulator = officeSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet staffSheet = workbook.createSheet("Employee");
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.setLayout(staffSheet);
        this.setRules(staffSheet, dateFormat);
    }

    private void setRules(Sheet staffSheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList isLoanOfficerNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList joinedOnNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList isActiveNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)staffSheet);
        List offices = this.officeSheetPopulator.getOffices();
        this.setNames(staffSheet, offices);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint isLoanOfficerConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint joinedOnConstraint = validationHelper.createDateConstraint(7, "=TODAY()", null, dateFormat);
        DataValidationConstraint isActiveConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation isLoanOfficerValidation = validationHelper.createValidation(isLoanOfficerConstraint, isLoanOfficerNameRange);
        DataValidation joinedOnValidation = validationHelper.createValidation(joinedOnConstraint, joinedOnNameRange);
        DataValidation isActiveValidation = validationHelper.createValidation(isActiveConstraint, isActiveNameRange);
        staffSheet.addValidationData(officeValidation);
        staffSheet.addValidationData(isLoanOfficerValidation);
        staffSheet.addValidationData(joinedOnValidation);
        staffSheet.addValidationData(isActiveValidation);
    }

    private void setNames(Sheet staffSheet, List<OfficeData> offices) {
        Workbook staffWorkBook = staffSheet.getWorkbook();
        Name officeGroup = staffWorkBook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (offices.size() + 1));
    }

    private void setLayout(Sheet staffSheet) {
        Row rowHeader = staffSheet.createRow(0);
        rowHeader.setHeight((short)500);
        staffSheet.setColumnWidth(0, 4000);
        staffSheet.setColumnWidth(1, 4000);
        staffSheet.setColumnWidth(2, 4000);
        staffSheet.setColumnWidth(3, 6000);
        staffSheet.setColumnWidth(4, 6000);
        staffSheet.setColumnWidth(5, 4000);
        staffSheet.setColumnWidth(6, 4000);
        staffSheet.setColumnWidth(7, 4000);
        this.writeString(0, rowHeader, "Office Name *");
        this.writeString(1, rowHeader, "First Name *");
        this.writeString(2, rowHeader, "Last Name *");
        this.writeString(3, rowHeader, "Is Loan Officer *");
        this.writeString(4, rowHeader, "Mobile no");
        this.writeString(5, rowHeader, "Joined on *");
        this.writeString(6, rowHeader, "External Id *");
        this.writeString(7, rowHeader, "Is Active *");
    }
}

