/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.entityaccess.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.savings.domain.SavingsProductRepository;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.useradministration.domain.RoleRepository;
import org.apache.fineract.useradministration.exception.RoleNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FineractEntityDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final LoanProductRepository loanProductRepository;
    private final SavingsProductRepository savingsProductRepository;
    private final ChargeRepositoryWrapper chargeRepositoryWrapper;
    private final RoleRepository roleRepository;
    private static final Set<String> CREATE_ENTITY_MAPPING_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("fromId", "toId", "startDate", "locale", "dateFormat", "endDate"));
    private static final Set<String> UPDATE_ENTITY_MAPPING_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("relId", "fromId", "toId", "startDate", "locale", "dateFormat", "endDate"));

    @Autowired
    public FineractEntityDataValidator(FromJsonHelper fromApiJsonHelper, OfficeRepositoryWrapper officeRepositoryWrapper, LoanProductRepository loanProductRepository, SavingsProductRepository savingsProductRepository, ChargeRepositoryWrapper chargeRepositoryWrapper, RoleRepository roleRepository) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.loanProductRepository = loanProductRepository;
        this.savingsProductRepository = savingsProductRepository;
        this.chargeRepositoryWrapper = chargeRepositoryWrapper;
        this.roleRepository = roleRepository;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CREATE_ENTITY_MAPPING_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("FineractEntity");
        if (this.fromApiJsonHelper.parameterExists("fromId", element)) {
            Long fromId = this.fromApiJsonHelper.extractLongNamed("fromId", element);
            baseDataValidator.reset().parameter("fromId").value((Object)fromId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("toId", element)) {
            Long toId = this.fromApiJsonHelper.extractLongNamed("toId", element);
            baseDataValidator.reset().parameter("toId").value((Object)toId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("startDate", element)) {
            LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed("startDate", element);
            baseDataValidator.reset().parameter("startDate").value((Object)startDate);
        }
        if (this.fromApiJsonHelper.parameterExists("endDate", element)) {
            LocalDate endDate = this.fromApiJsonHelper.extractLocalDateNamed("endDate", element);
            baseDataValidator.reset().parameter("endDate").value((Object)endDate);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void checkForEntity(String relId, Long fromId, Long toId) {
        switch (relId) {
            case "1": {
                this.checkForOffice(fromId);
                this.checkForLoanProducts(toId);
                break;
            }
            case "2": {
                this.checkForOffice(fromId);
                this.checkForSavingsProducts(toId);
                break;
            }
            case "3": {
                this.checkForOffice(fromId);
                this.checkForCharges(toId);
                break;
            }
            case "4": {
                this.checkForRoles(fromId);
                this.checkForLoanProducts(toId);
                break;
            }
            case "5": {
                this.checkForRoles(fromId);
                this.checkForSavingsProducts(toId);
            }
        }
    }

    public void checkForOffice(Long id) {
        this.officeRepositoryWrapper.findOneWithNotFoundDetection(id);
    }

    public void checkForLoanProducts(Long id) {
        this.loanProductRepository.findById((Object)id).orElseThrow(() -> new LoanProductNotFoundException(id));
    }

    public void checkForSavingsProducts(Long id) {
        this.savingsProductRepository.findById((Object)id).orElseThrow(() -> new SavingsProductNotFoundException(id));
    }

    public void checkForCharges(Long id) {
        this.chargeRepositoryWrapper.findOneWithNotFoundDetection(id);
    }

    public void checkForRoles(Long id) {
        this.roleRepository.findById((Object)id).orElseThrow(() -> new RoleNotFoundException(id));
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)UPDATE_ENTITY_MAPPING_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("FineractEntity");
        boolean atLeastOneParameterPassedForUpdate = false;
        if (this.fromApiJsonHelper.parameterExists("fromId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String fromEnityType = this.fromApiJsonHelper.extractStringNamed("fromId", element);
            baseDataValidator.reset().parameter("fromId").value((Object)fromEnityType);
        }
        if (this.fromApiJsonHelper.parameterExists("fromId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String toEnityType = this.fromApiJsonHelper.extractStringNamed("toId", element);
            baseDataValidator.reset().parameter("fromId").value((Object)toEnityType);
        }
        if (this.fromApiJsonHelper.parameterExists("toId", element)) {
            atLeastOneParameterPassedForUpdate = true;
        }
        if (this.fromApiJsonHelper.parameterExists("startDate", element)) {
            atLeastOneParameterPassedForUpdate = true;
        }
        if (this.fromApiJsonHelper.parameterExists("endDate", element)) {
            atLeastOneParameterPassedForUpdate = true;
        }
        if (!atLeastOneParameterPassedForUpdate) {
            Object forceError = null;
            baseDataValidator.reset().anyOfNotNull(new Object[]{forceError});
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }
}

