/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.jobs.data.partitionedjobs.PartitionedJob;
import org.apache.fineract.infrastructure.jobs.domain.JobExecutionRepository;
import org.apache.fineract.infrastructure.jobs.service.StuckJobExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class StuckJobExecutorServiceImpl
implements StuckJobExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StuckJobExecutorServiceImpl.class);
    private final JobExecutionRepository jobExecutionRepository;
    private final TransactionTemplate transactionTemplate;
    private final JobOperator jobOperator;

    public void resumeStuckJob(String jobName) {
        List stuckJobIds = this.getStuckJobIds(jobName);
        if (this.isPartitionedJob(jobName) && this.areThereStuckJobs(jobName)) {
            this.restartPartitionedJobs(jobName, stuckJobIds);
        } else {
            this.restartTaskletJobs(stuckJobIds);
        }
    }

    private void restartTaskletJobs(List<Long> stuckJobIds) {
        stuckJobIds.forEach(arg_0 -> this.handleStuckTaskletJob(arg_0));
    }

    private void handleStuckTaskletJob(Long stuckJobId) {
        try {
            this.jobOperator.restart(stuckJobId.longValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while handling a stuck job", e);
        }
    }

    private void restartPartitionedJobs(String jobName, List<Long> stuckJobIds) {
        stuckJobIds.forEach(stuckJobId -> this.handleStuckPartitionedJob(stuckJobId, this.getPartitionerStepName(jobName)));
    }

    private boolean isPartitionedJob(String jobName) {
        return PartitionedJob.existsByJobName((String)jobName);
    }

    private String getPartitionerStepName(String name) {
        return PartitionedJob.valueOf((String)name).getPartitionerStepName();
    }

    private boolean areThereStuckJobs(String jobName) {
        Long stuckJobCount = this.jobExecutionRepository.getStuckJobCountByJobName(jobName);
        return stuckJobCount != 0L;
    }

    private List<Long> getStuckJobIds(String jobName) {
        return this.jobExecutionRepository.getStuckJobIdsByJobName(jobName);
    }

    private void handleStuckPartitionedJob(Long stuckJobId, String partitionerStepName) {
        try {
            this.waitUntilAllPartitionsFinished(stuckJobId, partitionerStepName);
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.jobOperator.restart(stuckJobId.longValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while handling a stuck job", e);
        }
    }

    private void waitUntilAllPartitionsFinished(Long stuckJobId, String partitionerStepName) throws InterruptedException {
        while (!this.areAllPartitionsCompleted(stuckJobId, partitionerStepName)) {
            log.info("Sleeping for a second to wait for the partitions to complete for job {}", (Object)stuckJobId);
            Thread.sleep(1000L);
        }
    }

    private boolean areAllPartitionsCompleted(Long stuckJobId, String partitionerStepName) {
        Long notCompletedPartitions = this.jobExecutionRepository.getNotCompletedPartitionsCount(stuckJobId, partitionerStepName);
        return notCompletedPartitions == 0L;
    }

    @Generated
    public StuckJobExecutorServiceImpl(JobExecutionRepository jobExecutionRepository, TransactionTemplate transactionTemplate, JobOperator jobOperator) {
        this.jobExecutionRepository = jobExecutionRepository;
        this.transactionTemplate = transactionTemplate;
        this.jobOperator = jobOperator;
    }
}

