/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.aggregationjob;

import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.service.migration.TenantDataSourceFactory;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.JournalEntryAggregationJobExecutionDecider;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.JournalEntryAggregationJobReader;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.JournalEntryAggregationJobWriter;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.listener.JournalEntryAggregationJobListener;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.tasklet.JournalEntryAggregationTrackingTasklet;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(value={"fineract.job.journal-entry-aggregation.enabled"}, havingValue="true")
public class JournalEntryAggregationJobConfiguration {
    @Autowired
    private JournalEntryAggregationJobListener journalEntryAggregationJobListener;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JournalEntryAggregationJobExecutionDecider journalEntryAggregationJobExecutionDecider;
    @Autowired
    private JournalEntryAggregationJobWriter aggregationItemWriter;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private FineractProperties fineractProperties;
    @Autowired
    private JournalEntryAggregationTrackingTasklet journalEntryAggregationTrackingTasklet;
    @Autowired
    private TenantDataSourceFactory tenantDataSourceFactory;

    @Bean
    public Step journalEntryAggregationSummaryStep() {
        return ((SimpleStepBuilder)new StepBuilder("JournalEntryAggregation Summary Insert - Step", this.jobRepository).chunk(this.fineractProperties.getJob().getJournalEntryAggregation().getChunkSize().intValue(), this.transactionManager).reader((ItemReader)this.journalEntryAggregationJobReader()).writer((ItemWriter)this.aggregationItemWriter).allowStartIfComplete(true)).build();
    }

    @Bean
    public JournalEntryAggregationJobReader journalEntryAggregationJobReader() {
        return new JournalEntryAggregationJobReader(this.tenantDataSourceFactory);
    }

    @Bean
    protected Step journalEntryAggregationTrackingStep() {
        return new StepBuilder("JournalEntryAggregation Tracking Insert - Step", this.jobRepository).tasklet((Tasklet)this.journalEntryAggregationTrackingTasklet, this.transactionManager).build();
    }

    @Bean(name={"journalEntryAggregation"})
    public Job journalEntryAggregation() {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)new JobBuilder(JobName.JOURNAL_ENTRY_AGGREGATION.name(), this.jobRepository).listener((JobExecutionListener)this.journalEntryAggregationJobListener)).start((JobExecutionDecider)this.journalEntryAggregationJobExecutionDecider).on("NO_OP_EXECUTION").end().from((JobExecutionDecider)this.journalEntryAggregationJobExecutionDecider).on("CONTINUE_JOB_EXECUTION").to(this.journalEntryAggregationSummaryStep()).next(this.journalEntryAggregationTrackingStep()).end()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }
}

