/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.jobparameterprovider;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameterRepository;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.jobs.service.jobparameterprovider.AbstractJobParameterProvider;
import org.springframework.batch.core.JobParameter;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoanCOBJobParameterProvider
extends AbstractJobParameterProvider<Long> {
    private final CustomJobParameterRepository customJobParameterRepository;

    @Transactional
    public Map<String, JobParameter<Long>> provide(Set<JobParameterDTO> jobParameterDTOSet) {
        HashMap<String, JobParameter<Long>> jobParameterMap = new HashMap<String, JobParameter<Long>>();
        Long customJobParameterId = this.customJobParameterRepository.save(this.getJobParameterDTOListWithCorrectBusinessDate(jobParameterDTOSet));
        jobParameterMap.put("CUSTOM_JOB_PARAMETER_ID", new JobParameter((Object)customJobParameterId, Long.class));
        return jobParameterMap;
    }

    public String getJobName() {
        return JobName.LOAN_COB.name();
    }

    private Set<JobParameterDTO> getJobParameterDTOListWithCorrectBusinessDate(Set<JobParameterDTO> jobParameterDTOset) {
        HashSet<JobParameterDTO> jobParameterDTOListWithCorrectBusinessDate = jobParameterDTOset.isEmpty() ? new HashSet<JobParameterDTO>() : new HashSet<JobParameterDTO>(jobParameterDTOset);
        Optional<JobParameterDTO> optionalBusinessDateJobParameter = jobParameterDTOListWithCorrectBusinessDate.stream().filter(jobParameterDTO -> "BusinessDate".equals(jobParameterDTO.getParameterName())).findFirst();
        if (optionalBusinessDateJobParameter.isEmpty()) {
            jobParameterDTOListWithCorrectBusinessDate.add(new JobParameterDTO("BusinessDate", ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE).format(DateTimeFormatter.ISO_DATE)));
        }
        return jobParameterDTOListWithCorrectBusinessDate;
    }

    @Generated
    public LoanCOBJobParameterProvider(CustomJobParameterRepository customJobParameterRepository) {
        this.customJobParameterRepository = customJobParameterRepository;
    }
}

