/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.data;

import java.time.ZonedDateTime;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.data.OTPDeliveryMethod;
import org.apache.fineract.infrastructure.security.data.OTPMetadata;

public class OTPRequest {
    private String token;
    private OTPMetadata metadata;

    public static OTPRequest create(String token, int tokenLiveTimeInSec, boolean extendedAccessToken, OTPDeliveryMethod deliveryMethod) {
        OTPMetadata metadata = new OTPMetadata().setRequestTime(DateUtils.getLocalDateTimeOfTenant().atZone(DateUtils.getDateTimeZoneOfTenant())).setTokenLiveTimeInSec(tokenLiveTimeInSec).setExtendedAccessToken(extendedAccessToken).setDeliveryMethod(deliveryMethod);
        return new OTPRequest().setToken(token).setMetadata(metadata);
    }

    public boolean isValid() {
        ZonedDateTime expireTime = this.metadata.getRequestTime().plusSeconds(this.metadata.getTokenLiveTimeInSec());
        return ZonedDateTime.now(DateUtils.getDateTimeZoneOfTenant()).isBefore(expireTime);
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public OTPMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public OTPRequest setToken(String token) {
        this.token = token;
        return this;
    }

    @Generated
    public OTPRequest setMetadata(OTPMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OTPRequest)) {
            return false;
        }
        OTPRequest other = (OTPRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        OTPMetadata this$metadata = this.getMetadata();
        OTPMetadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OTPRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        OTPMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OTPRequest(token=" + this.getToken() + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
    }

    @Generated
    public OTPRequest() {
    }
}

