/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import java.util.ArrayList;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.StandingInstructionDTO;
import org.apache.fineract.portfolio.account.data.StandingInstructionHistoryData;
import org.apache.fineract.portfolio.account.service.StandingInstructionHistoryReadPlatformService;
import org.apache.fineract.portfolio.account.service.StandingInstructionHistoryReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class StandingInstructionHistoryReadPlatformServiceImpl
implements StandingInstructionHistoryReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ColumnValidator columnValidator;
    private final StandingInstructionHistoryMapper standingInstructionHistoryMapper;
    private final PaginationHelper paginationHelper;

    public StandingInstructionHistoryReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ColumnValidator columnValidator, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.standingInstructionHistoryMapper = new StandingInstructionHistoryMapper();
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
    }

    public Page<StandingInstructionHistoryData> retrieveAll(StandingInstructionDTO standingInstructionDTO) {
        SearchParameters searchParameters;
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.standingInstructionHistoryMapper.schema());
        if (standingInstructionDTO.transferType() != null || standingInstructionDTO.clientId() != null || standingInstructionDTO.clientName() != null || standingInstructionDTO.fromAccountType() != null && standingInstructionDTO.fromAccount() != null || standingInstructionDTO.startDateRange() != null || standingInstructionDTO.endDateRange() != null) {
            sqlBuilder.append(" where ");
        }
        boolean addAndCaluse = false;
        ArrayList<Object> paramObj = new ArrayList<Object>();
        if (standingInstructionDTO.transferType() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" atd.transfer_type=? ");
            paramObj.add(standingInstructionDTO.transferType());
            addAndCaluse = true;
        }
        if (standingInstructionDTO.clientId() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" fromclient.id=? ");
            paramObj.add(standingInstructionDTO.clientId());
            addAndCaluse = true;
        } else if (standingInstructionDTO.clientName() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" fromclient.display_name=? ");
            paramObj.add(standingInstructionDTO.clientName());
            addAndCaluse = true;
        }
        if (standingInstructionDTO.fromAccountType() != null && standingInstructionDTO.fromAccount() != null) {
            PortfolioAccountType accountType = PortfolioAccountType.fromInt((Integer)standingInstructionDTO.fromAccountType());
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            if (accountType.isSavingsAccount()) {
                sqlBuilder.append(" fromsavacc.id=? ");
                paramObj.add(standingInstructionDTO.fromAccount());
            } else if (accountType.isLoanAccount()) {
                sqlBuilder.append(" fromloanacc.id=? ");
                paramObj.add(standingInstructionDTO.fromAccount());
            }
            addAndCaluse = true;
        }
        if (standingInstructionDTO.startDateRange() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" atsih.execution_time >= ? ");
            paramObj.add(DateUtils.DEFAULT_DATE_FORMATTER.format(standingInstructionDTO.startDateRange()));
            addAndCaluse = true;
        }
        if (standingInstructionDTO.endDateRange() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" atsih.execution_time < ? ");
            paramObj.add(DateUtils.DEFAULT_DATE_FORMATTER.format(standingInstructionDTO.endDateRange()));
            addAndCaluse = true;
        }
        if ((searchParameters = standingInstructionDTO.searchParameters()).hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        Object[] finalObjectArray = paramObj.toArray();
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)this.standingInstructionHistoryMapper);
    }
}

