/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepository;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClientRepositoryWrapper {
    private final ClientRepository repository;
    private final PlatformSecurityContext context;

    @Transactional(readOnly=true)
    public Client findOneWithNotFoundDetection(Long id) {
        return this.findOneWithNotFoundDetection(id, false);
    }

    @Transactional(readOnly=true)
    public Client findOneWithNotFoundDetection(Long clientId, boolean loadLazyCollections) {
        Client client = (Client)this.repository.findById((Object)clientId).orElseThrow(() -> new ClientNotFoundException(clientId));
        if (loadLazyCollections) {
            client.loadLazyCollections();
        }
        return client;
    }

    public List<Client> findAll(Collection<Long> clientIds) {
        return this.repository.findAllById(clientIds);
    }

    public void save(Client client) {
        this.repository.save((Object)client);
    }

    public void saveAndFlush(Client client) {
        this.repository.saveAndFlush((Object)client);
    }

    public void delete(Client client) {
        this.repository.delete((Object)client);
    }

    public void flush() {
        this.repository.flush();
    }

    @Transactional(readOnly=true)
    public Client getActiveClientInUserScope(Long clientId) {
        Client client = this.findOneWithNotFoundDetection(clientId);
        if (client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        this.context.validateAccessRights(client.getOffice().getHierarchy());
        return client;
    }

    public Client getClientByAccountNumber(String accountNumber) {
        Client client = this.repository.getClientByAccountNumber(accountNumber);
        if (client == null) {
            throw new ClientNotFoundException(accountNumber, "account.number");
        }
        return client;
    }

    public Client getClientByClientIdAndHierarchy(Long clientId, String hierarchySearchString) {
        Client client = this.repository.fetchByClientIdAndHierarchy(clientId, hierarchySearchString, hierarchySearchString);
        if (client == null) {
            throw new ClientNotFoundException(clientId.toString(), "client.id");
        }
        return client;
    }

    public Long findIdByExternalId(ExternalId externalId) {
        return this.repository.findIdByExternalId(externalId);
    }

    @Generated
    public ClientRepositoryWrapper(ClientRepository repository, PlatformSecurityContext context) {
        this.repository = repository;
        this.context = context;
    }
}

