/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.service;

import java.math.BigDecimal;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.service.LoanCollateralManagementWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagementRepository;
import org.springframework.transaction.annotation.Transactional;

public class LoanCollateralManagementWritePlatformServiceImpl
implements LoanCollateralManagementWritePlatformService {
    private final LoanCollateralManagementRepository loanCollateralManagementRepository;
    private final ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper;

    @Transactional
    public CommandProcessingResult deleteLoanCollateral(JsonCommand command) {
        Long id = command.entityId();
        LoanCollateralManagement loanCollateralManagement = (LoanCollateralManagement)this.loanCollateralManagementRepository.findById((Object)id).orElseThrow();
        ClientCollateralManagement clientCollateralManagement = loanCollateralManagement.getClientCollateralManagement();
        BigDecimal loanQuantity = loanCollateralManagement.getQuantity();
        BigDecimal clientQuantity = clientCollateralManagement.getQuantity();
        clientCollateralManagement.updateQuantity(clientQuantity.add(loanQuantity));
        this.clientCollateralManagementRepositoryWrapper.saveAndFlush(clientCollateralManagement);
        this.loanCollateralManagementRepository.deleteById((Object)id);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(id).withLoanId(command.getLoanId()).build();
    }

    @Generated
    public LoanCollateralManagementWritePlatformServiceImpl(LoanCollateralManagementRepository loanCollateralManagementRepository, ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper) {
        this.loanCollateralManagementRepository = loanCollateralManagementRepository;
        this.clientCollateralManagementRepositoryWrapper = clientCollateralManagementRepositoryWrapper;
    }
}

