/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class GroupingTypesDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final GroupRepositoryWrapper groupRepositoryWrapper;
    private static final Set<String> CENTER_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "id", "name", "externalId", "officeId", "staffId", "active", "activationDate", "groupMembers", "submittedOnDate", "datatables"));
    private static final Set<String> GROUP_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "id", "name", "externalId", "centerId", "officeId", "staffId", "active", "activationDate", "clientMembers", "collectionMeetingCalendar", "submittedOnDate", "datatables"));
    private static final Set<String> ACTIVATION_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "activationDate"));
    private static final Set<String> GROUP_CLOSE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "closureDate", "closureReasonId"));

    @Autowired
    public GroupingTypesDataValidator(FromJsonHelper fromApiJsonHelper, GroupRepositoryWrapper groupRepositoryWrapper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.groupRepositoryWrapper = groupRepositoryWrapper;
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForCreateCenter(JsonCommand command) {
        Boolean active;
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CENTER_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("center");
        JsonElement element = command.parsedJson();
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notNull().notExceedingLengthOf(Integer.valueOf(100));
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", element);
        baseDataValidator.reset().parameter("officeId").value((Object)officeId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).integerGreaterThanZero();
        }
        if ((active = this.fromApiJsonHelper.extractBooleanNamed("active", element)) != null) {
            if (active.booleanValue()) {
                LocalDate joinedDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
                baseDataValidator.reset().parameter("activationDate").value((Object)joinedDate).notNull();
            } else {
                boolean joinedDate = true;
            }
        } else {
            baseDataValidator.reset().parameter("active").value((Object)active).trueOrFalseRequired((Object)false);
        }
        if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
            LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("datatables", element)) {
            JsonArray datatables = this.fromApiJsonHelper.extractJsonArrayNamed("datatables", element);
            baseDataValidator.reset().parameter("datatables").value((Object)datatables).notNull().jsonArrayNotEmpty();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForCreateCenterGroup(JsonCommand command) {
        Boolean active;
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)GROUP_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        JsonElement element = command.parsedJson();
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notNull().notExceedingLengthOf(Integer.valueOf(100));
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        Long centerId = this.fromApiJsonHelper.extractLongNamed("centerId", element);
        baseDataValidator.reset().parameter("centerId").value((Object)centerId).notNull().integerGreaterThanZero();
        Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", element);
        baseDataValidator.reset().parameter("officeId").value((Object)officeId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).integerGreaterThanZero();
        }
        if ((active = this.fromApiJsonHelper.extractBooleanNamed("active", element)) != null) {
            if (active.booleanValue()) {
                LocalDate joinedDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
                baseDataValidator.reset().parameter("activationDate").value((Object)joinedDate).notNull();
            } else {
                boolean joinedDate = true;
            }
        } else {
            baseDataValidator.reset().parameter("active").value((Object)active).trueOrFalseRequired((Object)false);
        }
        if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
            LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("datatables", element)) {
            JsonArray datatables = this.fromApiJsonHelper.extractJsonArrayNamed("datatables", element);
            baseDataValidator.reset().parameter("datatables").value((Object)datatables).notNull().jsonArrayNotEmpty();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForCreateGroup(JsonCommand command) {
        Boolean active;
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)GROUP_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        JsonElement element = command.parsedJson();
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notNull().notExceedingLengthOf(Integer.valueOf(100));
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", element);
        baseDataValidator.reset().parameter("officeId").value((Object)officeId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).integerGreaterThanZero();
        }
        if ((active = this.fromApiJsonHelper.extractBooleanNamed("active", element)) != null) {
            if (active.booleanValue()) {
                LocalDate joinedDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
                baseDataValidator.reset().parameter("activationDate").value((Object)joinedDate).notNull();
            } else {
                boolean joinedDate = true;
            }
        } else {
            baseDataValidator.reset().parameter("active").value((Object)active).trueOrFalseRequired((Object)false);
        }
        if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
            LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("datatables", element)) {
            JsonArray datatables = this.fromApiJsonHelper.extractJsonArrayNamed("datatables", element);
            baseDataValidator.reset().parameter("datatables").value((Object)datatables).notNull().jsonArrayNotEmpty();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdateCenter(JsonCommand command, Long centerId) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CENTER_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("center");
        JsonElement element = command.parsedJson();
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notNull().notExceedingLengthOf(Integer.valueOf(100));
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).integerGreaterThanZero();
        }
        LocalDate submittedOnDate = this.groupRepositoryWrapper.retrieveSubmittedOndate(centerId);
        Boolean active = this.fromApiJsonHelper.extractBooleanNamed("active", element);
        if (active != null && active.booleanValue() || this.fromApiJsonHelper.parameterExists("activationDate", element)) {
            LocalDate joinedDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
            baseDataValidator.reset().parameter("activationDate").value((Object)joinedDate).notNull().validateDateAfter(submittedOnDate);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdateGroup(JsonCommand command, Long groupId) {
        Boolean active;
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)GROUP_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        JsonElement element = command.parsedJson();
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notNull().notExceedingLengthOf(Integer.valueOf(100));
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("officeId", element)) {
            Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", element);
            baseDataValidator.reset().parameter("officeId").value((Object)officeId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).integerGreaterThanZero();
        }
        LocalDate submittedOnDate = this.groupRepositoryWrapper.retrieveSubmittedOndate(groupId);
        if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
            submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
        }
        if ((active = this.fromApiJsonHelper.extractBooleanNamed("active", element)) != null && active.booleanValue() || this.fromApiJsonHelper.parameterExists("activationDate", element)) {
            LocalDate joinedDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
            baseDataValidator.reset().parameter("activationDate").value((Object)joinedDate).notNull().validateDateAfter(submittedOnDate);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForActivation(JsonCommand command, String resourceName) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ACTIVATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(resourceName);
        JsonElement element = command.parsedJson();
        LocalDate activationDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
        baseDataValidator.reset().parameter("activationDate").value((Object)activationDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUnassignStaff(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParametersUnassignStaff = new HashSet<String>(Arrays.asList("staffId"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParametersUnassignStaff);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        String staffIdParameterName = "staffId";
        Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
        baseDataValidator.reset().parameter("staffId").value((Object)staffId).notNull().integerGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForAssignStaff(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParametersAssignStaff = new HashSet<String>(Arrays.asList("staffId", "inheritStaffForClientAccounts"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParametersAssignStaff);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        String staffIdParameterName = "staffId";
        Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
        baseDataValidator.reset().parameter("staffId").value((Object)staffId).notNull().longGreaterThanZero();
        String inheritStaffForClientAccountsParamName = "inheritStaffForClientAccounts";
        Boolean inheritStaffForClientAccounts = this.fromApiJsonHelper.extractBooleanNamed("inheritStaffForClientAccounts", element);
        baseDataValidator.reset().parameter("inheritStaffForClientAccounts").value((Object)inheritStaffForClientAccounts).ignoreIfNull().notBlank().isOneOfTheseValues(new Object[]{true, false});
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForAssociateClients(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("clientMembers"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        String[] clients = this.fromApiJsonHelper.extractArrayNamed("clientMembers", element);
        baseDataValidator.reset().parameter("clientMembers").value((Object)clients).arrayNotEmpty();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForDisassociateClients(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("clientMembers"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        String[] clients = this.fromApiJsonHelper.extractArrayNamed("clientMembers", element);
        baseDataValidator.reset().parameter("clientMembers").value((Object)clients).arrayNotEmpty();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForGroupClose(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)GROUP_CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        JsonElement element = command.parsedJson();
        LocalDate closureDate = this.fromApiJsonHelper.extractLocalDateNamed("closureDate", element);
        baseDataValidator.reset().parameter("closureDate").value((Object)closureDate).notNull();
        Long closureReasonId = this.fromApiJsonHelper.extractLongNamed("closureReasonId", element);
        baseDataValidator.reset().parameter("closureReasonId").value((Object)closureReasonId).notNull().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForCenterClose(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)GROUP_CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("center");
        JsonElement element = command.parsedJson();
        LocalDate closureDate = this.fromApiJsonHelper.extractLocalDateNamed("closureDate", element);
        baseDataValidator.reset().parameter("closureDate").value((Object)closureDate).notNull();
        Long closureReasonId = this.fromApiJsonHelper.extractLongNamed("closureReasonId", element);
        baseDataValidator.reset().parameter("closureReasonId").value((Object)closureReasonId).notNull().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForAssociateGroups(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("groupMembers"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        String[] groups = this.fromApiJsonHelper.extractArrayNamed("groupMembers", element);
        baseDataValidator.reset().parameter("groupMembers").value((Object)groups).arrayNotEmpty();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForDisassociateGroups(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("groupMembers"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        String[] groups = this.fromApiJsonHelper.extractArrayNamed("groupMembers", element);
        baseDataValidator.reset().parameter("groupMembers").value((Object)groups).arrayNotEmpty();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }
}

