/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.adjustment;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBalanceChangedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.data.HolidayDetailDTO;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeBalance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeBalance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallmentRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanTransactionTypeException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.repository.LoanBuyDownFeeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.repository.LoanCapitalizedIncomeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanDownPaymentHandlerService;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanaccount.service.adjustment.LoanAdjustmentParameter;
import org.apache.fineract.portfolio.loanaccount.service.adjustment.LoanAdjustmentService;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Component;

@Component
public class LoanAdjustmentServiceImpl
implements LoanAdjustmentService {
    private final LoanTransactionValidator loanTransactionValidator;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanAccountDomainService loanAccountDomainService;
    private final NoteRepository noteRepository;
    private final LoanTransactionRepository loanTransactionRepository;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanUtilService loanUtilService;
    private final LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository;
    private final LoanLifecycleStateMachine loanLifecycleStateMachine;
    private final LoanDownPaymentHandlerService loanDownPaymentHandlerService;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanChargeValidator loanChargeValidator;
    private final LoanJournalEntryPoster journalEntryPoster;
    private final LoanBalanceService loanBalanceService;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository;
    private final LoanBuyDownFeeBalanceRepository loanBuyDownFeeBalanceRepository;
    private final LoanScheduleService loanScheduleService;

    public CommandProcessingResult adjustLoanTransaction(Loan loan, LoanTransaction transactionToAdjust, LoanAdjustmentParameter parameter, Long commandId, Map<String, Object> changes) {
        boolean thereIsNewTransaction;
        LoanBuyDownFeeBalance buyDownFeeBalance;
        LoanCapitalizedIncomeBalance capitalizedIncomeBalance;
        LocalDate transactionDate = parameter.getTransactionDate();
        BigDecimal transactionAmount = parameter.getTransactionAmount();
        PaymentDetail paymentDetail = parameter.getPaymentDetail();
        ExternalId txnExternalId = parameter.getTxnExternalId();
        ExternalId reversalTxnExternalId = parameter.getReversalTxnExternalId();
        String noteText = parameter.getNoteText();
        Money transactionAmountAsMoney = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        LoanTransaction newTransactionDetail = LoanTransaction.repaymentType((LoanTransactionType)transactionToAdjust.getTypeOf(), (Office)loan.getOffice(), (Money)transactionAmountAsMoney, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId, (String)transactionToAdjust.getChargeRefundChargeType());
        if (transactionToAdjust.isInterestWaiver()) {
            Money receivableInterest;
            Money unrecognizedIncome = transactionAmountAsMoney.zero();
            Money interestComponent = transactionAmountAsMoney;
            if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue() && transactionAmountAsMoney.isGreaterThan(receivableInterest = this.loanBalanceService.getReceivableInterest(loan, transactionDate))) {
                interestComponent = receivableInterest;
                unrecognizedIncome = transactionAmountAsMoney.minus(receivableInterest);
            }
            newTransactionDetail = LoanTransaction.waiver((Office)loan.getOffice(), (Loan)loan, (Money)transactionAmountAsMoney, (LocalDate)transactionDate, (Money)interestComponent, (Money)unrecognizedIncome, (ExternalId)txnExternalId);
        }
        if (transactionToAdjust.isChargesWaiver()) {
            transactionToAdjust.getLoanChargesPaid().forEach(loanChargePaidBy -> {
                LoanCharge loanCharge = loanChargePaidBy.getLoanCharge();
                MonetaryCurrency currency = loanCharge.getLoan().getCurrency();
                Integer installmentNumber = loanChargePaidBy.getInstallmentNumber();
                loanCharge.undoWaive(currency, installmentNumber);
            });
        }
        if (transactionToAdjust.isCapitalizedIncome()) {
            if (newTransactionDetail.isNotZero()) {
                throw new InvalidLoanTransactionTypeException("transaction", "capitalizedIncome.cannot.be.adjusted", "Capitalized income transaction cannot be adjusted", new Object[0]);
            }
            capitalizedIncomeBalance = this.loanCapitalizedIncomeBalanceRepository.findByLoanIdAndLoanTransactionIdAndDeletedFalseAndClosedFalse((Long)loan.getId(), (Long)transactionToAdjust.getId());
            if (MathUtil.isGreaterThanZero((BigDecimal)capitalizedIncomeBalance.getAmountAdjustment())) {
                throw new InvalidLoanTransactionTypeException("transaction", "capitalizedIncome.cannot.be.reversed.when.adjusted", "Capitalized income transaction cannot be reversed when non-reversed adjustment exists for it.", new Object[0]);
            }
            capitalizedIncomeBalance.setDeleted(true);
            this.loanCapitalizedIncomeBalanceRepository.saveAndFlush((Object)capitalizedIncomeBalance);
        }
        if (transactionToAdjust.isCapitalizedIncomeAdjustment()) {
            if (newTransactionDetail.isNotZero()) {
                throw new InvalidLoanTransactionTypeException("transaction", "capitalizedIncomeAdjustment.cannot.be.adjusted", "Capitalized income adjustment transaction cannot be adjusted", new Object[0]);
            }
            capitalizedIncomeBalance = this.loanCapitalizedIncomeBalanceRepository.findBalanceForAdjustment((Long)transactionToAdjust.getId());
            capitalizedIncomeBalance.setAmountAdjustment(capitalizedIncomeBalance.getAmountAdjustment().subtract(transactionToAdjust.getAmount()));
            capitalizedIncomeBalance.setUnrecognizedAmount(capitalizedIncomeBalance.getUnrecognizedAmount().add(transactionToAdjust.getAmount()));
        }
        if (transactionToAdjust.isBuyDownFee()) {
            if (newTransactionDetail.isNotZero()) {
                throw new InvalidLoanTransactionTypeException("transaction", "buy.down.fee.cannot.be.adjusted", "Buy down fee transaction cannot be adjusted", new Object[0]);
            }
            buyDownFeeBalance = this.loanBuyDownFeeBalanceRepository.findByLoanIdAndLoanTransactionIdAndDeletedFalseAndClosedFalse((Long)loan.getId(), (Long)transactionToAdjust.getId());
            if (MathUtil.isGreaterThanZero((BigDecimal)buyDownFeeBalance.getAmountAdjustment())) {
                throw new InvalidLoanTransactionTypeException("transaction", "buy.down.fee.cannot.be.reversed.when.adjusted", "Buy down fee transaction cannot be reversed when non-reversed adjustment exists for it.", new Object[0]);
            }
            buyDownFeeBalance.setDeleted(true);
            this.loanBuyDownFeeBalanceRepository.saveAndFlush((Object)buyDownFeeBalance);
        }
        if (transactionToAdjust.isBuyDownFeeAdjustment()) {
            if (newTransactionDetail.isNotZero()) {
                throw new InvalidLoanTransactionTypeException("transaction", "buy.down.fee.adjustment.cannot.be.adjusted", "Buy down fee adjustment transaction cannot be adjusted", new Object[0]);
            }
            buyDownFeeBalance = this.loanBuyDownFeeBalanceRepository.findBalanceForAdjustment((Long)transactionToAdjust.getId());
            buyDownFeeBalance.setAmountAdjustment(buyDownFeeBalance.getAmountAdjustment().subtract(transactionToAdjust.getAmount()));
            buyDownFeeBalance.setUnrecognizedAmount(buyDownFeeBalance.getUnrecognizedAmount().add(transactionToAdjust.getAmount()));
        }
        LocalDate recalculateFrom = null;
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            recalculateFrom = DateUtils.isAfter((LocalDate)transactionToAdjust.getTransactionDate(), (LocalDate)transactionDate) ? transactionDate : transactionToAdjust.getTransactionDate();
        }
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        HolidayDetailDTO holidayDetailDTO = scheduleGeneratorDTO.getHolidayDetailDTO();
        if (loan.getLoanRepaymentScheduleDetail().getLoanScheduleType().equals((Object)LoanScheduleType.CUMULATIVE)) {
            this.loanTransactionValidator.validateActivityNotBeforeLastTransactionDate(loan, transactionToAdjust.getTransactionDate(), LoanEvent.LOAN_REPAYMENT_OR_WAIVER);
        }
        this.loanTransactionValidator.validateRepaymentDateIsOnHoliday(newTransactionDetail.getTransactionDate(), holidayDetailDTO.isAllowTransactionsOnHoliday(), holidayDetailDTO.getHolidays());
        this.loanTransactionValidator.validateRepaymentDateIsOnNonWorkingDay(newTransactionDetail.getTransactionDate(), holidayDetailDTO.getWorkingDays(), holidayDetailDTO.isAllowTransactionsOnNonWorkingDay());
        this.adjustExistingTransaction(loan, newTransactionDetail, transactionToAdjust, scheduleGeneratorDTO, reversalTxnExternalId);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        if (thereIsNewTransaction = newTransactionDetail.isGreaterThanZero()) {
            if (paymentDetail != null) {
                this.paymentDetailWritePlatformService.persistPaymentDetail(paymentDetail);
            }
            this.loanTransactionRepository.saveAndFlush((Object)newTransactionDetail);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(newTransactionDetail, false, false);
        }
        loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = thereIsNewTransaction ? Note.loanTransactionNote((Loan)loan, (LoanTransaction)newTransactionDetail, (String)noteText) : Note.loanTransactionNote((Loan)loan, (LoanTransaction)transactionToAdjust, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        ArrayList<Long> transactionIds = new ArrayList<Long>();
        List transactions = loan.getLoanTransactions();
        for (LoanTransaction transaction : transactions) {
            if (!transaction.isRefund() || !transaction.isNotReversed()) continue;
            transactionIds.add((Long)transaction.getId());
        }
        if (!transactionIds.isEmpty()) {
            this.accountTransfersWritePlatformService.reverseTransfersWithFromAccountTransactions(transactionIds, PortfolioAccountType.LOAN);
        }
        this.loanLifecycleStateMachine.determineAndTransition(loan, loan.getLastUserTransactionDate());
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        LoanAdjustTransactionBusinessEvent.Data eventData = new LoanAdjustTransactionBusinessEvent.Data(transactionToAdjust);
        if (newTransactionDetail.isRepaymentLikeType() && thereIsNewTransaction) {
            eventData.setNewTransactionDetail(newTransactionDetail);
        }
        Long entityId = (Long)transactionToAdjust.getId();
        ExternalId entityExternalId = transactionToAdjust.getExternalId();
        if (thereIsNewTransaction) {
            entityId = (Long)newTransactionDetail.getId();
            entityExternalId = newTransactionDetail.getExternalId();
        }
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(transactionToAdjust, false, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(eventData));
        return new CommandProcessingResultBuilder().withCommandId(commandId).withEntityId(entityId).withEntityExternalId(entityExternalId).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId((Long)loan.getId()).with(changes).build();
    }

    public void adjustExistingTransaction(Loan loan, LoanTransaction newTransactionDetail, LoanTransaction transactionForAdjustment, ScheduleGeneratorDTO scheduleGeneratorDTO, ExternalId reversalExternalId) {
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.LOAN_REPAYMENT_OR_WAIVER, transactionForAdjustment.getTransactionDate());
        if (!transactionForAdjustment.isAccrualRelated() && transactionForAdjustment.isNotRepaymentLikeType() && transactionForAdjustment.isNotWaiver() && transactionForAdjustment.isNotCreditBalanceRefund() && !transactionForAdjustment.isDeferredIncome() && !transactionForAdjustment.isCapitalizedIncomeAdjustment() && !transactionForAdjustment.isBuyDownFeeAdjustment()) {
            String errorMessage = "Only (non-reversed) transactions of type repayment, waiver, accrual, credit balance refund, capitalized income, capitalized income adjustment, buy down fee or buy down fee adjustment can be adjusted.";
            throw new InvalidLoanTransactionTypeException("transaction", "adjustment.is.only.allowed.to.repayment.or.waiver.or.creditbalancerefund.or.capitalizedIncome.or.capitalizedIncomeAdjustment.or.buyDownFee.or.buyDownFeeAdjustment.transactions", "Only (non-reversed) transactions of type repayment, waiver, accrual, credit balance refund, capitalized income, capitalized income adjustment, buy down fee or buy down fee adjustment can be adjusted.", new Object[0]);
        }
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(transactionForAdjustment.getLoan(), transactionForAdjustment, "reversed");
        transactionForAdjustment.reverse(reversalExternalId);
        transactionForAdjustment.manuallyAdjustedOrReversed();
        if (transactionForAdjustment.getTypeOf().equals((Object)LoanTransactionType.MERCHANT_ISSUED_REFUND) || transactionForAdjustment.getTypeOf().equals((Object)LoanTransactionType.PAYOUT_REFUND)) {
            loan.getLoanTransactions().stream().filter(LoanTransaction::isNotReversed).filter(loanTransaction -> loanTransaction.getLoanTransactionRelations().stream().anyMatch(relation -> relation.getRelationType().equals((Object)LoanTransactionRelationTypeEnum.RELATED) && ((Long)relation.getToTransaction().getId()).equals(transactionForAdjustment.getId()))).forEach(loanTransaction -> {
                this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loanTransaction.getLoan(), loanTransaction, "reversed");
                loanTransaction.reverse();
                loanTransaction.manuallyAdjustedOrReversed();
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(loanTransaction, false, false);
                LoanAdjustTransactionBusinessEvent.Data eventData = new LoanAdjustTransactionBusinessEvent.Data(loanTransaction);
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(eventData));
            });
        }
        if (loan.isClosedWrittenOff()) {
            LoanTransaction writeOffTransaction = loan.findWriteOffTransaction();
            this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(writeOffTransaction.getLoan(), writeOffTransaction, "reversed");
            writeOffTransaction.reverse();
        }
        if (newTransactionDetail.isRepaymentLikeType() || newTransactionDetail.isWaiver()) {
            this.loanDownPaymentHandlerService.handleRepaymentOrRecoveryOrWaiverTransaction(loan, newTransactionDetail, transactionForAdjustment, scheduleGeneratorDTO);
        }
        if (transactionForAdjustment.getTypeOf().equals((Object)LoanTransactionType.CAPITALIZED_INCOME)) {
            this.loanScheduleService.regenerateScheduleWithReprocessingTransactions(loan);
        }
    }

    private Loan saveAndFlushLoanWithDataIntegrityViolationChecks(Loan loan) {
        try {
            this.loanRepaymentScheduleInstallmentRepository.saveAll((Iterable)loan.getRepaymentScheduleInstallments());
            return this.loanRepositoryWrapper.saveAndFlush(loan);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            Throwable realCause = e.getCause();
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
            if (realCause.getMessage().toLowerCase().contains("external_id_unique")) {
                baseDataValidator.reset().parameter("externalId").failWithCode("value.must.be.unique", new Object[0]);
            }
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors, e);
            }
            throw e;
        }
    }

    @Generated
    public LoanAdjustmentServiceImpl(LoanTransactionValidator loanTransactionValidator, LoanRepositoryWrapper loanRepositoryWrapper, LoanAccountDomainService loanAccountDomainService, NoteRepository noteRepository, LoanTransactionRepository loanTransactionRepository, PaymentDetailWritePlatformService paymentDetailWritePlatformService, AccountTransfersWritePlatformService accountTransfersWritePlatformService, BusinessEventNotifierService businessEventNotifierService, LoanUtilService loanUtilService, LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository, LoanLifecycleStateMachine loanLifecycleStateMachine, LoanDownPaymentHandlerService loanDownPaymentHandlerService, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanChargeValidator loanChargeValidator, LoanJournalEntryPoster journalEntryPoster, LoanBalanceService loanBalanceService, ReprocessLoanTransactionsService reprocessLoanTransactionsService, LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository, LoanBuyDownFeeBalanceRepository loanBuyDownFeeBalanceRepository, LoanScheduleService loanScheduleService) {
        this.loanTransactionValidator = loanTransactionValidator;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanAccountDomainService = loanAccountDomainService;
        this.noteRepository = noteRepository;
        this.loanTransactionRepository = loanTransactionRepository;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanUtilService = loanUtilService;
        this.loanRepaymentScheduleInstallmentRepository = loanRepaymentScheduleInstallmentRepository;
        this.loanLifecycleStateMachine = loanLifecycleStateMachine;
        this.loanDownPaymentHandlerService = loanDownPaymentHandlerService;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanChargeValidator = loanChargeValidator;
        this.journalEntryPoster = journalEntryPoster;
        this.loanBalanceService = loanBalanceService;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.loanCapitalizedIncomeBalanceRepository = loanCapitalizedIncomeBalanceRepository;
        this.loanBuyDownFeeBalanceRepository = loanBuyDownFeeBalanceRepository;
        this.loanScheduleService = loanScheduleService;
    }
}

