/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.note.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableWithUTCDateTimeCustom;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.note.domain.NoteType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccount;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_note")
public class Note
extends AbstractAuditableWithUTCDateTimeCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="client_id", nullable=true)
    private Client client;
    @ManyToOne
    @JoinColumn(name="group_id", nullable=true)
    private Group group;
    @ManyToOne
    @JoinColumn(name="loan_id", nullable=true)
    private Loan loan;
    @ManyToOne
    @JoinColumn(name="loan_transaction_id", nullable=true)
    private LoanTransaction loanTransaction;
    @Column(name="note", length=1000)
    private String note;
    @Column(name="note_type_enum")
    private Integer noteTypeId;
    @ManyToOne
    @JoinColumn(name="savings_account_id", nullable=true)
    private SavingsAccount savingsAccount;
    @ManyToOne
    @JoinColumn(name="savings_account_transaction_id", nullable=true)
    private SavingsAccountTransaction savingsTransaction;
    @ManyToOne
    @JoinColumn(name="share_account_id", nullable=true)
    private ShareAccount shareAccount;
    static final long serialVersionUID = 6941821905650920044L;

    public static Note clientNoteFromJson(Client client, JsonCommand command) {
        String note = command.stringValueOfParameterNamed("note");
        return new Note(client, note);
    }

    public static Note groupNoteFromJson(Group group, JsonCommand command) {
        String note = command.stringValueOfParameterNamed("note");
        return new Note(group, note);
    }

    public static Note loanNote(Loan loan, String note) {
        return new Note(loan, note);
    }

    public static Note loanTransactionNote(Loan loan, LoanTransaction loanTransaction, String note) {
        return new Note(loan, loanTransaction, note);
    }

    public static Note savingNote(SavingsAccount account, String note) {
        return new Note(account, note);
    }

    public static Note savingsTransactionNote(SavingsAccount savingsAccount, SavingsAccountTransaction savingsTransaction, String note) {
        return new Note(savingsAccount, savingsTransaction, note);
    }

    private Note(SavingsAccount savingsAccount, SavingsAccountTransaction savingsTransaction, String note) {
        this.savingsAccount = savingsAccount;
        this.savingsTransaction = savingsTransaction;
        this.client = savingsAccount.getClient();
        this.note = note;
        this.noteTypeId = NoteType.SAVINGS_TRANSACTION.getValue();
    }

    public static Note shareNote(ShareAccount account, String note) {
        return new Note(account, note);
    }

    public Note(Client client, String note) {
        this.client = client;
        this.note = note;
        this.noteTypeId = NoteType.CLIENT.getValue();
    }

    private Note(Group group, String note) {
        this.group = group;
        this.note = note;
        this.client = null;
        this.noteTypeId = NoteType.GROUP.getValue();
    }

    private Note(Loan loan, String note) {
        this.loan = loan;
        this.client = loan.client();
        this.note = note;
        this.noteTypeId = NoteType.LOAN.getValue();
    }

    private Note(Loan loan, LoanTransaction loanTransaction, String note) {
        this.loan = loan;
        this.loanTransaction = loanTransaction;
        this.client = loan.client();
        this.note = note;
        this.noteTypeId = NoteType.LOAN_TRANSACTION.getValue();
    }

    protected Note() {
        this.client = null;
        this.group = null;
        this.loan = null;
        this.loanTransaction = null;
        this.note = null;
        this.noteTypeId = null;
    }

    public Note(SavingsAccount account, String note) {
        this.savingsAccount = account;
        this.client = account.getClient();
        this.note = note;
        this.noteTypeId = NoteType.SAVING_ACCOUNT.getValue();
    }

    public Note(ShareAccount account, String note) {
        this.shareAccount = account;
        this.client = account.getClient();
        this.note = note;
        this.noteTypeId = NoteType.SHARE_ACCOUNT.getValue();
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(7);
        String noteParamName = "note";
        if (command.isChangeInStringParameterNamed("note", this._persistence_get_note())) {
            String newValue = command.stringValueOfParameterNamed("note");
            actualChanges.put("note", newValue);
            this._persistence_set_note((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        return actualChanges;
    }

    public boolean isNotAgainstClientWithIdOf(Long clientId) {
        return !this._persistence_get_client().identifiedBy(clientId);
    }

    public String getNote() {
        return this._persistence_get_note();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Note(persistenceObject);
    }

    public Note(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "note") {
            return this.note;
        }
        if (string == "loan") {
            return this.loan;
        }
        if (string == "shareAccount") {
            return this.shareAccount;
        }
        if (string == "noteTypeId") {
            return this.noteTypeId;
        }
        if (string == "loanTransaction") {
            return this.loanTransaction;
        }
        if (string == "savingsAccount") {
            return this.savingsAccount;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "savingsTransaction") {
            return this.savingsTransaction;
        }
        if (string == "group") {
            return this.group;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "note") {
            this.note = (String)object;
            return;
        }
        if (string == "loan") {
            this.loan = (Loan)object;
            return;
        }
        if (string == "shareAccount") {
            this.shareAccount = (ShareAccount)object;
            return;
        }
        if (string == "noteTypeId") {
            this.noteTypeId = (Integer)object;
            return;
        }
        if (string == "loanTransaction") {
            this.loanTransaction = (LoanTransaction)object;
            return;
        }
        if (string == "savingsAccount") {
            this.savingsAccount = (SavingsAccount)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "savingsTransaction") {
            this.savingsTransaction = (SavingsAccountTransaction)object;
            return;
        }
        if (string == "group") {
            this.group = (Group)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_note() {
        this._persistence_checkFetched("note");
        return this.note;
    }

    public void _persistence_set_note(String string) {
        this._persistence_checkFetchedForSet("note");
        this._persistence_propertyChange("note", (Object)this.note, (Object)string);
        this.note = string;
    }

    public Loan _persistence_get_loan() {
        this._persistence_checkFetched("loan");
        return this.loan;
    }

    public void _persistence_set_loan(Loan loan) {
        this._persistence_checkFetchedForSet("loan");
        this._persistence_propertyChange("loan", (Object)this.loan, (Object)loan);
        this.loan = loan;
    }

    public ShareAccount _persistence_get_shareAccount() {
        this._persistence_checkFetched("shareAccount");
        return this.shareAccount;
    }

    public void _persistence_set_shareAccount(ShareAccount shareAccount) {
        this._persistence_checkFetchedForSet("shareAccount");
        this._persistence_propertyChange("shareAccount", (Object)this.shareAccount, (Object)shareAccount);
        this.shareAccount = shareAccount;
    }

    public Integer _persistence_get_noteTypeId() {
        this._persistence_checkFetched("noteTypeId");
        return this.noteTypeId;
    }

    public void _persistence_set_noteTypeId(Integer n) {
        this._persistence_checkFetchedForSet("noteTypeId");
        this._persistence_propertyChange("noteTypeId", (Object)this.noteTypeId, (Object)n);
        this.noteTypeId = n;
    }

    public LoanTransaction _persistence_get_loanTransaction() {
        this._persistence_checkFetched("loanTransaction");
        return this.loanTransaction;
    }

    public void _persistence_set_loanTransaction(LoanTransaction loanTransaction) {
        this._persistence_checkFetchedForSet("loanTransaction");
        this._persistence_propertyChange("loanTransaction", (Object)this.loanTransaction, (Object)loanTransaction);
        this.loanTransaction = loanTransaction;
    }

    public SavingsAccount _persistence_get_savingsAccount() {
        this._persistence_checkFetched("savingsAccount");
        return this.savingsAccount;
    }

    public void _persistence_set_savingsAccount(SavingsAccount savingsAccount) {
        this._persistence_checkFetchedForSet("savingsAccount");
        this._persistence_propertyChange("savingsAccount", (Object)this.savingsAccount, (Object)savingsAccount);
        this.savingsAccount = savingsAccount;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }

    public SavingsAccountTransaction _persistence_get_savingsTransaction() {
        this._persistence_checkFetched("savingsTransaction");
        return this.savingsTransaction;
    }

    public void _persistence_set_savingsTransaction(SavingsAccountTransaction savingsAccountTransaction) {
        this._persistence_checkFetchedForSet("savingsTransaction");
        this._persistence_propertyChange("savingsTransaction", (Object)this.savingsTransaction, (Object)savingsAccountTransaction);
        this.savingsTransaction = savingsAccountTransaction;
    }

    public Group _persistence_get_group() {
        this._persistence_checkFetched("group");
        return this.group;
    }

    public void _persistence_set_group(Group group) {
        this._persistence_checkFetchedForSet("group");
        this._persistence_propertyChange("group", (Object)this.group, (Object)group);
        this.group = group;
    }
}

