/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.savings.api.SavingsAccountChargesApiResourceSwagger;
import org.apache.fineract.portfolio.savings.api.SavingsApiSetConstants;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/savingsaccounts/{savingsAccountId}/charges")
@Component
@Tag(name="Savings Charges", description="Its typical for MFIs to add maintenance and operating charges. They can be either Fees or Penalties.\n\nSavings Charges are instances of Charges and represent either fees and penalties for savings products. Refer Charges for documentation of the various properties of a charge, Only additional properties ( specific to the context of a Charge being associated with a Savings account) are described here")
public class SavingsAccountChargesApiResource {
    private final PlatformSecurityContext context;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService;
    private final DefaultToApiJsonSerializer<SavingsAccountChargeData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Savings Charges", description="Lists Savings Charges\n\nExample Requests:\n\nsavingsaccounts/1/charges\n\nsavingsaccounts/1/charges?chargeStatus=all\n\nsavingsaccounts/1/charges?chargeStatus=inactive\n\nsavingsaccounts/1/charges?chargeStatus=active\n\nsavingsaccounts/1/charges?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.GetSavingsAccountsSavingsAccountIdChargesResponse.class)))})})
    public String retrieveAllSavingsAccountCharges(@PathParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Long savingsAccountId, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccountcharge");
        if (!(this.is(chargeStatus, "all") || this.is(chargeStatus, "active") || this.is(chargeStatus, "inactive"))) {
            throw new UnrecognizedQueryParamException("status", chargeStatus, new Object[]{"all", "active", "inactive"});
        }
        Collection savingsAccountCharges = this.savingsAccountChargeReadPlatformService.retrieveSavingsAccountCharges(savingsAccountId, chargeStatus);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, savingsAccountCharges, SavingsApiSetConstants.SAVINGS_ACCOUNT_CHARGES_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Savings Charges Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\nsavingsaccounts/1/charges/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.GetSavingsAccountsSavingsAccountIdChargesTemplateResponse.class))})})
    public String retrieveTemplate(@PathParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Long savingsAccountId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccountcharge");
        List chargeOptions = this.chargeReadPlatformService.retrieveSavingsAccountApplicableCharges(savingsAccountId);
        SavingsAccountChargeData savingsAccountChargeTemplate = SavingsAccountChargeData.template((Collection)chargeOptions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)savingsAccountChargeTemplate, SavingsApiSetConstants.SAVINGS_ACCOUNT_CHARGES_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{savingsAccountChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Savings account Charge", description="Retrieves a Savings account Charge\n\nExample Requests:\n\n/savingsaccounts/1/charges/5\n\n\n/savingsaccounts/1/charges/5?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.GetSavingsAccountsSavingsAccountIdChargesSavingsAccountChargeIdResponse.class))})})
    public String retrieveSavingsAccountCharge(@PathParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Long savingsAccountId, @PathParam(value="savingsAccountChargeId") @Parameter(description="savingsAccountChargeId") Long savingsAccountChargeId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccountcharge");
        SavingsAccountChargeData savingsAccountCharge = this.savingsAccountChargeReadPlatformService.retrieveSavingsAccountChargeDetails(savingsAccountChargeId, savingsAccountId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)savingsAccountCharge, SavingsApiSetConstants.SAVINGS_ACCOUNT_CHARGES_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Savings account Charge", description="Creates a Savings account Charge\n\nMandatory Fields for Savings account Charges: chargeId, amount\n\nchargeId, amount, dueDate, dateFormat, locale\n\nchargeId, amount, feeOnMonthDay, monthDayFormat, locale")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.PostSavingsAccountsSavingsAccountIdChargesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.PostSavingsAccountsSavingsAccountIdChargesResponse.class))})})
    public String addSavingsAccountCharge(@PathParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Long savingsAccountId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createSavingsAccountCharge(savingsAccountId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{savingsAccountChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Savings account Charge", description="Currently Savings account Charges may be updated only if the Savings account is not yet approved.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.PutSavingsAccountsSavingsAccountIdChargesSavingsAccountChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.PutSavingsAccountsSavingsAccountIdChargesSavingsAccountChargeIdResponse.class))})})
    public String updateSavingsAccountCharge(@PathParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Long savingsAccountId, @PathParam(value="savingsAccountChargeId") @Parameter(description="savingsAccountChargeId") Long savingsAccountChargeId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateSavingsAccountCharge(savingsAccountId, savingsAccountChargeId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{savingsAccountChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Pay a Savings account Charge | Waive off a Savings account Charge | Inactivate a Savings account Charge", description="Pay a Savings account Charge:\n\nAn active charge will be paid when savings account is active and having sufficient balance.\n\nWaive off a Savings account Charge:\n\nOutstanding charge amount will be waived off.\n\nInactivate a Savings account Charge:\n\nA charge will be allowed to inactivate when savings account is active and not having any dues as of today. If charge is overpaid, corresponding charge payment transactions will be reversed.\n\nShowing request/response for 'Pay a Savings account Charge'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.PostSavingsAccountsSavingsAccountIdChargesSavingsAccountChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.PostSavingsAccountsSavingsAccountIdChargesSavingsAccountChargeIdResponse.class))})})
    public String payOrWaiveSavingsAccountCharge(@PathParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Long savingsAccountId, @PathParam(value="savingsAccountChargeId") @Parameter(description="savingsAccountChargeId") Long savingsAccountChargeId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        String json = "";
        if (this.is(commandParam, "waive")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().waiveSavingsAccountCharge(savingsAccountId, savingsAccountChargeId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            json = this.toApiJsonSerializer.serialize((Object)result);
        } else if (this.is(commandParam, "paycharge")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().paySavingsAccountCharge(savingsAccountId, savingsAccountChargeId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            json = this.toApiJsonSerializer.serialize((Object)result);
        } else if (this.is(commandParam, "inactivate")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().inactivateSavingsAccountCharge(savingsAccountId, savingsAccountChargeId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            json = this.toApiJsonSerializer.serialize((Object)result);
        } else {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"paycharge", "waive", "inactivate"});
        }
        return json;
    }

    @DELETE
    @Path(value="{savingsAccountChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Savings account Charge", description="Note: Currently, A Savings account Charge may only be removed from Savings that are not yet approved.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountChargesApiResourceSwagger.DeleteSavingsAccountsSavingsAccountIdChargesSavingsAccountChargeIdResponse.class))})})
    public String deleteSavingsAccountCharge(@PathParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Long savingsAccountId, @PathParam(value="savingsAccountChargeId") @Parameter(description="savingsAccountChargeId") Long savingsAccountChargeId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteSavingsAccountCharge(savingsAccountId, savingsAccountChargeId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public SavingsAccountChargesApiResource(PlatformSecurityContext context, ChargeReadPlatformService chargeReadPlatformService, SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService, DefaultToApiJsonSerializer<SavingsAccountChargeData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.savingsAccountChargeReadPlatformService = savingsAccountChargeReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

