/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.registration.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import jakarta.persistence.PersistenceException;
import java.lang.reflect.Type;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.campaigns.sms.data.SmsProviderData;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignDropdownReadPlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.EmailDetail;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.GmailBackedPlatformEmailService;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.apache.fineract.infrastructure.sms.scheduler.SmsMessageScheduledJobService;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.self.registration.SelfServiceApiConstants;
import org.apache.fineract.portfolio.self.registration.domain.SelfServiceRegistration;
import org.apache.fineract.portfolio.self.registration.domain.SelfServiceRegistrationRepository;
import org.apache.fineract.portfolio.self.registration.exception.SelfServiceRegistrationNotFoundException;
import org.apache.fineract.portfolio.self.registration.service.SelfServiceRegistrationReadPlatformService;
import org.apache.fineract.portfolio.self.registration.service.SelfServiceRegistrationWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.PasswordValidationPolicy;
import org.apache.fineract.useradministration.domain.PasswordValidationPolicyRepository;
import org.apache.fineract.useradministration.domain.Role;
import org.apache.fineract.useradministration.domain.RoleRepository;
import org.apache.fineract.useradministration.domain.UserDomainService;
import org.apache.fineract.useradministration.exception.RoleNotFoundException;
import org.apache.fineract.useradministration.service.AppUserReadPlatformService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

/*
 * Exception performing whole class analysis ignored.
 */
public class SelfServiceRegistrationWritePlatformServiceImpl
implements SelfServiceRegistrationWritePlatformService {
    private final SelfServiceRegistrationRepository selfServiceRegistrationRepository;
    private final FromJsonHelper fromApiJsonHelper;
    private final SelfServiceRegistrationReadPlatformService selfServiceRegistrationReadPlatformService;
    private final ClientRepositoryWrapper clientRepository;
    private final PasswordValidationPolicyRepository passwordValidationPolicy;
    private final UserDomainService userDomainService;
    private final GmailBackedPlatformEmailService gmailBackedPlatformEmailService;
    private final SmsMessageRepository smsMessageRepository;
    private final SmsMessageScheduledJobService smsMessageScheduledJobService;
    private final SmsCampaignDropdownReadPlatformService smsCampaignDropdownReadPlatformService;
    private final AppUserReadPlatformService appUserReadPlatformService;
    private final RoleRepository roleRepository;
    private static final SecureRandom secureRandom = new SecureRandom();

    public SelfServiceRegistration createRegistrationRequest(String apiRequestBodyAsJson) {
        Gson gson = new Gson();
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("user");
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, apiRequestBodyAsJson, (Collection)SelfServiceApiConstants.REGISTRATION_REQUEST_DATA_PARAMETERS);
        JsonElement element = (JsonElement)gson.fromJson(apiRequestBodyAsJson.toString(), JsonElement.class);
        String accountNumber = this.fromApiJsonHelper.extractStringNamed("accountNumber", element);
        baseDataValidator.reset().parameter("accountNumber").value((Object)accountNumber).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String firstName = this.fromApiJsonHelper.extractStringNamed("firstName", element);
        baseDataValidator.reset().parameter("firstName").value((Object)firstName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String lastName = this.fromApiJsonHelper.extractStringNamed("lastName", element);
        baseDataValidator.reset().parameter("lastName").value((Object)lastName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String username = this.fromApiJsonHelper.extractStringNamed("username", element);
        baseDataValidator.reset().parameter("username").value((Object)username).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String password = this.fromApiJsonHelper.extractStringNamed("password", element);
        PasswordValidationPolicy validationPolicy = this.passwordValidationPolicy.findActivePasswordValidationPolicy();
        String regex = validationPolicy.getRegex();
        String description = validationPolicy.getDescription();
        baseDataValidator.reset().parameter("password").value((Object)password).matchesRegularExpression(regex, description).notExceedingLengthOf(Integer.valueOf(100));
        String authenticationMode = this.fromApiJsonHelper.extractStringNamed("authenticationMode", element);
        baseDataValidator.reset().parameter("authenticationMode").value((Object)authenticationMode).notBlank().isOneOfTheseStringValues(new Object[]{"email", "mobile"});
        String email = this.fromApiJsonHelper.extractStringNamed("email", element);
        baseDataValidator.reset().parameter("email").value((Object)email).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        boolean isEmailAuthenticationMode = authenticationMode.equalsIgnoreCase("email");
        String mobileNumber = null;
        if (!isEmailAuthenticationMode) {
            mobileNumber = this.fromApiJsonHelper.extractStringNamed("mobileNumber", element);
            baseDataValidator.reset().parameter("mobileNumber").value((Object)mobileNumber).notNull().validatePhoneNumber();
        }
        this.validateForDuplicateUsername(username);
        this.throwExceptionIfValidationError(dataValidationErrors, accountNumber, firstName, lastName, mobileNumber, isEmailAuthenticationMode);
        String authenticationToken = SelfServiceRegistrationWritePlatformServiceImpl.randomAuthorizationTokenGeneration();
        Client client = this.clientRepository.getClientByAccountNumber(accountNumber);
        SelfServiceRegistration selfServiceRegistration = SelfServiceRegistration.instance((Client)client, (String)accountNumber, (String)firstName, (String)lastName, (String)mobileNumber, (String)email, (String)authenticationToken, (String)username, (String)password);
        this.selfServiceRegistrationRepository.saveAndFlush((Object)selfServiceRegistration);
        this.sendAuthorizationToken(selfServiceRegistration, Boolean.valueOf(isEmailAuthenticationMode));
        return selfServiceRegistration;
    }

    public void validateForDuplicateUsername(String username) {
        boolean isDuplicateUserName = this.appUserReadPlatformService.isUsernameExist(username);
        if (isDuplicateUserName) {
            StringBuilder defaultMessageBuilder = new StringBuilder("User with username ").append(username).append(" already exists.");
            throw new PlatformDataIntegrityException("error.msg.user.duplicate.username", defaultMessageBuilder.toString(), "username", new Object[]{username});
        }
    }

    public void sendAuthorizationToken(SelfServiceRegistration selfServiceRegistration, Boolean isEmailAuthenticationMode) {
        if (isEmailAuthenticationMode.booleanValue()) {
            this.sendAuthorizationMail(selfServiceRegistration);
        } else {
            this.sendAuthorizationMessage(selfServiceRegistration);
        }
    }

    private void sendAuthorizationMessage(SelfServiceRegistration selfServiceRegistration) {
        Collection smsProviders = this.smsCampaignDropdownReadPlatformService.retrieveSmsProviders();
        if (smsProviders.isEmpty()) {
            throw new PlatformDataIntegrityException("error.msg.mobile.service.provider.not.available", "Mobile service provider not available.", new Object[0]);
        }
        Long providerId = ((SmsProviderData)new ArrayList(smsProviders).get(0)).getId();
        String message = "Hi  " + selfServiceRegistration.getFirstName() + ",\nTo create user, please use following details \nRequest Id : " + String.valueOf(selfServiceRegistration.getId()) + "\n Authentication Token : " + selfServiceRegistration.getAuthenticationToken();
        String externalId = null;
        Group group = null;
        Staff staff = null;
        SmsCampaign smsCampaign = null;
        boolean isNotification = false;
        SmsMessage smsMessage = SmsMessage.instance(externalId, group, (Client)selfServiceRegistration.getClient(), staff, (SmsMessageStatusType)SmsMessageStatusType.PENDING, (String)message, (String)selfServiceRegistration.getMobileNumber(), smsCampaign, (boolean)isNotification);
        this.smsMessageRepository.save((Object)smsMessage);
        this.smsMessageScheduledJobService.sendTriggeredMessage(new ArrayList<SmsMessage>(Arrays.asList(smsMessage)), providerId.longValue());
    }

    private void sendAuthorizationMail(SelfServiceRegistration selfServiceRegistration) {
        String subject = "Authorization token ";
        String body = "Hi  " + selfServiceRegistration.getFirstName() + ",\nTo create user, please use following details\nRequest Id : " + String.valueOf(selfServiceRegistration.getId()) + "\n Authentication Token : " + selfServiceRegistration.getAuthenticationToken();
        EmailDetail emailDetail = new EmailDetail("Authorization token ", body, selfServiceRegistration.getEmail(), selfServiceRegistration.getFirstName());
        this.gmailBackedPlatformEmailService.sendDefinedEmail(emailDetail);
    }

    private void throwExceptionIfValidationError(List<ApiParameterError> dataValidationErrors, String accountNumber, String firstName, String lastName, String mobileNumber, boolean isEmailAuthenticationMode) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        boolean isClientExist = this.selfServiceRegistrationReadPlatformService.isClientExist(accountNumber, firstName, lastName, mobileNumber, isEmailAuthenticationMode);
        if (!isClientExist) {
            throw new ClientNotFoundException();
        }
    }

    public static String randomAuthorizationTokenGeneration() {
        Integer randomPIN = (int)(secureRandom.nextDouble() * 9000.0) + 1000;
        return randomPIN.toString();
    }

    public AppUser createUser(String apiRequestBodyAsJson) {
        JsonCommand command = null;
        String username = null;
        try {
            Gson gson = new Gson();
            Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("user");
            this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, apiRequestBodyAsJson, (Collection)SelfServiceApiConstants.CREATE_USER_REQUEST_DATA_PARAMETERS);
            JsonElement element = (JsonElement)gson.fromJson(apiRequestBodyAsJson.toString(), JsonElement.class);
            Long id = this.fromApiJsonHelper.extractLongNamed("requestId", element);
            baseDataValidator.reset().parameter("requestId").value((Object)id).notNull().integerGreaterThanZero();
            command = JsonCommand.fromJsonElement((Long)id, (JsonElement)element);
            String authenticationToken = this.fromApiJsonHelper.extractStringNamed("authenticationToken", element);
            baseDataValidator.reset().parameter("authenticationToken").value((Object)authenticationToken).notBlank().notNull().notExceedingLengthOf(Integer.valueOf(100));
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
            SelfServiceRegistration selfServiceRegistration = this.selfServiceRegistrationRepository.getRequestByIdAndAuthenticationToken(id, authenticationToken);
            if (selfServiceRegistration == null) {
                throw new SelfServiceRegistrationNotFoundException(id, authenticationToken);
            }
            username = selfServiceRegistration.getUsername();
            Client client = selfServiceRegistration.getClient();
            boolean passwordNeverExpire = true;
            boolean isSelfServiceUser = true;
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            authorities.add(new SimpleGrantedAuthority("DUMMY_ROLE_NOT_USED_OR_PERSISTED_TO_AVOID_EXCEPTION"));
            HashSet<Role> allRoles = new HashSet<Role>();
            Role role = this.roleRepository.getRoleByName("Self Service User");
            if (role == null) {
                throw new RoleNotFoundException("Self Service User");
            }
            allRoles.add(role);
            ArrayList<Client> clients = new ArrayList<Client>(Arrays.asList(client));
            User user = new User(selfServiceRegistration.getUsername(), selfServiceRegistration.getPassword(), authorities);
            AppUser appUser = new AppUser(client.getOffice(), user, allRoles, selfServiceRegistration.getEmail(), client.getFirstname(), client.getLastname(), null, true, true, clients, null);
            this.userDomainService.create(appUser, Boolean.valueOf(true));
            return appUser;
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve, username);
            return null;
        }
        catch (PersistenceException | AuthenticationServiceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)dve, username);
            return null;
        }
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve, String username) {
        if (realCause.getMessage().contains("'username_org'")) {
            StringBuilder defaultMessageBuilder = new StringBuilder("User with username ").append(username).append(" already exists.");
            throw new PlatformDataIntegrityException("error.msg.user.duplicate.username", defaultMessageBuilder.toString(), "username", new Object[]{username});
        }
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Generated
    public SelfServiceRegistrationWritePlatformServiceImpl(SelfServiceRegistrationRepository selfServiceRegistrationRepository, FromJsonHelper fromApiJsonHelper, SelfServiceRegistrationReadPlatformService selfServiceRegistrationReadPlatformService, ClientRepositoryWrapper clientRepository, PasswordValidationPolicyRepository passwordValidationPolicy, UserDomainService userDomainService, GmailBackedPlatformEmailService gmailBackedPlatformEmailService, SmsMessageRepository smsMessageRepository, SmsMessageScheduledJobService smsMessageScheduledJobService, SmsCampaignDropdownReadPlatformService smsCampaignDropdownReadPlatformService, AppUserReadPlatformService appUserReadPlatformService, RoleRepository roleRepository) {
        this.selfServiceRegistrationRepository = selfServiceRegistrationRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.selfServiceRegistrationReadPlatformService = selfServiceRegistrationReadPlatformService;
        this.clientRepository = clientRepository;
        this.passwordValidationPolicy = passwordValidationPolicy;
        this.userDomainService = userDomainService;
        this.gmailBackedPlatformEmailService = gmailBackedPlatformEmailService;
        this.smsMessageRepository = smsMessageRepository;
        this.smsMessageScheduledJobService = smsMessageScheduledJobService;
        this.smsCampaignDropdownReadPlatformService = smsCampaignDropdownReadPlatformService;
        this.appUserReadPlatformService = appUserReadPlatformService;
        this.roleRepository = roleRepository;
    }
}

