/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountCharge;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountTransaction;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_account_charge_paid_by")
public class ShareAccountChargePaidBy
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne(optional=false)
    @JoinColumn(name="share_transaction_id", referencedColumnName="id", nullable=false)
    private ShareAccountTransaction shareAccountTransaction;
    @ManyToOne(optional=false)
    @JoinColumn(name="charge_transaction_id", referencedColumnName="id", nullable=false)
    private ShareAccountCharge shareAccountCharge;
    @Column(name="amount", scale=6, precision=19, nullable=false)
    private BigDecimal amount;
    static final long serialVersionUID = 1231691404677580810L;

    protected ShareAccountChargePaidBy() {
    }

    public ShareAccountChargePaidBy(ShareAccountTransaction shareAccountTransaction, ShareAccountCharge shareAccountCharge, BigDecimal amount) {
        this.shareAccountTransaction = shareAccountTransaction;
        this.shareAccountCharge = shareAccountCharge;
        this.amount = amount;
    }

    public ShareAccountCharge getCharge() {
        return this._persistence_get_shareAccountCharge();
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public ShareAccountTransaction getShareAccountTransaction() {
        return this._persistence_get_shareAccountTransaction();
    }

    public Long getChargeId() {
        return this._persistence_get_shareAccountCharge().getChargeId();
    }

    public Long getShareChargeId() {
        return (Long)this._persistence_get_shareAccountCharge().getId();
    }

    public void reset() {
        this._persistence_set_shareAccountTransaction(null);
        this._persistence_set_shareAccountCharge(null);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareAccountChargePaidBy(persistenceObject);
    }

    public ShareAccountChargePaidBy(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "amount") {
            return this.amount;
        }
        if (string == "shareAccountTransaction") {
            return this.shareAccountTransaction;
        }
        if (string == "shareAccountCharge") {
            return this.shareAccountCharge;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "shareAccountTransaction") {
            this.shareAccountTransaction = (ShareAccountTransaction)object;
            return;
        }
        if (string == "shareAccountCharge") {
            this.shareAccountCharge = (ShareAccountCharge)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", (Object)this.amount, (Object)bigDecimal);
        this.amount = bigDecimal;
    }

    public ShareAccountTransaction _persistence_get_shareAccountTransaction() {
        this._persistence_checkFetched("shareAccountTransaction");
        return this.shareAccountTransaction;
    }

    public void _persistence_set_shareAccountTransaction(ShareAccountTransaction shareAccountTransaction) {
        this._persistence_checkFetchedForSet("shareAccountTransaction");
        this._persistence_propertyChange("shareAccountTransaction", (Object)this.shareAccountTransaction, (Object)shareAccountTransaction);
        this.shareAccountTransaction = shareAccountTransaction;
    }

    public ShareAccountCharge _persistence_get_shareAccountCharge() {
        this._persistence_checkFetched("shareAccountCharge");
        return this.shareAccountCharge;
    }

    public void _persistence_set_shareAccountCharge(ShareAccountCharge shareAccountCharge) {
        this._persistence_checkFetchedForSet("shareAccountCharge");
        this._persistence_propertyChange("shareAccountCharge", (Object)this.shareAccountCharge, (Object)shareAccountCharge);
        this.shareAccountCharge = shareAccountCharge;
    }
}

