/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.tax.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepositoryWrapper;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.tax.domain.TaxComponent;
import org.apache.fineract.portfolio.tax.domain.TaxComponentRepositoryWrapper;
import org.apache.fineract.portfolio.tax.domain.TaxGroup;
import org.apache.fineract.portfolio.tax.domain.TaxGroupMappings;

public class TaxAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final GLAccountRepositoryWrapper glAccountRepositoryWrapper;
    private final TaxComponentRepositoryWrapper taxComponentRepositoryWrapper;

    public TaxComponent assembleTaxComponentFrom(JsonCommand command) {
        JsonElement element = command.parsedJson();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("tax.component");
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        BigDecimal percentage = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("percentage", element);
        Integer debitAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("debitAccountType", element);
        Long debitAccountId = this.fromApiJsonHelper.extractLongNamed("debitAcountId", element);
        GLAccountType debitGlAccountType = null;
        if (debitAccountType != null) {
            debitGlAccountType = GLAccountType.fromInt((Integer)debitAccountType);
        }
        GLAccount debitGlAccount = null;
        if (debitAccountId != null && (!(debitGlAccount = this.glAccountRepositoryWrapper.findOneWithNotFoundDetection(debitAccountId)).getType().equals(debitAccountType) || debitGlAccount.isHeaderAccount())) {
            baseDataValidator.parameter("debitAcountId").value((Object)debitAccountId).failWithCode("not.a.valid.account", new Object[0]);
        }
        Integer creditAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("creditAccountType", element);
        GLAccountType creditGlAccountType = null;
        if (creditAccountType != null) {
            creditGlAccountType = GLAccountType.fromInt((Integer)creditAccountType);
        }
        Long creditAccountId = this.fromApiJsonHelper.extractLongNamed("creditAcountId", element);
        GLAccount creditGlAccount = null;
        if (creditAccountId != null && (!(creditGlAccount = this.glAccountRepositoryWrapper.findOneWithNotFoundDetection(creditAccountId)).getType().equals(creditAccountType) || creditGlAccount.isHeaderAccount())) {
            baseDataValidator.parameter("creditAcountId").value((Object)creditAccountId).failWithCode("not.a.valid.account", new Object[0]);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed("startDate", element);
        if (startDate == null) {
            startDate = DateUtils.getBusinessLocalDate();
        }
        return TaxComponent.createTaxComponent((String)name, (BigDecimal)percentage, (GLAccountType)debitGlAccountType, (GLAccount)debitGlAccount, (GLAccountType)creditGlAccountType, (GLAccount)creditGlAccount, (LocalDate)startDate);
    }

    public TaxGroup assembleTaxGroupFrom(JsonCommand command) {
        JsonElement element = command.parsedJson();
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        boolean isUpdate = false;
        Set groupMappings = this.assembleTaxGroupMappingsFrom(command, isUpdate);
        return TaxGroup.createTaxGroup((String)name, (Set)groupMappings);
    }

    public Set<TaxGroupMappings> assembleTaxGroupMappingsFrom(JsonCommand command, boolean isUpdate) {
        HashSet<TaxGroupMappings> groupMappings = new HashSet<TaxGroupMappings>();
        JsonElement element = command.parsedJson();
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(topLevelJsonElement);
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        if (topLevelJsonElement.get("taxComponents").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("taxComponents").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject taxComponent = array.get(i).getAsJsonObject();
                Long mappingId = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)taxComponent);
                Long taxComponentId = this.fromApiJsonHelper.extractLongNamed("taxComponentId", (JsonElement)taxComponent);
                TaxComponent component = null;
                if (taxComponentId != null) {
                    component = this.taxComponentRepositoryWrapper.findOneWithNotFoundDetection(taxComponentId);
                }
                LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed("startDate", (JsonElement)taxComponent, dateFormat, locale);
                LocalDate endDate = this.fromApiJsonHelper.extractLocalDateNamed("endDate", (JsonElement)taxComponent, dateFormat, locale);
                if (endDate == null && startDate == null) {
                    startDate = DateUtils.getBusinessLocalDate();
                }
                TaxGroupMappings mappings = null;
                mappings = isUpdate && mappingId != null ? TaxGroupMappings.createTaxGroupMappings((Long)mappingId, (TaxComponent)component, (LocalDate)endDate) : TaxGroupMappings.createTaxGroupMappings((TaxComponent)component, (LocalDate)startDate);
                groupMappings.add(mappings);
            }
        }
        return groupMappings;
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    @Generated
    public TaxAssembler(FromJsonHelper fromApiJsonHelper, GLAccountRepositoryWrapper glAccountRepositoryWrapper, TaxComponentRepositoryWrapper taxComponentRepositoryWrapper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.glAccountRepositoryWrapper = glAccountRepositoryWrapper;
        this.taxComponentRepositoryWrapper = taxComponentRepositoryWrapper;
    }
}

