/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.template.domain;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.template.domain.TemplateEntity;
import org.apache.fineract.template.domain.TemplateEntitySerializer;
import org.apache.fineract.template.domain.TemplateMapper;
import org.apache.fineract.template.domain.TemplateType;
import org.apache.fineract.template.domain.TemplateTypeSerializer;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_template", uniqueConstraints={@UniqueConstraint(columnNames={"name"}, name="unq_name")})
public class Template
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Column(name="name", nullable=false, unique=true)
    private String name;
    @Enumerated
    @JsonSerialize(using=TemplateEntitySerializer.class)
    private TemplateEntity entity;
    @Enumerated
    @JsonSerialize(using=TemplateTypeSerializer.class)
    private TemplateType type;
    @Column(name="text", columnDefinition="longtext", nullable=false)
    private String text;
    @OrderBy(value="mapperorder")
    @OneToMany(targetEntity=TemplateMapper.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="m_template_m_templatemappers", joinColumns={@JoinColumn(name="m_template_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="mappers_id", referencedColumnName="id", unique=true)})
    private List<TemplateMapper> mappers;
    static final long serialVersionUID = -8316303674364841843L;

    public Template(String name, String text, TemplateEntity entity, TemplateType type, List<TemplateMapper> mappers) {
        this.name = (String)StringUtils.defaultIfEmpty((CharSequence)name, null);
        this.entity = entity;
        this.type = type;
        this.text = (String)StringUtils.defaultIfEmpty((CharSequence)text, null);
        this.mappers = mappers;
    }

    protected Template() {
    }

    public static Template fromJson(JsonCommand command) {
        String name = command.stringValueOfParameterNamed("name");
        String text = command.stringValueOfParameterNamed("text");
        TemplateEntity entity = TemplateEntity.values()[command.integerValueSansLocaleOfParameterNamed("entity")];
        int templateTypeId = command.integerValueSansLocaleOfParameterNamed("type");
        TemplateType type = null;
        switch (templateTypeId) {
            case 0: {
                type = TemplateType.DOCUMENT;
                break;
            }
            case 2: {
                type = TemplateType.SMS;
            }
        }
        JsonArray array = command.arrayOfParameterNamed("mappers");
        ArrayList<TemplateMapper> mappersList = new ArrayList<TemplateMapper>();
        for (JsonElement element : array) {
            mappersList.add(new TemplateMapper(element.getAsJsonObject().get("mappersorder").getAsInt(), element.getAsJsonObject().get("mapperskey").getAsString(), element.getAsJsonObject().get("mappersvalue").getAsString()));
        }
        return new Template(name, text, entity, type, mappersList);
    }

    public LinkedHashMap<String, String> getMappersAsMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (TemplateMapper mapper : this.getMappers()) {
            map.put(mapper.getMapperkey(), mapper.getMappervalue());
        }
        return map;
    }

    public List<TemplateMapper> getMappers() {
        return this._persistence_get_mappers();
    }

    public void setMappers(List<TemplateMapper> mappers) {
        this._persistence_set_mappers(mappers);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public TemplateEntity getEntity() {
        return this._persistence_get_entity();
    }

    public void setEntity(TemplateEntity entity) {
        this._persistence_set_entity(entity);
    }

    public TemplateType getType() {
        return this._persistence_get_type();
    }

    public void setType(TemplateType type) {
        this._persistence_set_type(type);
    }

    public String getText() {
        return this._persistence_get_text();
    }

    public void setText(String text) {
        this._persistence_set_text(text);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Template(persistenceObject);
    }

    public Template(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "name") {
            return this.name;
        }
        if (string == "text") {
            return this.text;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "entity") {
            return this.entity;
        }
        if (string == "mappers") {
            return this.mappers;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "text") {
            this.text = (String)object;
            return;
        }
        if (string == "type") {
            this.type = (TemplateType)object;
            return;
        }
        if (string == "entity") {
            this.entity = (TemplateEntity)object;
            return;
        }
        if (string == "mappers") {
            this.mappers = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public String _persistence_get_text() {
        this._persistence_checkFetched("text");
        return this.text;
    }

    public void _persistence_set_text(String string) {
        this._persistence_checkFetchedForSet("text");
        this.text = string;
    }

    public TemplateType _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(TemplateType templateType) {
        this._persistence_checkFetchedForSet("type");
        this.type = templateType;
    }

    public TemplateEntity _persistence_get_entity() {
        this._persistence_checkFetched("entity");
        return this.entity;
    }

    public void _persistence_set_entity(TemplateEntity templateEntity) {
        this._persistence_checkFetchedForSet("entity");
        this.entity = templateEntity;
    }

    public List _persistence_get_mappers() {
        this._persistence_checkFetched("mappers");
        return this.mappers;
    }

    public void _persistence_set_mappers(List list) {
        this._persistence_checkFetchedForSet("mappers");
        this.mappers = list;
    }
}

