/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.useradministration.data.AppUserData;
import org.apache.fineract.useradministration.data.RoleData;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserClientMapping;
import org.apache.fineract.useradministration.domain.AppUserRepository;
import org.apache.fineract.useradministration.domain.Role;
import org.apache.fineract.useradministration.exception.UserNotFoundException;
import org.apache.fineract.useradministration.service.AppUserReadPlatformService;
import org.apache.fineract.useradministration.service.AppUserReadPlatformServiceImpl;
import org.apache.fineract.useradministration.service.RoleReadPlatformService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class AppUserReadPlatformServiceImpl
implements AppUserReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final RoleReadPlatformService roleReadPlatformService;
    private final AppUserRepository appUserRepository;
    private final StaffReadPlatformService staffReadPlatformService;

    public PlatformSecurityContext getContext() {
        return this.context;
    }

    @Cacheable(value={"users"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy())")
    public Collection<AppUserData> retrieveAllUsers() {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        AppUserMapper mapper = new AppUserMapper(this.roleReadPlatformService, this.staffReadPlatformService);
        String sql = "select " + mapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)mapper, new Object[]{hierarchySearchString});
    }

    public Collection<AppUserData> retrieveSearchTemplate() {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        AppUserLookupMapper mapper = new AppUserLookupMapper();
        String sql = "select " + mapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)mapper, new Object[]{hierarchySearchString});
    }

    public AppUserData retrieveNewUserDetails() {
        Collection offices = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        Collection availableRoles = this.roleReadPlatformService.retrieveAllActiveRoles();
        Collection selfServiceRoles = this.roleReadPlatformService.retrieveAllSelfServiceRoles();
        return AppUserData.template((Collection)offices, (Collection)availableRoles, (Collection)selfServiceRoles);
    }

    public AppUserData retrieveUser(Long userId) {
        this.context.authenticatedUser();
        AppUser user = (AppUser)this.appUserRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        if (user.isDeleted()) {
            throw new UserNotFoundException(userId);
        }
        Collection availableRoles = this.roleReadPlatformService.retrieveAll();
        ArrayList<RoleData> selectedUserRoles = new ArrayList<RoleData>();
        Set userRoles = user.getRoles();
        for (Role role : userRoles) {
            selectedUserRoles.add(role.toData());
        }
        availableRoles.removeAll(selectedUserRoles);
        StaffData linkedStaff = user.getStaff() != null ? this.staffReadPlatformService.retrieveStaff(user.getStaffId()) : null;
        AppUserData retUser = AppUserData.instance((Long)((Long)user.getId()), (String)user.getUsername(), (String)user.getEmail(), (Long)((Long)user.getOffice().getId()), (String)user.getOffice().getName(), (String)user.getFirstname(), (String)user.getLastname(), (Collection)availableRoles, null, selectedUserRoles, (StaffData)linkedStaff, (Boolean)user.getPasswordNeverExpires(), (Boolean)user.isSelfServiceUser());
        if (retUser.isSelfServiceUser()) {
            HashSet<ClientData> clients = new HashSet<ClientData>();
            for (AppUserClientMapping clientMap : user.getAppUserClientMappings()) {
                Client client = clientMap.getClient();
                clients.add(ClientData.lookup((Long)((Long)client.getId()), (String)client.getDisplayName(), (Long)((Long)client.getOffice().getId()), (String)client.getOffice().getName()));
            }
            retUser.setClients(clients);
        }
        return retUser;
    }

    public boolean isUsernameExist(String username) {
        String sql = "select count(*) from m_appuser where username = ?";
        Object[] params = new Object[]{username};
        int count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, params);
        return count != 0;
    }

    @Generated
    public AppUserReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, OfficeReadPlatformService officeReadPlatformService, RoleReadPlatformService roleReadPlatformService, AppUserRepository appUserRepository, StaffReadPlatformService staffReadPlatformService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.officeReadPlatformService = officeReadPlatformService;
        this.roleReadPlatformService = roleReadPlatformService;
        this.appUserRepository = appUserRepository;
        this.staffReadPlatformService = staffReadPlatformService;
    }
}

