/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.fineract.client.models.GetLoansLoanIdCurrency;
import org.apache.fineract.client.models.GetLoansLoanIdDisbursementDetails;
import org.apache.fineract.client.models.GetLoansLoanIdLinkedAccount;
import org.apache.fineract.client.models.GetLoansLoanIdOverdueCharges;

/**
 * GetSelfLoanIdSummary
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetSelfLoanIdSummary {
  public static final String SERIALIZED_NAME_CAN_DISBURSE = "canDisburse";
  @SerializedName(SERIALIZED_NAME_CAN_DISBURSE)
  private Boolean canDisburse;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private GetLoansLoanIdCurrency currency;

  public static final String SERIALIZED_NAME_DISBURSEMENT_DETAILS = "disbursementDetails";
  @SerializedName(SERIALIZED_NAME_DISBURSEMENT_DETAILS)
  private Set<GetLoansLoanIdDisbursementDetails> disbursementDetails;

  public static final String SERIALIZED_NAME_EMI_AMOUNT_VARIATIONS = "emiAmountVariations";
  @SerializedName(SERIALIZED_NAME_EMI_AMOUNT_VARIATIONS)
  private Set<Object> emiAmountVariations;

  public static final String SERIALIZED_NAME_FEE_CHARGES_CHARGED = "feeChargesCharged";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_CHARGED)
  private Double feeChargesCharged;

  public static final String SERIALIZED_NAME_FEE_CHARGES_DUE_AT_DISBURSEMENT_CHARGED = "feeChargesDueAtDisbursementCharged";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_DUE_AT_DISBURSEMENT_CHARGED)
  private Double feeChargesDueAtDisbursementCharged;

  public static final String SERIALIZED_NAME_FEE_CHARGES_OUTSTANDING = "feeChargesOutstanding";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_OUTSTANDING)
  private Double feeChargesOutstanding;

  public static final String SERIALIZED_NAME_FEE_CHARGES_OVERDUE = "feeChargesOverdue";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_OVERDUE)
  private Double feeChargesOverdue;

  public static final String SERIALIZED_NAME_FEE_CHARGES_PAID = "feeChargesPaid";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_PAID)
  private Double feeChargesPaid;

  public static final String SERIALIZED_NAME_FEE_CHARGES_WAIVED = "feeChargesWaived";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_WAIVED)
  private Double feeChargesWaived;

  public static final String SERIALIZED_NAME_FEE_CHARGES_WRITTEN_OFF = "feeChargesWrittenOff";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_WRITTEN_OFF)
  private Double feeChargesWrittenOff;

  public static final String SERIALIZED_NAME_FIXED_EMI_AMOUNT = "fixedEmiAmount";
  @SerializedName(SERIALIZED_NAME_FIXED_EMI_AMOUNT)
  private Double fixedEmiAmount;

  public static final String SERIALIZED_NAME_IN_ARREARS = "inArrears";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS)
  private Boolean inArrears;

  public static final String SERIALIZED_NAME_INTEREST_CHARGED = "interestCharged";
  @SerializedName(SERIALIZED_NAME_INTEREST_CHARGED)
  private Double interestCharged;

  public static final String SERIALIZED_NAME_INTEREST_OUTSTANDING = "interestOutstanding";
  @SerializedName(SERIALIZED_NAME_INTEREST_OUTSTANDING)
  private Double interestOutstanding;

  public static final String SERIALIZED_NAME_INTEREST_OVERDUE = "interestOverdue";
  @SerializedName(SERIALIZED_NAME_INTEREST_OVERDUE)
  private Double interestOverdue;

  public static final String SERIALIZED_NAME_INTEREST_PAID = "interestPaid";
  @SerializedName(SERIALIZED_NAME_INTEREST_PAID)
  private Double interestPaid;

  public static final String SERIALIZED_NAME_INTEREST_WAIVED = "interestWaived";
  @SerializedName(SERIALIZED_NAME_INTEREST_WAIVED)
  private Double interestWaived;

  public static final String SERIALIZED_NAME_INTEREST_WRITTEN_OFF = "interestWrittenOff";
  @SerializedName(SERIALIZED_NAME_INTEREST_WRITTEN_OFF)
  private Double interestWrittenOff;

  public static final String SERIALIZED_NAME_IS_N_P_A = "isNPA";
  @SerializedName(SERIALIZED_NAME_IS_N_P_A)
  private Boolean isNPA;

  public static final String SERIALIZED_NAME_LINKED_ACCOUNT = "linkedAccount";
  @SerializedName(SERIALIZED_NAME_LINKED_ACCOUNT)
  private GetLoansLoanIdLinkedAccount linkedAccount;

  public static final String SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE = "maxOutstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE)
  private Double maxOutstandingLoanBalance;

  public static final String SERIALIZED_NAME_OVERDUE_CHARGES = "overdueCharges";
  @SerializedName(SERIALIZED_NAME_OVERDUE_CHARGES)
  private Set<GetLoansLoanIdOverdueCharges> overdueCharges;

  public static final String SERIALIZED_NAME_OVERDUE_SINCE_DATE = "overdueSinceDate";
  @SerializedName(SERIALIZED_NAME_OVERDUE_SINCE_DATE)
  private LocalDate overdueSinceDate;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_CHARGED = "penaltyChargesCharged";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_CHARGED)
  private Double penaltyChargesCharged;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_OUTSTANDING = "penaltyChargesOutstanding";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_OUTSTANDING)
  private Double penaltyChargesOutstanding;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_OVERDUE = "penaltyChargesOverdue";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_OVERDUE)
  private Double penaltyChargesOverdue;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_PAID = "penaltyChargesPaid";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_PAID)
  private Double penaltyChargesPaid;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_WAIVED = "penaltyChargesWaived";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_WAIVED)
  private Double penaltyChargesWaived;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_WRITTEN_OFF = "penaltyChargesWrittenOff";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_WRITTEN_OFF)
  private Double penaltyChargesWrittenOff;

  public static final String SERIALIZED_NAME_PRINCIPAL_ADJUSTMENTS = "principalAdjustments";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_ADJUSTMENTS)
  private Double principalAdjustments;

  public static final String SERIALIZED_NAME_PRINCIPAL_DISBURSED = "principalDisbursed";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_DISBURSED)
  private Double principalDisbursed;

  public static final String SERIALIZED_NAME_PRINCIPAL_OUTSTANDING = "principalOutstanding";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_OUTSTANDING)
  private Double principalOutstanding;

  public static final String SERIALIZED_NAME_PRINCIPAL_OVERDUE = "principalOverdue";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_OVERDUE)
  private Double principalOverdue;

  public static final String SERIALIZED_NAME_PRINCIPAL_PAID = "principalPaid";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_PAID)
  private Double principalPaid;

  public static final String SERIALIZED_NAME_PRINCIPAL_WRITTEN_OFF = "principalWrittenOff";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_WRITTEN_OFF)
  private Double principalWrittenOff;

  public static final String SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT = "totalChargeAdjustment";
  @SerializedName(SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT)
  private Double totalChargeAdjustment;

  public static final String SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT_REVERSED = "totalChargeAdjustmentReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT_REVERSED)
  private Double totalChargeAdjustmentReversed;

  public static final String SERIALIZED_NAME_TOTAL_CHARGEBACK = "totalChargeback";
  @SerializedName(SERIALIZED_NAME_TOTAL_CHARGEBACK)
  private Double totalChargeback;

  public static final String SERIALIZED_NAME_TOTAL_COST_OF_LOAN = "totalCostOfLoan";
  @SerializedName(SERIALIZED_NAME_TOTAL_COST_OF_LOAN)
  private Double totalCostOfLoan;

  public static final String SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND = "totalCreditBalanceRefund";
  @SerializedName(SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND)
  private Double totalCreditBalanceRefund;

  public static final String SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND_REVERSED = "totalCreditBalanceRefundReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND_REVERSED)
  private Double totalCreditBalanceRefundReversed;

  public static final String SERIALIZED_NAME_TOTAL_EXPECTED_COST_OF_LOAN = "totalExpectedCostOfLoan";
  @SerializedName(SERIALIZED_NAME_TOTAL_EXPECTED_COST_OF_LOAN)
  private Double totalExpectedCostOfLoan;

  public static final String SERIALIZED_NAME_TOTAL_EXPECTED_REPAYMENT = "totalExpectedRepayment";
  @SerializedName(SERIALIZED_NAME_TOTAL_EXPECTED_REPAYMENT)
  private Double totalExpectedRepayment;

  public static final String SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT = "totalGoodwillCredit";
  @SerializedName(SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT)
  private Double totalGoodwillCredit;

  public static final String SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT_REVERSED = "totalGoodwillCreditReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT_REVERSED)
  private Double totalGoodwillCreditReversed;

  public static final String SERIALIZED_NAME_TOTAL_MERCHANT_REFUND = "totalMerchantRefund";
  @SerializedName(SERIALIZED_NAME_TOTAL_MERCHANT_REFUND)
  private Double totalMerchantRefund;

  public static final String SERIALIZED_NAME_TOTAL_MERCHANT_REFUND_REVERSED = "totalMerchantRefundReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_MERCHANT_REFUND_REVERSED)
  private Double totalMerchantRefundReversed;

  public static final String SERIALIZED_NAME_TOTAL_OUTSTANDING = "totalOutstanding";
  @SerializedName(SERIALIZED_NAME_TOTAL_OUTSTANDING)
  private Double totalOutstanding;

  public static final String SERIALIZED_NAME_TOTAL_OVERDUE = "totalOverdue";
  @SerializedName(SERIALIZED_NAME_TOTAL_OVERDUE)
  private Double totalOverdue;

  public static final String SERIALIZED_NAME_TOTAL_PAYOUT_REFUND = "totalPayoutRefund";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAYOUT_REFUND)
  private Double totalPayoutRefund;

  public static final String SERIALIZED_NAME_TOTAL_PAYOUT_REFUND_REVERSED = "totalPayoutRefundReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAYOUT_REFUND_REVERSED)
  private Double totalPayoutRefundReversed;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT = "totalRepayment";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT)
  private Double totalRepayment;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION = "totalRepaymentTransaction";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION)
  private Double totalRepaymentTransaction;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION_REVERSED = "totalRepaymentTransactionReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION_REVERSED)
  private Double totalRepaymentTransactionReversed;

  public static final String SERIALIZED_NAME_TOTAL_WAIVED = "totalWaived";
  @SerializedName(SERIALIZED_NAME_TOTAL_WAIVED)
  private Double totalWaived;

  public static final String SERIALIZED_NAME_TOTAL_WRITTEN_OFF = "totalWrittenOff";
  @SerializedName(SERIALIZED_NAME_TOTAL_WRITTEN_OFF)
  private Double totalWrittenOff;

  public GetSelfLoanIdSummary() {
  }

  public GetSelfLoanIdSummary canDisburse(Boolean canDisburse) {
    
    this.canDisburse = canDisburse;
    return this;
  }

  /**
   * Get canDisburse
   * @return canDisburse
   */
  @javax.annotation.Nullable

  public Boolean getCanDisburse() {
    return canDisburse;
  }


  public void setCanDisburse(Boolean canDisburse) {
    this.canDisburse = canDisburse;
  }

  public GetSelfLoanIdSummary currency(GetLoansLoanIdCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(GetLoansLoanIdCurrency currency) {
    this.currency = currency;
  }

  public GetSelfLoanIdSummary disbursementDetails(Set<GetLoansLoanIdDisbursementDetails> disbursementDetails) {
    
    this.disbursementDetails = disbursementDetails;
    return this;
  }

  public GetSelfLoanIdSummary addDisbursementDetailsItem(GetLoansLoanIdDisbursementDetails disbursementDetailsItem) {
    if (this.disbursementDetails == null) {
      this.disbursementDetails = new LinkedHashSet<>();
    }
    this.disbursementDetails.add(disbursementDetailsItem);
    return this;
  }

  /**
   * Get disbursementDetails
   * @return disbursementDetails
   */
  @javax.annotation.Nullable

  public Set<GetLoansLoanIdDisbursementDetails> getDisbursementDetails() {
    return disbursementDetails;
  }


  public void setDisbursementDetails(Set<GetLoansLoanIdDisbursementDetails> disbursementDetails) {
    this.disbursementDetails = disbursementDetails;
  }

  public GetSelfLoanIdSummary emiAmountVariations(Set<Object> emiAmountVariations) {
    
    this.emiAmountVariations = emiAmountVariations;
    return this;
  }

  public GetSelfLoanIdSummary addEmiAmountVariationsItem(Object emiAmountVariationsItem) {
    if (this.emiAmountVariations == null) {
      this.emiAmountVariations = new LinkedHashSet<>();
    }
    this.emiAmountVariations.add(emiAmountVariationsItem);
    return this;
  }

  /**
   * Get emiAmountVariations
   * @return emiAmountVariations
   */
  @javax.annotation.Nullable

  public Set<Object> getEmiAmountVariations() {
    return emiAmountVariations;
  }


  public void setEmiAmountVariations(Set<Object> emiAmountVariations) {
    this.emiAmountVariations = emiAmountVariations;
  }

  public GetSelfLoanIdSummary feeChargesCharged(Double feeChargesCharged) {
    
    this.feeChargesCharged = feeChargesCharged;
    return this;
  }

  /**
   * Get feeChargesCharged
   * @return feeChargesCharged
   */
  @javax.annotation.Nullable

  public Double getFeeChargesCharged() {
    return feeChargesCharged;
  }


  public void setFeeChargesCharged(Double feeChargesCharged) {
    this.feeChargesCharged = feeChargesCharged;
  }

  public GetSelfLoanIdSummary feeChargesDueAtDisbursementCharged(Double feeChargesDueAtDisbursementCharged) {
    
    this.feeChargesDueAtDisbursementCharged = feeChargesDueAtDisbursementCharged;
    return this;
  }

  /**
   * Get feeChargesDueAtDisbursementCharged
   * @return feeChargesDueAtDisbursementCharged
   */
  @javax.annotation.Nullable

  public Double getFeeChargesDueAtDisbursementCharged() {
    return feeChargesDueAtDisbursementCharged;
  }


  public void setFeeChargesDueAtDisbursementCharged(Double feeChargesDueAtDisbursementCharged) {
    this.feeChargesDueAtDisbursementCharged = feeChargesDueAtDisbursementCharged;
  }

  public GetSelfLoanIdSummary feeChargesOutstanding(Double feeChargesOutstanding) {
    
    this.feeChargesOutstanding = feeChargesOutstanding;
    return this;
  }

  /**
   * Get feeChargesOutstanding
   * @return feeChargesOutstanding
   */
  @javax.annotation.Nullable

  public Double getFeeChargesOutstanding() {
    return feeChargesOutstanding;
  }


  public void setFeeChargesOutstanding(Double feeChargesOutstanding) {
    this.feeChargesOutstanding = feeChargesOutstanding;
  }

  public GetSelfLoanIdSummary feeChargesOverdue(Double feeChargesOverdue) {
    
    this.feeChargesOverdue = feeChargesOverdue;
    return this;
  }

  /**
   * Get feeChargesOverdue
   * @return feeChargesOverdue
   */
  @javax.annotation.Nullable

  public Double getFeeChargesOverdue() {
    return feeChargesOverdue;
  }


  public void setFeeChargesOverdue(Double feeChargesOverdue) {
    this.feeChargesOverdue = feeChargesOverdue;
  }

  public GetSelfLoanIdSummary feeChargesPaid(Double feeChargesPaid) {
    
    this.feeChargesPaid = feeChargesPaid;
    return this;
  }

  /**
   * Get feeChargesPaid
   * @return feeChargesPaid
   */
  @javax.annotation.Nullable

  public Double getFeeChargesPaid() {
    return feeChargesPaid;
  }


  public void setFeeChargesPaid(Double feeChargesPaid) {
    this.feeChargesPaid = feeChargesPaid;
  }

  public GetSelfLoanIdSummary feeChargesWaived(Double feeChargesWaived) {
    
    this.feeChargesWaived = feeChargesWaived;
    return this;
  }

  /**
   * Get feeChargesWaived
   * @return feeChargesWaived
   */
  @javax.annotation.Nullable

  public Double getFeeChargesWaived() {
    return feeChargesWaived;
  }


  public void setFeeChargesWaived(Double feeChargesWaived) {
    this.feeChargesWaived = feeChargesWaived;
  }

  public GetSelfLoanIdSummary feeChargesWrittenOff(Double feeChargesWrittenOff) {
    
    this.feeChargesWrittenOff = feeChargesWrittenOff;
    return this;
  }

  /**
   * Get feeChargesWrittenOff
   * @return feeChargesWrittenOff
   */
  @javax.annotation.Nullable

  public Double getFeeChargesWrittenOff() {
    return feeChargesWrittenOff;
  }


  public void setFeeChargesWrittenOff(Double feeChargesWrittenOff) {
    this.feeChargesWrittenOff = feeChargesWrittenOff;
  }

  public GetSelfLoanIdSummary fixedEmiAmount(Double fixedEmiAmount) {
    
    this.fixedEmiAmount = fixedEmiAmount;
    return this;
  }

  /**
   * Get fixedEmiAmount
   * @return fixedEmiAmount
   */
  @javax.annotation.Nullable

  public Double getFixedEmiAmount() {
    return fixedEmiAmount;
  }


  public void setFixedEmiAmount(Double fixedEmiAmount) {
    this.fixedEmiAmount = fixedEmiAmount;
  }

  public GetSelfLoanIdSummary inArrears(Boolean inArrears) {
    
    this.inArrears = inArrears;
    return this;
  }

  /**
   * Get inArrears
   * @return inArrears
   */
  @javax.annotation.Nullable

  public Boolean getInArrears() {
    return inArrears;
  }


  public void setInArrears(Boolean inArrears) {
    this.inArrears = inArrears;
  }

  public GetSelfLoanIdSummary interestCharged(Double interestCharged) {
    
    this.interestCharged = interestCharged;
    return this;
  }

  /**
   * Get interestCharged
   * @return interestCharged
   */
  @javax.annotation.Nullable

  public Double getInterestCharged() {
    return interestCharged;
  }


  public void setInterestCharged(Double interestCharged) {
    this.interestCharged = interestCharged;
  }

  public GetSelfLoanIdSummary interestOutstanding(Double interestOutstanding) {
    
    this.interestOutstanding = interestOutstanding;
    return this;
  }

  /**
   * Get interestOutstanding
   * @return interestOutstanding
   */
  @javax.annotation.Nullable

  public Double getInterestOutstanding() {
    return interestOutstanding;
  }


  public void setInterestOutstanding(Double interestOutstanding) {
    this.interestOutstanding = interestOutstanding;
  }

  public GetSelfLoanIdSummary interestOverdue(Double interestOverdue) {
    
    this.interestOverdue = interestOverdue;
    return this;
  }

  /**
   * Get interestOverdue
   * @return interestOverdue
   */
  @javax.annotation.Nullable

  public Double getInterestOverdue() {
    return interestOverdue;
  }


  public void setInterestOverdue(Double interestOverdue) {
    this.interestOverdue = interestOverdue;
  }

  public GetSelfLoanIdSummary interestPaid(Double interestPaid) {
    
    this.interestPaid = interestPaid;
    return this;
  }

  /**
   * Get interestPaid
   * @return interestPaid
   */
  @javax.annotation.Nullable

  public Double getInterestPaid() {
    return interestPaid;
  }


  public void setInterestPaid(Double interestPaid) {
    this.interestPaid = interestPaid;
  }

  public GetSelfLoanIdSummary interestWaived(Double interestWaived) {
    
    this.interestWaived = interestWaived;
    return this;
  }

  /**
   * Get interestWaived
   * @return interestWaived
   */
  @javax.annotation.Nullable

  public Double getInterestWaived() {
    return interestWaived;
  }


  public void setInterestWaived(Double interestWaived) {
    this.interestWaived = interestWaived;
  }

  public GetSelfLoanIdSummary interestWrittenOff(Double interestWrittenOff) {
    
    this.interestWrittenOff = interestWrittenOff;
    return this;
  }

  /**
   * Get interestWrittenOff
   * @return interestWrittenOff
   */
  @javax.annotation.Nullable

  public Double getInterestWrittenOff() {
    return interestWrittenOff;
  }


  public void setInterestWrittenOff(Double interestWrittenOff) {
    this.interestWrittenOff = interestWrittenOff;
  }

  public GetSelfLoanIdSummary isNPA(Boolean isNPA) {
    
    this.isNPA = isNPA;
    return this;
  }

  /**
   * Get isNPA
   * @return isNPA
   */
  @javax.annotation.Nullable

  public Boolean getIsNPA() {
    return isNPA;
  }


  public void setIsNPA(Boolean isNPA) {
    this.isNPA = isNPA;
  }

  public GetSelfLoanIdSummary linkedAccount(GetLoansLoanIdLinkedAccount linkedAccount) {
    
    this.linkedAccount = linkedAccount;
    return this;
  }

  /**
   * Get linkedAccount
   * @return linkedAccount
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdLinkedAccount getLinkedAccount() {
    return linkedAccount;
  }


  public void setLinkedAccount(GetLoansLoanIdLinkedAccount linkedAccount) {
    this.linkedAccount = linkedAccount;
  }

  public GetSelfLoanIdSummary maxOutstandingLoanBalance(Double maxOutstandingLoanBalance) {
    
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
    return this;
  }

  /**
   * Get maxOutstandingLoanBalance
   * @return maxOutstandingLoanBalance
   */
  @javax.annotation.Nullable

  public Double getMaxOutstandingLoanBalance() {
    return maxOutstandingLoanBalance;
  }


  public void setMaxOutstandingLoanBalance(Double maxOutstandingLoanBalance) {
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
  }

  public GetSelfLoanIdSummary overdueCharges(Set<GetLoansLoanIdOverdueCharges> overdueCharges) {
    
    this.overdueCharges = overdueCharges;
    return this;
  }

  public GetSelfLoanIdSummary addOverdueChargesItem(GetLoansLoanIdOverdueCharges overdueChargesItem) {
    if (this.overdueCharges == null) {
      this.overdueCharges = new LinkedHashSet<>();
    }
    this.overdueCharges.add(overdueChargesItem);
    return this;
  }

  /**
   * Get overdueCharges
   * @return overdueCharges
   */
  @javax.annotation.Nullable

  public Set<GetLoansLoanIdOverdueCharges> getOverdueCharges() {
    return overdueCharges;
  }


  public void setOverdueCharges(Set<GetLoansLoanIdOverdueCharges> overdueCharges) {
    this.overdueCharges = overdueCharges;
  }

  public GetSelfLoanIdSummary overdueSinceDate(LocalDate overdueSinceDate) {
    
    this.overdueSinceDate = overdueSinceDate;
    return this;
  }

  /**
   * Get overdueSinceDate
   * @return overdueSinceDate
   */
  @javax.annotation.Nullable

  public LocalDate getOverdueSinceDate() {
    return overdueSinceDate;
  }


  public void setOverdueSinceDate(LocalDate overdueSinceDate) {
    this.overdueSinceDate = overdueSinceDate;
  }

  public GetSelfLoanIdSummary penaltyChargesCharged(Double penaltyChargesCharged) {
    
    this.penaltyChargesCharged = penaltyChargesCharged;
    return this;
  }

  /**
   * Get penaltyChargesCharged
   * @return penaltyChargesCharged
   */
  @javax.annotation.Nullable

  public Double getPenaltyChargesCharged() {
    return penaltyChargesCharged;
  }


  public void setPenaltyChargesCharged(Double penaltyChargesCharged) {
    this.penaltyChargesCharged = penaltyChargesCharged;
  }

  public GetSelfLoanIdSummary penaltyChargesOutstanding(Double penaltyChargesOutstanding) {
    
    this.penaltyChargesOutstanding = penaltyChargesOutstanding;
    return this;
  }

  /**
   * Get penaltyChargesOutstanding
   * @return penaltyChargesOutstanding
   */
  @javax.annotation.Nullable

  public Double getPenaltyChargesOutstanding() {
    return penaltyChargesOutstanding;
  }


  public void setPenaltyChargesOutstanding(Double penaltyChargesOutstanding) {
    this.penaltyChargesOutstanding = penaltyChargesOutstanding;
  }

  public GetSelfLoanIdSummary penaltyChargesOverdue(Double penaltyChargesOverdue) {
    
    this.penaltyChargesOverdue = penaltyChargesOverdue;
    return this;
  }

  /**
   * Get penaltyChargesOverdue
   * @return penaltyChargesOverdue
   */
  @javax.annotation.Nullable

  public Double getPenaltyChargesOverdue() {
    return penaltyChargesOverdue;
  }


  public void setPenaltyChargesOverdue(Double penaltyChargesOverdue) {
    this.penaltyChargesOverdue = penaltyChargesOverdue;
  }

  public GetSelfLoanIdSummary penaltyChargesPaid(Double penaltyChargesPaid) {
    
    this.penaltyChargesPaid = penaltyChargesPaid;
    return this;
  }

  /**
   * Get penaltyChargesPaid
   * @return penaltyChargesPaid
   */
  @javax.annotation.Nullable

  public Double getPenaltyChargesPaid() {
    return penaltyChargesPaid;
  }


  public void setPenaltyChargesPaid(Double penaltyChargesPaid) {
    this.penaltyChargesPaid = penaltyChargesPaid;
  }

  public GetSelfLoanIdSummary penaltyChargesWaived(Double penaltyChargesWaived) {
    
    this.penaltyChargesWaived = penaltyChargesWaived;
    return this;
  }

  /**
   * Get penaltyChargesWaived
   * @return penaltyChargesWaived
   */
  @javax.annotation.Nullable

  public Double getPenaltyChargesWaived() {
    return penaltyChargesWaived;
  }


  public void setPenaltyChargesWaived(Double penaltyChargesWaived) {
    this.penaltyChargesWaived = penaltyChargesWaived;
  }

  public GetSelfLoanIdSummary penaltyChargesWrittenOff(Double penaltyChargesWrittenOff) {
    
    this.penaltyChargesWrittenOff = penaltyChargesWrittenOff;
    return this;
  }

  /**
   * Get penaltyChargesWrittenOff
   * @return penaltyChargesWrittenOff
   */
  @javax.annotation.Nullable

  public Double getPenaltyChargesWrittenOff() {
    return penaltyChargesWrittenOff;
  }


  public void setPenaltyChargesWrittenOff(Double penaltyChargesWrittenOff) {
    this.penaltyChargesWrittenOff = penaltyChargesWrittenOff;
  }

  public GetSelfLoanIdSummary principalAdjustments(Double principalAdjustments) {
    
    this.principalAdjustments = principalAdjustments;
    return this;
  }

  /**
   * Get principalAdjustments
   * @return principalAdjustments
   */
  @javax.annotation.Nullable

  public Double getPrincipalAdjustments() {
    return principalAdjustments;
  }


  public void setPrincipalAdjustments(Double principalAdjustments) {
    this.principalAdjustments = principalAdjustments;
  }

  public GetSelfLoanIdSummary principalDisbursed(Double principalDisbursed) {
    
    this.principalDisbursed = principalDisbursed;
    return this;
  }

  /**
   * Get principalDisbursed
   * @return principalDisbursed
   */
  @javax.annotation.Nullable

  public Double getPrincipalDisbursed() {
    return principalDisbursed;
  }


  public void setPrincipalDisbursed(Double principalDisbursed) {
    this.principalDisbursed = principalDisbursed;
  }

  public GetSelfLoanIdSummary principalOutstanding(Double principalOutstanding) {
    
    this.principalOutstanding = principalOutstanding;
    return this;
  }

  /**
   * Get principalOutstanding
   * @return principalOutstanding
   */
  @javax.annotation.Nullable

  public Double getPrincipalOutstanding() {
    return principalOutstanding;
  }


  public void setPrincipalOutstanding(Double principalOutstanding) {
    this.principalOutstanding = principalOutstanding;
  }

  public GetSelfLoanIdSummary principalOverdue(Double principalOverdue) {
    
    this.principalOverdue = principalOverdue;
    return this;
  }

  /**
   * Get principalOverdue
   * @return principalOverdue
   */
  @javax.annotation.Nullable

  public Double getPrincipalOverdue() {
    return principalOverdue;
  }


  public void setPrincipalOverdue(Double principalOverdue) {
    this.principalOverdue = principalOverdue;
  }

  public GetSelfLoanIdSummary principalPaid(Double principalPaid) {
    
    this.principalPaid = principalPaid;
    return this;
  }

  /**
   * Get principalPaid
   * @return principalPaid
   */
  @javax.annotation.Nullable

  public Double getPrincipalPaid() {
    return principalPaid;
  }


  public void setPrincipalPaid(Double principalPaid) {
    this.principalPaid = principalPaid;
  }

  public GetSelfLoanIdSummary principalWrittenOff(Double principalWrittenOff) {
    
    this.principalWrittenOff = principalWrittenOff;
    return this;
  }

  /**
   * Get principalWrittenOff
   * @return principalWrittenOff
   */
  @javax.annotation.Nullable

  public Double getPrincipalWrittenOff() {
    return principalWrittenOff;
  }


  public void setPrincipalWrittenOff(Double principalWrittenOff) {
    this.principalWrittenOff = principalWrittenOff;
  }

  public GetSelfLoanIdSummary totalChargeAdjustment(Double totalChargeAdjustment) {
    
    this.totalChargeAdjustment = totalChargeAdjustment;
    return this;
  }

  /**
   * Get totalChargeAdjustment
   * @return totalChargeAdjustment
   */
  @javax.annotation.Nullable

  public Double getTotalChargeAdjustment() {
    return totalChargeAdjustment;
  }


  public void setTotalChargeAdjustment(Double totalChargeAdjustment) {
    this.totalChargeAdjustment = totalChargeAdjustment;
  }

  public GetSelfLoanIdSummary totalChargeAdjustmentReversed(Double totalChargeAdjustmentReversed) {
    
    this.totalChargeAdjustmentReversed = totalChargeAdjustmentReversed;
    return this;
  }

  /**
   * Get totalChargeAdjustmentReversed
   * @return totalChargeAdjustmentReversed
   */
  @javax.annotation.Nullable

  public Double getTotalChargeAdjustmentReversed() {
    return totalChargeAdjustmentReversed;
  }


  public void setTotalChargeAdjustmentReversed(Double totalChargeAdjustmentReversed) {
    this.totalChargeAdjustmentReversed = totalChargeAdjustmentReversed;
  }

  public GetSelfLoanIdSummary totalChargeback(Double totalChargeback) {
    
    this.totalChargeback = totalChargeback;
    return this;
  }

  /**
   * Get totalChargeback
   * @return totalChargeback
   */
  @javax.annotation.Nullable

  public Double getTotalChargeback() {
    return totalChargeback;
  }


  public void setTotalChargeback(Double totalChargeback) {
    this.totalChargeback = totalChargeback;
  }

  public GetSelfLoanIdSummary totalCostOfLoan(Double totalCostOfLoan) {
    
    this.totalCostOfLoan = totalCostOfLoan;
    return this;
  }

  /**
   * Get totalCostOfLoan
   * @return totalCostOfLoan
   */
  @javax.annotation.Nullable

  public Double getTotalCostOfLoan() {
    return totalCostOfLoan;
  }


  public void setTotalCostOfLoan(Double totalCostOfLoan) {
    this.totalCostOfLoan = totalCostOfLoan;
  }

  public GetSelfLoanIdSummary totalCreditBalanceRefund(Double totalCreditBalanceRefund) {
    
    this.totalCreditBalanceRefund = totalCreditBalanceRefund;
    return this;
  }

  /**
   * Get totalCreditBalanceRefund
   * @return totalCreditBalanceRefund
   */
  @javax.annotation.Nullable

  public Double getTotalCreditBalanceRefund() {
    return totalCreditBalanceRefund;
  }


  public void setTotalCreditBalanceRefund(Double totalCreditBalanceRefund) {
    this.totalCreditBalanceRefund = totalCreditBalanceRefund;
  }

  public GetSelfLoanIdSummary totalCreditBalanceRefundReversed(Double totalCreditBalanceRefundReversed) {
    
    this.totalCreditBalanceRefundReversed = totalCreditBalanceRefundReversed;
    return this;
  }

  /**
   * Get totalCreditBalanceRefundReversed
   * @return totalCreditBalanceRefundReversed
   */
  @javax.annotation.Nullable

  public Double getTotalCreditBalanceRefundReversed() {
    return totalCreditBalanceRefundReversed;
  }


  public void setTotalCreditBalanceRefundReversed(Double totalCreditBalanceRefundReversed) {
    this.totalCreditBalanceRefundReversed = totalCreditBalanceRefundReversed;
  }

  public GetSelfLoanIdSummary totalExpectedCostOfLoan(Double totalExpectedCostOfLoan) {
    
    this.totalExpectedCostOfLoan = totalExpectedCostOfLoan;
    return this;
  }

  /**
   * Get totalExpectedCostOfLoan
   * @return totalExpectedCostOfLoan
   */
  @javax.annotation.Nullable

  public Double getTotalExpectedCostOfLoan() {
    return totalExpectedCostOfLoan;
  }


  public void setTotalExpectedCostOfLoan(Double totalExpectedCostOfLoan) {
    this.totalExpectedCostOfLoan = totalExpectedCostOfLoan;
  }

  public GetSelfLoanIdSummary totalExpectedRepayment(Double totalExpectedRepayment) {
    
    this.totalExpectedRepayment = totalExpectedRepayment;
    return this;
  }

  /**
   * Get totalExpectedRepayment
   * @return totalExpectedRepayment
   */
  @javax.annotation.Nullable

  public Double getTotalExpectedRepayment() {
    return totalExpectedRepayment;
  }


  public void setTotalExpectedRepayment(Double totalExpectedRepayment) {
    this.totalExpectedRepayment = totalExpectedRepayment;
  }

  public GetSelfLoanIdSummary totalGoodwillCredit(Double totalGoodwillCredit) {
    
    this.totalGoodwillCredit = totalGoodwillCredit;
    return this;
  }

  /**
   * Get totalGoodwillCredit
   * @return totalGoodwillCredit
   */
  @javax.annotation.Nullable

  public Double getTotalGoodwillCredit() {
    return totalGoodwillCredit;
  }


  public void setTotalGoodwillCredit(Double totalGoodwillCredit) {
    this.totalGoodwillCredit = totalGoodwillCredit;
  }

  public GetSelfLoanIdSummary totalGoodwillCreditReversed(Double totalGoodwillCreditReversed) {
    
    this.totalGoodwillCreditReversed = totalGoodwillCreditReversed;
    return this;
  }

  /**
   * Get totalGoodwillCreditReversed
   * @return totalGoodwillCreditReversed
   */
  @javax.annotation.Nullable

  public Double getTotalGoodwillCreditReversed() {
    return totalGoodwillCreditReversed;
  }


  public void setTotalGoodwillCreditReversed(Double totalGoodwillCreditReversed) {
    this.totalGoodwillCreditReversed = totalGoodwillCreditReversed;
  }

  public GetSelfLoanIdSummary totalMerchantRefund(Double totalMerchantRefund) {
    
    this.totalMerchantRefund = totalMerchantRefund;
    return this;
  }

  /**
   * Get totalMerchantRefund
   * @return totalMerchantRefund
   */
  @javax.annotation.Nullable

  public Double getTotalMerchantRefund() {
    return totalMerchantRefund;
  }


  public void setTotalMerchantRefund(Double totalMerchantRefund) {
    this.totalMerchantRefund = totalMerchantRefund;
  }

  public GetSelfLoanIdSummary totalMerchantRefundReversed(Double totalMerchantRefundReversed) {
    
    this.totalMerchantRefundReversed = totalMerchantRefundReversed;
    return this;
  }

  /**
   * Get totalMerchantRefundReversed
   * @return totalMerchantRefundReversed
   */
  @javax.annotation.Nullable

  public Double getTotalMerchantRefundReversed() {
    return totalMerchantRefundReversed;
  }


  public void setTotalMerchantRefundReversed(Double totalMerchantRefundReversed) {
    this.totalMerchantRefundReversed = totalMerchantRefundReversed;
  }

  public GetSelfLoanIdSummary totalOutstanding(Double totalOutstanding) {
    
    this.totalOutstanding = totalOutstanding;
    return this;
  }

  /**
   * Get totalOutstanding
   * @return totalOutstanding
   */
  @javax.annotation.Nullable

  public Double getTotalOutstanding() {
    return totalOutstanding;
  }


  public void setTotalOutstanding(Double totalOutstanding) {
    this.totalOutstanding = totalOutstanding;
  }

  public GetSelfLoanIdSummary totalOverdue(Double totalOverdue) {
    
    this.totalOverdue = totalOverdue;
    return this;
  }

  /**
   * Get totalOverdue
   * @return totalOverdue
   */
  @javax.annotation.Nullable

  public Double getTotalOverdue() {
    return totalOverdue;
  }


  public void setTotalOverdue(Double totalOverdue) {
    this.totalOverdue = totalOverdue;
  }

  public GetSelfLoanIdSummary totalPayoutRefund(Double totalPayoutRefund) {
    
    this.totalPayoutRefund = totalPayoutRefund;
    return this;
  }

  /**
   * Get totalPayoutRefund
   * @return totalPayoutRefund
   */
  @javax.annotation.Nullable

  public Double getTotalPayoutRefund() {
    return totalPayoutRefund;
  }


  public void setTotalPayoutRefund(Double totalPayoutRefund) {
    this.totalPayoutRefund = totalPayoutRefund;
  }

  public GetSelfLoanIdSummary totalPayoutRefundReversed(Double totalPayoutRefundReversed) {
    
    this.totalPayoutRefundReversed = totalPayoutRefundReversed;
    return this;
  }

  /**
   * Get totalPayoutRefundReversed
   * @return totalPayoutRefundReversed
   */
  @javax.annotation.Nullable

  public Double getTotalPayoutRefundReversed() {
    return totalPayoutRefundReversed;
  }


  public void setTotalPayoutRefundReversed(Double totalPayoutRefundReversed) {
    this.totalPayoutRefundReversed = totalPayoutRefundReversed;
  }

  public GetSelfLoanIdSummary totalRepayment(Double totalRepayment) {
    
    this.totalRepayment = totalRepayment;
    return this;
  }

  /**
   * Get totalRepayment
   * @return totalRepayment
   */
  @javax.annotation.Nullable

  public Double getTotalRepayment() {
    return totalRepayment;
  }


  public void setTotalRepayment(Double totalRepayment) {
    this.totalRepayment = totalRepayment;
  }

  public GetSelfLoanIdSummary totalRepaymentTransaction(Double totalRepaymentTransaction) {
    
    this.totalRepaymentTransaction = totalRepaymentTransaction;
    return this;
  }

  /**
   * Get totalRepaymentTransaction
   * @return totalRepaymentTransaction
   */
  @javax.annotation.Nullable

  public Double getTotalRepaymentTransaction() {
    return totalRepaymentTransaction;
  }


  public void setTotalRepaymentTransaction(Double totalRepaymentTransaction) {
    this.totalRepaymentTransaction = totalRepaymentTransaction;
  }

  public GetSelfLoanIdSummary totalRepaymentTransactionReversed(Double totalRepaymentTransactionReversed) {
    
    this.totalRepaymentTransactionReversed = totalRepaymentTransactionReversed;
    return this;
  }

  /**
   * Get totalRepaymentTransactionReversed
   * @return totalRepaymentTransactionReversed
   */
  @javax.annotation.Nullable

  public Double getTotalRepaymentTransactionReversed() {
    return totalRepaymentTransactionReversed;
  }


  public void setTotalRepaymentTransactionReversed(Double totalRepaymentTransactionReversed) {
    this.totalRepaymentTransactionReversed = totalRepaymentTransactionReversed;
  }

  public GetSelfLoanIdSummary totalWaived(Double totalWaived) {
    
    this.totalWaived = totalWaived;
    return this;
  }

  /**
   * Get totalWaived
   * @return totalWaived
   */
  @javax.annotation.Nullable

  public Double getTotalWaived() {
    return totalWaived;
  }


  public void setTotalWaived(Double totalWaived) {
    this.totalWaived = totalWaived;
  }

  public GetSelfLoanIdSummary totalWrittenOff(Double totalWrittenOff) {
    
    this.totalWrittenOff = totalWrittenOff;
    return this;
  }

  /**
   * Get totalWrittenOff
   * @return totalWrittenOff
   */
  @javax.annotation.Nullable

  public Double getTotalWrittenOff() {
    return totalWrittenOff;
  }


  public void setTotalWrittenOff(Double totalWrittenOff) {
    this.totalWrittenOff = totalWrittenOff;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetSelfLoanIdSummary getSelfLoanIdSummary = (GetSelfLoanIdSummary) o;
    return Objects.equals(this.canDisburse, getSelfLoanIdSummary.canDisburse) &&
        Objects.equals(this.currency, getSelfLoanIdSummary.currency) &&
        Objects.equals(this.disbursementDetails, getSelfLoanIdSummary.disbursementDetails) &&
        Objects.equals(this.emiAmountVariations, getSelfLoanIdSummary.emiAmountVariations) &&
        Objects.equals(this.feeChargesCharged, getSelfLoanIdSummary.feeChargesCharged) &&
        Objects.equals(this.feeChargesDueAtDisbursementCharged, getSelfLoanIdSummary.feeChargesDueAtDisbursementCharged) &&
        Objects.equals(this.feeChargesOutstanding, getSelfLoanIdSummary.feeChargesOutstanding) &&
        Objects.equals(this.feeChargesOverdue, getSelfLoanIdSummary.feeChargesOverdue) &&
        Objects.equals(this.feeChargesPaid, getSelfLoanIdSummary.feeChargesPaid) &&
        Objects.equals(this.feeChargesWaived, getSelfLoanIdSummary.feeChargesWaived) &&
        Objects.equals(this.feeChargesWrittenOff, getSelfLoanIdSummary.feeChargesWrittenOff) &&
        Objects.equals(this.fixedEmiAmount, getSelfLoanIdSummary.fixedEmiAmount) &&
        Objects.equals(this.inArrears, getSelfLoanIdSummary.inArrears) &&
        Objects.equals(this.interestCharged, getSelfLoanIdSummary.interestCharged) &&
        Objects.equals(this.interestOutstanding, getSelfLoanIdSummary.interestOutstanding) &&
        Objects.equals(this.interestOverdue, getSelfLoanIdSummary.interestOverdue) &&
        Objects.equals(this.interestPaid, getSelfLoanIdSummary.interestPaid) &&
        Objects.equals(this.interestWaived, getSelfLoanIdSummary.interestWaived) &&
        Objects.equals(this.interestWrittenOff, getSelfLoanIdSummary.interestWrittenOff) &&
        Objects.equals(this.isNPA, getSelfLoanIdSummary.isNPA) &&
        Objects.equals(this.linkedAccount, getSelfLoanIdSummary.linkedAccount) &&
        Objects.equals(this.maxOutstandingLoanBalance, getSelfLoanIdSummary.maxOutstandingLoanBalance) &&
        Objects.equals(this.overdueCharges, getSelfLoanIdSummary.overdueCharges) &&
        Objects.equals(this.overdueSinceDate, getSelfLoanIdSummary.overdueSinceDate) &&
        Objects.equals(this.penaltyChargesCharged, getSelfLoanIdSummary.penaltyChargesCharged) &&
        Objects.equals(this.penaltyChargesOutstanding, getSelfLoanIdSummary.penaltyChargesOutstanding) &&
        Objects.equals(this.penaltyChargesOverdue, getSelfLoanIdSummary.penaltyChargesOverdue) &&
        Objects.equals(this.penaltyChargesPaid, getSelfLoanIdSummary.penaltyChargesPaid) &&
        Objects.equals(this.penaltyChargesWaived, getSelfLoanIdSummary.penaltyChargesWaived) &&
        Objects.equals(this.penaltyChargesWrittenOff, getSelfLoanIdSummary.penaltyChargesWrittenOff) &&
        Objects.equals(this.principalAdjustments, getSelfLoanIdSummary.principalAdjustments) &&
        Objects.equals(this.principalDisbursed, getSelfLoanIdSummary.principalDisbursed) &&
        Objects.equals(this.principalOutstanding, getSelfLoanIdSummary.principalOutstanding) &&
        Objects.equals(this.principalOverdue, getSelfLoanIdSummary.principalOverdue) &&
        Objects.equals(this.principalPaid, getSelfLoanIdSummary.principalPaid) &&
        Objects.equals(this.principalWrittenOff, getSelfLoanIdSummary.principalWrittenOff) &&
        Objects.equals(this.totalChargeAdjustment, getSelfLoanIdSummary.totalChargeAdjustment) &&
        Objects.equals(this.totalChargeAdjustmentReversed, getSelfLoanIdSummary.totalChargeAdjustmentReversed) &&
        Objects.equals(this.totalChargeback, getSelfLoanIdSummary.totalChargeback) &&
        Objects.equals(this.totalCostOfLoan, getSelfLoanIdSummary.totalCostOfLoan) &&
        Objects.equals(this.totalCreditBalanceRefund, getSelfLoanIdSummary.totalCreditBalanceRefund) &&
        Objects.equals(this.totalCreditBalanceRefundReversed, getSelfLoanIdSummary.totalCreditBalanceRefundReversed) &&
        Objects.equals(this.totalExpectedCostOfLoan, getSelfLoanIdSummary.totalExpectedCostOfLoan) &&
        Objects.equals(this.totalExpectedRepayment, getSelfLoanIdSummary.totalExpectedRepayment) &&
        Objects.equals(this.totalGoodwillCredit, getSelfLoanIdSummary.totalGoodwillCredit) &&
        Objects.equals(this.totalGoodwillCreditReversed, getSelfLoanIdSummary.totalGoodwillCreditReversed) &&
        Objects.equals(this.totalMerchantRefund, getSelfLoanIdSummary.totalMerchantRefund) &&
        Objects.equals(this.totalMerchantRefundReversed, getSelfLoanIdSummary.totalMerchantRefundReversed) &&
        Objects.equals(this.totalOutstanding, getSelfLoanIdSummary.totalOutstanding) &&
        Objects.equals(this.totalOverdue, getSelfLoanIdSummary.totalOverdue) &&
        Objects.equals(this.totalPayoutRefund, getSelfLoanIdSummary.totalPayoutRefund) &&
        Objects.equals(this.totalPayoutRefundReversed, getSelfLoanIdSummary.totalPayoutRefundReversed) &&
        Objects.equals(this.totalRepayment, getSelfLoanIdSummary.totalRepayment) &&
        Objects.equals(this.totalRepaymentTransaction, getSelfLoanIdSummary.totalRepaymentTransaction) &&
        Objects.equals(this.totalRepaymentTransactionReversed, getSelfLoanIdSummary.totalRepaymentTransactionReversed) &&
        Objects.equals(this.totalWaived, getSelfLoanIdSummary.totalWaived) &&
        Objects.equals(this.totalWrittenOff, getSelfLoanIdSummary.totalWrittenOff);
  }

  @Override
  public int hashCode() {
    return Objects.hash(canDisburse, currency, disbursementDetails, emiAmountVariations, feeChargesCharged, feeChargesDueAtDisbursementCharged, feeChargesOutstanding, feeChargesOverdue, feeChargesPaid, feeChargesWaived, feeChargesWrittenOff, fixedEmiAmount, inArrears, interestCharged, interestOutstanding, interestOverdue, interestPaid, interestWaived, interestWrittenOff, isNPA, linkedAccount, maxOutstandingLoanBalance, overdueCharges, overdueSinceDate, penaltyChargesCharged, penaltyChargesOutstanding, penaltyChargesOverdue, penaltyChargesPaid, penaltyChargesWaived, penaltyChargesWrittenOff, principalAdjustments, principalDisbursed, principalOutstanding, principalOverdue, principalPaid, principalWrittenOff, totalChargeAdjustment, totalChargeAdjustmentReversed, totalChargeback, totalCostOfLoan, totalCreditBalanceRefund, totalCreditBalanceRefundReversed, totalExpectedCostOfLoan, totalExpectedRepayment, totalGoodwillCredit, totalGoodwillCreditReversed, totalMerchantRefund, totalMerchantRefundReversed, totalOutstanding, totalOverdue, totalPayoutRefund, totalPayoutRefundReversed, totalRepayment, totalRepaymentTransaction, totalRepaymentTransactionReversed, totalWaived, totalWrittenOff);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetSelfLoanIdSummary {\n");
    sb.append("    canDisburse: ").append(toIndentedString(canDisburse)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    disbursementDetails: ").append(toIndentedString(disbursementDetails)).append("\n");
    sb.append("    emiAmountVariations: ").append(toIndentedString(emiAmountVariations)).append("\n");
    sb.append("    feeChargesCharged: ").append(toIndentedString(feeChargesCharged)).append("\n");
    sb.append("    feeChargesDueAtDisbursementCharged: ").append(toIndentedString(feeChargesDueAtDisbursementCharged)).append("\n");
    sb.append("    feeChargesOutstanding: ").append(toIndentedString(feeChargesOutstanding)).append("\n");
    sb.append("    feeChargesOverdue: ").append(toIndentedString(feeChargesOverdue)).append("\n");
    sb.append("    feeChargesPaid: ").append(toIndentedString(feeChargesPaid)).append("\n");
    sb.append("    feeChargesWaived: ").append(toIndentedString(feeChargesWaived)).append("\n");
    sb.append("    feeChargesWrittenOff: ").append(toIndentedString(feeChargesWrittenOff)).append("\n");
    sb.append("    fixedEmiAmount: ").append(toIndentedString(fixedEmiAmount)).append("\n");
    sb.append("    inArrears: ").append(toIndentedString(inArrears)).append("\n");
    sb.append("    interestCharged: ").append(toIndentedString(interestCharged)).append("\n");
    sb.append("    interestOutstanding: ").append(toIndentedString(interestOutstanding)).append("\n");
    sb.append("    interestOverdue: ").append(toIndentedString(interestOverdue)).append("\n");
    sb.append("    interestPaid: ").append(toIndentedString(interestPaid)).append("\n");
    sb.append("    interestWaived: ").append(toIndentedString(interestWaived)).append("\n");
    sb.append("    interestWrittenOff: ").append(toIndentedString(interestWrittenOff)).append("\n");
    sb.append("    isNPA: ").append(toIndentedString(isNPA)).append("\n");
    sb.append("    linkedAccount: ").append(toIndentedString(linkedAccount)).append("\n");
    sb.append("    maxOutstandingLoanBalance: ").append(toIndentedString(maxOutstandingLoanBalance)).append("\n");
    sb.append("    overdueCharges: ").append(toIndentedString(overdueCharges)).append("\n");
    sb.append("    overdueSinceDate: ").append(toIndentedString(overdueSinceDate)).append("\n");
    sb.append("    penaltyChargesCharged: ").append(toIndentedString(penaltyChargesCharged)).append("\n");
    sb.append("    penaltyChargesOutstanding: ").append(toIndentedString(penaltyChargesOutstanding)).append("\n");
    sb.append("    penaltyChargesOverdue: ").append(toIndentedString(penaltyChargesOverdue)).append("\n");
    sb.append("    penaltyChargesPaid: ").append(toIndentedString(penaltyChargesPaid)).append("\n");
    sb.append("    penaltyChargesWaived: ").append(toIndentedString(penaltyChargesWaived)).append("\n");
    sb.append("    penaltyChargesWrittenOff: ").append(toIndentedString(penaltyChargesWrittenOff)).append("\n");
    sb.append("    principalAdjustments: ").append(toIndentedString(principalAdjustments)).append("\n");
    sb.append("    principalDisbursed: ").append(toIndentedString(principalDisbursed)).append("\n");
    sb.append("    principalOutstanding: ").append(toIndentedString(principalOutstanding)).append("\n");
    sb.append("    principalOverdue: ").append(toIndentedString(principalOverdue)).append("\n");
    sb.append("    principalPaid: ").append(toIndentedString(principalPaid)).append("\n");
    sb.append("    principalWrittenOff: ").append(toIndentedString(principalWrittenOff)).append("\n");
    sb.append("    totalChargeAdjustment: ").append(toIndentedString(totalChargeAdjustment)).append("\n");
    sb.append("    totalChargeAdjustmentReversed: ").append(toIndentedString(totalChargeAdjustmentReversed)).append("\n");
    sb.append("    totalChargeback: ").append(toIndentedString(totalChargeback)).append("\n");
    sb.append("    totalCostOfLoan: ").append(toIndentedString(totalCostOfLoan)).append("\n");
    sb.append("    totalCreditBalanceRefund: ").append(toIndentedString(totalCreditBalanceRefund)).append("\n");
    sb.append("    totalCreditBalanceRefundReversed: ").append(toIndentedString(totalCreditBalanceRefundReversed)).append("\n");
    sb.append("    totalExpectedCostOfLoan: ").append(toIndentedString(totalExpectedCostOfLoan)).append("\n");
    sb.append("    totalExpectedRepayment: ").append(toIndentedString(totalExpectedRepayment)).append("\n");
    sb.append("    totalGoodwillCredit: ").append(toIndentedString(totalGoodwillCredit)).append("\n");
    sb.append("    totalGoodwillCreditReversed: ").append(toIndentedString(totalGoodwillCreditReversed)).append("\n");
    sb.append("    totalMerchantRefund: ").append(toIndentedString(totalMerchantRefund)).append("\n");
    sb.append("    totalMerchantRefundReversed: ").append(toIndentedString(totalMerchantRefundReversed)).append("\n");
    sb.append("    totalOutstanding: ").append(toIndentedString(totalOutstanding)).append("\n");
    sb.append("    totalOverdue: ").append(toIndentedString(totalOverdue)).append("\n");
    sb.append("    totalPayoutRefund: ").append(toIndentedString(totalPayoutRefund)).append("\n");
    sb.append("    totalPayoutRefundReversed: ").append(toIndentedString(totalPayoutRefundReversed)).append("\n");
    sb.append("    totalRepayment: ").append(toIndentedString(totalRepayment)).append("\n");
    sb.append("    totalRepaymentTransaction: ").append(toIndentedString(totalRepaymentTransaction)).append("\n");
    sb.append("    totalRepaymentTransactionReversed: ").append(toIndentedString(totalRepaymentTransactionReversed)).append("\n");
    sb.append("    totalWaived: ").append(toIndentedString(totalWaived)).append("\n");
    sb.append("    totalWrittenOff: ").append(toIndentedString(totalWrittenOff)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

