package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CacheData;
import org.apache.fineract.client.models.CacheSwitchRequest;
import org.apache.fineract.client.models.CacheSwitchResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CacheApi {
    /**
    * Retrieve Cache Types
    * Returns the list of caches.  Example Requests:  caches 
    * @return Call&lt;List&lt;CacheData&gt;&gt;
    */
    @GET("v1/caches")
    Call<List<CacheData>> retrieveAll4();

    /**
    * Switch Cache
    * Switches the cache to chosen one.
        * @param cacheSwitchRequest  (optional)
    * @return Call&lt;CacheSwitchResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/caches")
    Call<CacheSwitchResponse> switchCache(@retrofit2.http.Body CacheSwitchRequest cacheSwitchRequest);


        /**
        * Switch Cache
        * Switches the cache to chosen one.
            * @param cacheSwitchRequest  (optional)
        * @return Call&lt;CacheSwitchResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/caches")
    Call<CacheSwitchResponse> switchCache();

        /**
        * Retrieve Cache Types
        * Returns the list of caches.  Example Requests:  caches 
        * @return Call&lt;List&lt;CacheData&gt;&gt;
        */
    @GET("v1/caches")
    Call<List<CacheData>> retrieveAll4(@HeaderMap Map<String, String> headers);

        /**
        * Switch Cache
        * Switches the cache to chosen one.
            * @param cacheSwitchRequest  (optional)
        * @return Call&lt;CacheSwitchResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/caches")
    Call<CacheSwitchResponse> switchCache(@retrofit2.http.Body CacheSwitchRequest cacheSwitchRequest, @HeaderMap Map<String, String> headers);


        /**
        * Switch Cache
        * Switches the cache to chosen one.
            * @param cacheSwitchRequest  (optional)
        * @return Call&lt;CacheSwitchResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/caches")
    Call<CacheSwitchResponse> switchCache(@HeaderMap Map<String, String> headers);
}
