/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ProcessorKeeper21;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.deadlock.MessageDependencyMonitor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.serialization.DSFIDNotFoundException;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ReplyProcessor21
implements MembershipListener {
    private static final Logger logger;
    public static final boolean THROW_EXCEPTION_ON_TIMEOUT;
    public static final double PR_SEVERE_ALERT_RATIO;
    @MakeNotStatic
    protected static final ProcessorKeeper21 keeper;
    protected final InternalDistributedMember[] members;
    protected volatile boolean waiting = false;
    protected volatile ReplyException exception;
    private volatile boolean done;
    private boolean keeperCleanedUp;
    protected volatile boolean shutdown;
    private final StoppableCountDownLatch latch;
    protected int processorId;
    protected final InternalDistributedSystem system;
    protected final DistributionManager dmgr;
    long statStart;
    private final long initTime;
    private boolean severeAlertEnabled;
    private volatile boolean severeAlertTimerReset;
    private static final ThreadLocal<Boolean> severeAlertShorten;
    private static final ThreadLocal<Boolean> forceSevereAlertProcessing;
    private static final ThreadLocal<Integer> messageId;
    private static final Integer VOID_RPID;

    public static ReplyProcessor21 getProcessor(int processorId) {
        return (ReplyProcessor21)keeper.retrieve(processorId);
    }

    public ReplyProcessor21(InternalDistributedSystem system, InternalDistributedMember member) {
        this(system, Collections.singleton(member));
    }

    public ReplyProcessor21(InternalDistributedSystem system, InternalDistributedMember member, CancelCriterion cancelCriterion) {
        this(system, Collections.singleton(member), cancelCriterion);
    }

    public ReplyProcessor21(DistributionManager dm, InternalDistributedMember member) {
        this(dm, Collections.singleton(member));
    }

    public ReplyProcessor21(DistributionManager dm, Collection initMembers) {
        this(dm, initMembers, null);
    }

    public ReplyProcessor21(DistributionManager dm, Collection initMembers, CancelCriterion cancelCriterion) {
        this(dm, dm.getSystem(), initMembers, cancelCriterion);
    }

    public ReplyProcessor21(InternalDistributedSystem system, Collection initMembers) {
        this(system.getDistributionManager(), system, initMembers, null);
    }

    public ReplyProcessor21(InternalDistributedSystem system, Collection initMembers, CancelCriterion cancelCriterion) {
        this(system.getDistributionManager(), system, initMembers, cancelCriterion);
    }

    private ReplyProcessor21(DistributionManager dm, InternalDistributedSystem system, Collection initMembers, CancelCriterion cancelCriterion) {
        this(dm, system, initMembers, cancelCriterion, true);
    }

    protected ReplyProcessor21(DistributionManager dm, InternalDistributedSystem system, Collection initMembers, CancelCriterion cancelCriterion, boolean register) {
        if (!this.allowReplyFromSender()) {
            Assert.assertTrue(initMembers != null, "null initMembers");
            Assert.assertTrue(system != null, "null system");
            if (dm != null) {
                Assert.assertTrue(!initMembers.contains(dm.getId()), "dm present in initMembers but reply from sender is not allowed");
            }
        }
        this.system = system;
        this.dmgr = dm;
        if (cancelCriterion == null) {
            cancelCriterion = dm.getCancelCriterion();
        }
        this.latch = new StoppableCountDownLatch(cancelCriterion, 1);
        int sz = initMembers.size();
        this.members = new InternalDistributedMember[sz];
        if (sz > 0) {
            int i = 0;
            Iterator it = initMembers.iterator();
            while (it.hasNext()) {
                this.members[i] = (InternalDistributedMember)it.next();
                ++i;
            }
        }
        this.done = false;
        this.shutdown = false;
        this.exception = null;
        if (register) {
            this.register();
        }
        this.keeperCleanedUp = false;
        this.initTime = System.currentTimeMillis();
    }

    protected int register() {
        this.processorId = keeper.put(this);
        return this.processorId;
    }

    public DistributionManager getDistributionManager() {
        try {
            DistributionManager result = this.system.getDistributionManager();
            if (result == null) {
                result = this.dmgr;
                Assert.assertTrue(result != null, "null DistributionManager");
            }
            return result;
        }
        catch (IllegalStateException ex) {
            this.system.getCancelCriterion().checkCancelInProgress(null);
            throw new DistributedSystemDisconnectedException(ex.getMessage());
        }
    }

    protected boolean allowReplyFromSender() {
        return false;
    }

    protected boolean logMultipleExceptions() {
        return true;
    }

    public void process(DistributionMessage msg) {
        this.process(msg, true);
    }

    protected void process(DistributionMessage msg, boolean warn) {
        InternalDistributedMember sender;
        ReplyException ex;
        if (logger.isDebugEnabled()) {
            logger.debug("{} got process({}) from {}", (Object)this, (Object)msg, (Object)msg.getSender());
        }
        if (msg instanceof ReplyMessage && (ex = ((ReplyMessage)msg).getException()) != null) {
            if (ex.getCause() instanceof DSFIDNotFoundException) {
                this.processException(msg, (DSFIDNotFoundException)ex.getCause());
            } else {
                this.processException(msg, ex);
            }
        }
        if (!this.removeMember(sender = msg.getSender(), false) && warn) {
            DistributionManager dm = this.getDistributionManager();
            Set ids = this.getDistributionManagerIds();
            if (ids == null || ids.contains(sender)) {
                List<InternalDistributedMember> viewMembers = dm.getViewMembers();
                if (this.system.getConfig().getMcastPort() == 0 && (viewMembers == null || viewMembers.contains(sender))) {
                    logger.warn("Received reply from member {} but was not expecting one. More than one reply may have been received. The reply that was not expected is: {}", new Object[]{sender, msg});
                }
            }
        }
        this.checkIfDone();
    }

    protected synchronized void processException(DistributionMessage msg, ReplyException ex) {
        this.processException(ex);
    }

    protected synchronized void processException(ReplyException ex) {
        if (this.exception == null) {
            this.exception = ex;
        } else if (this.logMultipleExceptions() && !(ex.getCause() instanceof ConcurrentCacheModificationException)) {
            logger.fatal("Exception received in ReplyMessage. Only one exception is passed back to caller. This exception is logged only.", (Throwable)ex);
        }
    }

    protected synchronized void processException(DistributionMessage msg, DSFIDNotFoundException ex) {
        short versionOrdinal = ex.getProductVersionOrdinal();
        Version anyVersion = Versioning.getVersion((short)versionOrdinal);
        logger.fatal(String.format("Exception received due to missing DSFID %s on remote node %s running version %s.", ex.getUnknownDSFID(), msg.getSender(), anyVersion), (Throwable)ex);
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        if (!this.isSevereAlertProcessingEnabled()) return;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            int cells = this.members.length;
            for (InternalDistributedMember e : this.members) {
                if (e == null || !e.equals(whoSuspected)) continue;
                this.severeAlertTimerReset = true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        this.removeMember(id, true);
        this.checkIfDone();
    }

    public void waitForReplies() throws InterruptedException, ReplyException {
        boolean result = this.waitForReplies(0L);
        Assert.assertTrue(result, "failed but no exception thrown");
    }

    protected Set addListenerAndGetMembers() {
        return this.getDistributionManager().addMembershipListenerAndGetDistributionManagerIds(this);
    }

    protected void removeListener() {
        try {
            this.getDistributionManager().removeMembershipListener(this);
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    protected Set getDistributionManagerIds() {
        return this.getDistributionManager().getDistributionManagerIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preWait() {
        this.waiting = true;
        DistributionManager mgr = this.getDistributionManager();
        this.statStart = mgr.getStats().startReplyWait();
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            Set activeMembers = this.addListenerAndGetMembers();
            this.processActiveMembers(activeMembers);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void processActiveMembers(Set activeMembers) {
        for (InternalDistributedMember member : this.members) {
            if (member == null || activeMembers.contains(member)) continue;
            this.memberDeparted(this.getDistributionManager(), member, false);
        }
    }

    private void postWait() {
        this.waiting = false;
        this.removeListener();
        DistributionManager mgr = this.getDistributionManager();
        mgr.getStats().endReplyWait(this.statStart, this.initTime);
        mgr.getCancelCriterion().checkCancelInProgress(null);
    }

    public boolean waitForReplies(long msecs) throws InterruptedException, ReplyException {
        return this.waitForReplies(msecs, this.getLatch(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForReplies(long msecs, StoppableCountDownLatch latch, boolean doCleanUp) throws InterruptedException, ReplyException {
        if (this.keeperCleanedUp) {
            throw new IllegalStateException("This reply processor has already been removed from the processor keeper");
        }
        boolean result = true;
        boolean interrupted = Thread.interrupted();
        MessageDependencyMonitor.waitingForReply(this);
        try {
            if (interrupted) {
                throw new InterruptedException();
            }
            if (this.stillWaiting()) {
                this.preWait();
                try {
                    result = this.basicWait(msecs, latch);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    if (doCleanUp) {
                        this.postWait();
                    }
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        finally {
            if (doCleanUp) {
                try {
                    this.cleanup();
                }
                finally {
                    if (interrupted) {
                        throw new InterruptedException();
                    }
                }
            }
            MessageDependencyMonitor.doneWaiting(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean basicWait(long msecs, StoppableCountDownLatch latch) throws InterruptedException, ReplyException {
        block13: {
            block16: {
                boolean wasNotUnlatched;
                long severeAlertTimeout;
                block15: {
                    boolean doSuspectProcessing;
                    long timeout;
                    block14: {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (!this.stillWaiting()) break block13;
                        timeout = (long)this.getAckWaitThreshold() * 1000L;
                        long timeSoFar = System.currentTimeMillis() - this.initTime;
                        severeAlertTimeout = this.getAckSevereAlertThresholdMS();
                        boolean bl = doSuspectProcessing = this.isSevereAlertProcessingEnabled() && severeAlertTimeout > 0L;
                        if (timeout <= 0L) {
                            timeout = Long.MAX_VALUE;
                        }
                        if (msecs != 0L) break block14;
                        boolean timedOut = false;
                        if (timeout <= timeSoFar + 1L) {
                            boolean bl2 = timedOut = !latch.await(10L);
                        }
                        if (!timedOut && latch.await(timeout - timeSoFar - 1L)) break block13;
                        this.dmgr.getCancelCriterion().checkCancelInProgress(null);
                        this.timeout(doSuspectProcessing, false);
                        if (doSuspectProcessing) break block15;
                        latch.await();
                        break block16;
                    }
                    if (msecs > timeout) {
                        if (!latch.await(timeout)) {
                            this.timeout(doSuspectProcessing, false);
                            if (!latch.await(msecs - timeout)) {
                                logger.info("wait for replies timing out after {} seconds", (Object)(msecs / 1000L));
                                return false;
                            }
                            logger.info("{} wait for replies completed", (Object)this.shortName());
                        }
                        break block13;
                    } else if (!latch.await(msecs)) {
                        return false;
                    }
                    break block13;
                }
                do {
                    this.severeAlertTimerReset = false;
                    boolean bl = wasNotUnlatched = !latch.await(severeAlertTimeout);
                } while (wasNotUnlatched && this.severeAlertTimerReset);
                if (wasNotUnlatched) {
                    this.dmgr.getCancelCriterion().checkCancelInProgress(null);
                    this.timeout(false, true);
                    long suspectProcessingErrorAlertTimeout = severeAlertTimeout * 3L;
                    if (!latch.await(suspectProcessingErrorAlertTimeout)) {
                        long now = System.currentTimeMillis();
                        long totalTimeElapsed = now - this.initTime;
                        InternalDistributedMember[] internalDistributedMemberArray = this.members;
                        // MONITORENTER : this.members
                        String waitingOnMembers = Arrays.toString(this.members);
                        // MONITOREXIT : internalDistributedMemberArray
                        logger.fatal("An additional " + suspectProcessingErrorAlertTimeout + " milliseconds have elapsed while waiting for replies. Total of " + totalTimeElapsed + " milliseconds elapsed (init time:" + this.initTime + ", now: " + now + ") Waiting for members: " + waitingOnMembers);
                        latch.await();
                    }
                }
            }
            logger.info("{} wait for replies completed", (Object)this.shortName());
        }
        Assert.assertTrue(latch != this.latch || !this.stillWaiting(), this);
        if (!this.stopBecauseOfExceptions()) return true;
        throw this.exception;
    }

    public boolean waitForRepliesUninterruptibly(long p_msecs) throws ReplyException {
        return this.waitForRepliesUninterruptibly(p_msecs, this.getLatch(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRepliesUninterruptibly(long p_msecs, StoppableCountDownLatch latch, boolean doCleanUp) throws ReplyException {
        if (this.keeperCleanedUp) {
            throw new IllegalStateException("This reply processor has already been removed from the processor keeper");
        }
        long msecs = p_msecs;
        boolean result = true;
        MessageDependencyMonitor.waitingForReply(this);
        try {
            if (this.stillWaiting()) {
                this.preWait();
                try {
                    while (true) {
                        this.dmgr.getCancelCriterion().checkCancelInProgress(null);
                        long startWaitTime = System.currentTimeMillis();
                        boolean interrupted = Thread.interrupted();
                        try {
                            result = this.basicWait(msecs, latch);
                        }
                        catch (InterruptedException e) {
                            long interruptTime;
                            interrupted = true;
                            this.dmgr.getCancelCriterion().checkCancelInProgress(e);
                            if (msecs <= 0L || (msecs -= (interruptTime = System.currentTimeMillis()) - startWaitTime) > 0L) continue;
                            msecs = 1L;
                            result = false;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (doCleanUp) {
                        this.postWait();
                    }
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        finally {
            if (doCleanUp) {
                this.cleanup();
            }
            MessageDependencyMonitor.doneWaiting(this);
        }
        return result;
    }

    public void cleanup() {
        if (!this.keeperCleanedUp) {
            this.keeperCleanedUp = true;
            keeper.remove(this.getProcessorId());
        }
    }

    public void waitForRepliesUninterruptibly() throws ReplyException {
        this.waitForRepliesUninterruptibly(0L);
    }

    public int getProcessorId() {
        return this.processorId;
    }

    protected boolean canStopWaiting() {
        return false;
    }

    protected boolean stillWaiting() {
        if (this.shutdown) {
            ReplyException re;
            this.exception = re = new ReplyException(new DistributedSystemDisconnectedException("aborted due to shutdown"));
            return false;
        }
        if (this.canStopWaiting()) {
            return false;
        }
        if (this.stopBecauseOfExceptions()) {
            return false;
        }
        return this.numMembers() > 0;
    }

    protected boolean stopBecauseOfExceptions() {
        return this.exception != null;
    }

    protected void checkIfDone() {
        boolean finished;
        boolean bl = finished = !this.stillWaiting();
        if (finished) {
            this.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished() {
        boolean isDone = false;
        ReplyProcessor21 replyProcessor21 = this;
        synchronized (replyProcessor21) {
            if (!this.done) {
                this.done = true;
                isDone = true;
                this.getLatch().countDown();
            }
        }
        if (isDone) {
            this.postFinish();
        }
    }

    protected void postFinish() {
    }

    protected String shortName() {
        String base = this.getClass().getName();
        int dot = base.lastIndexOf(46);
        if (dot == -1) {
            return base;
        }
        return base.substring(dot + 1);
    }

    public String toString() {
        return "<" + this.shortName() + " " + this.getProcessorId() + " waiting for " + this.numMembers() + " replies" + (this.exception == null ? "" : " exception: " + this.exception) + " from " + this.membersToString() + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeMember(InternalDistributedMember m, boolean departed) {
        boolean removed = false;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            for (InternalDistributedMember e : this.members) {
                if (e == null || !e.equals(m)) continue;
                this.members[i] = null;
                if (!departed) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return true;
                }
                removed = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numMembers() {
        int sz = 0;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            int cells = this.members.length;
            for (InternalDistributedMember member : this.members) {
                if (member == null) continue;
                ++sz;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitingOnMember(InternalDistributedMember id) {
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            int cells = this.members.length;
            for (InternalDistributedMember member : this.members) {
                if (!id.equals(member)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    protected int getAckWaitThreshold() {
        return this.system.getConfig().getAckWaitThreshold();
    }

    protected int getSevereAlertThreshold() {
        return this.system.getConfig().getAckSevereAlertThreshold();
    }

    protected boolean processTimeout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout(boolean suspectThem, boolean severeAlert) {
        if (!this.processTimeout()) {
            return;
        }
        Set activeMembers = this.getDistributionManagerIds();
        long timeout = this.getAckWaitThreshold();
        Object[] msgArgs = new Object[]{timeout + (long)(severeAlert ? this.getSevereAlertThreshold() : 0), this, this.getDistributionManager().getId(), activeMembers};
        String msg = "%s seconds have elapsed while waiting for replies: %s on %s whose current membership list is: [%s]";
        if (severeAlert) {
            logger.fatal(String.format("%s seconds have elapsed while waiting for replies: %s on %s whose current membership list is: [%s]", msgArgs));
        } else {
            logger.warn(String.format("%s seconds have elapsed while waiting for replies: %s on %s whose current membership list is: [%s]", msgArgs));
        }
        msgArgs[3] = "(omitted)";
        Breadcrumbs.setProblem("%s seconds have elapsed while waiting for replies: %s on %s whose current membership list is: [%s]", msgArgs);
        this.getDistributionManager().getStats().incReplyTimeouts();
        HashSet<InternalDistributedMember> suspectMembers = suspectThem || severeAlert ? new HashSet<InternalDistributedMember>() : null;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            for (InternalDistributedMember member : this.members) {
                if (member == null) continue;
                if (!activeMembers.contains(member)) {
                    logger.warn("View no longer has {} as an active member, so we will no longer wait for it.", (Object)member);
                    this.memberDeparted(this.getDistributionManager(), member, false);
                    continue;
                }
                if (suspectMembers == null) continue;
                suspectMembers.add(member);
            }
            // ** MonitorExit[var9_8] (shouldn't be in output)
            if (THROW_EXCEPTION_ON_TIMEOUT) {
                TimeoutException cause = new TimeoutException("Timed out waiting for ACKS.");
                throw new InternalGemFireException(String.format("%s seconds have elapsed while waiting for replies: %s on %s whose current membership list is: [%s]", msgArgs), cause);
            }
            if (suspectThem && suspectMembers != null && suspectMembers.size() > 0) {
                this.getDistributionManager().getDistribution().suspectMembers(suspectMembers, "Failed to respond within ack-wait-threshold");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String membersToString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            for (InternalDistributedMember member : this.members) {
                if (member == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(member);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            sb.append("]");
            return sb.toString();
        }
    }

    protected InternalDistributedMember[] getMembers() {
        return this.members;
    }

    private StoppableCountDownLatch getLatch() {
        return this.latch;
    }

    public void enableSevereAlertProcessing() {
        this.severeAlertEnabled = true;
    }

    public static void setShortSevereAlertProcessing(boolean flag) {
        severeAlertShorten.set(flag);
    }

    public static boolean getShortSevereAlertProcessing() {
        return severeAlertShorten.get();
    }

    public static void forceSevereAlertProcessing() {
        forceSevereAlertProcessing.set(Boolean.TRUE);
    }

    public static void unforceSevereAlertProcessing() {
        forceSevereAlertProcessing.set(Boolean.FALSE);
    }

    public static boolean isSevereAlertProcessingForced() {
        return forceSevereAlertProcessing.get();
    }

    public long getAckSevereAlertThresholdMS() {
        long disconnectTimeout = (long)this.getSevereAlertThreshold() * 1000L;
        if (disconnectTimeout > 0L && severeAlertShorten.get().booleanValue()) {
            disconnectTimeout = (long)((double)disconnectTimeout * PR_SEVERE_ALERT_RATIO);
        }
        return disconnectTimeout;
    }

    public boolean isSevereAlertProcessingEnabled() {
        return this.severeAlertEnabled || ReplyProcessor21.isSevereAlertProcessingForced();
    }

    public static void setMessageRPId(int id) {
        messageId.set(id);
    }

    public static void initMessageRPId() {
        messageId.set(VOID_RPID);
    }

    public static void clearMessageRPId() {
        messageId.set(VOID_RPID);
    }

    public static int getMessageRPId() {
        int result = 0;
        Integer v = messageId.get();
        if (v != null) {
            result = v;
        }
        return result;
    }

    public void cancel(InternalDistributedMember sender, RuntimeException ex) {
        this.processException(new ReplyException("Unexpected exception while processing reply message", ex));
        this.removeMember(sender, false);
        this.checkIfDone();
    }

    static {
        double ratio;
        logger = LogService.getLogger();
        THROW_EXCEPTION_ON_TIMEOUT = Boolean.getBoolean("ack-threshold-exception");
        keeper = new ProcessorKeeper21();
        severeAlertShorten = ThreadLocal.withInitial(() -> Boolean.FALSE);
        forceSevereAlertProcessing = ThreadLocal.withInitial(() -> Boolean.FALSE);
        String str = System.getProperty("gemfire.ack-severe-alert-reduction-ratio", ".80");
        try {
            ratio = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            System.err.println("Unable to parse gemfire.ack-severe-alert-reduction-ratio setting of \"" + str + "\"");
            ratio = 0.8;
        }
        PR_SEVERE_ALERT_RATIO = ratio;
        messageId = new ThreadLocal();
        VOID_RPID = 0;
    }
}

