/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.MemoryThresholdInfo;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DefaultResultCollector;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;

public class DistributedRegionFunctionExecutor
extends AbstractExecution {
    private final LocalRegion region;
    private ServerToClientFunctionResultSender sender;

    public DistributedRegionFunctionExecutor(Region r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "region"));
        }
        this.region = (LocalRegion)r;
    }

    private DistributedRegionFunctionExecutor(DistributedRegionFunctionExecutor drfe) {
        super(drfe);
        this.region = drfe.region;
        if (drfe.filter != null) {
            this.filter.clear();
            this.filter.addAll(drfe.filter);
        }
        this.sender = drfe.sender;
    }

    public DistributedRegionFunctionExecutor(DistributedRegion region, Set filter2, Object args, MemberMappedArgument memberMappedArg, ServerToClientFunctionResultSender resultSender) {
        if (args != null) {
            this.args = args;
        } else if (memberMappedArg != null) {
            this.memberMappedArg = memberMappedArg;
            this.isMemberMappedArgument = true;
        }
        this.sender = resultSender;
        if (filter2 != null) {
            this.filter.clear();
            this.filter.addAll(filter2);
        }
        this.region = region;
        this.isClientServerMode = true;
    }

    private DistributedRegionFunctionExecutor(DistributedRegionFunctionExecutor distributedRegionFunctionExecutor, MemberMappedArgument argument) {
        super(distributedRegionFunctionExecutor);
        this.region = distributedRegionFunctionExecutor.getRegion();
        this.filter.clear();
        this.filter.addAll(distributedRegionFunctionExecutor.filter);
        this.sender = distributedRegionFunctionExecutor.getServerResultSender();
        this.memberMappedArg = argument;
        this.isMemberMappedArgument = true;
    }

    private DistributedRegionFunctionExecutor(DistributedRegionFunctionExecutor distributedRegionFunctionExecutor, ResultCollector rs) {
        super(distributedRegionFunctionExecutor);
        this.region = distributedRegionFunctionExecutor.getRegion();
        this.filter.clear();
        this.filter.addAll(distributedRegionFunctionExecutor.filter);
        this.sender = distributedRegionFunctionExecutor.getServerResultSender();
        this.rc = rs;
    }

    private DistributedRegionFunctionExecutor(DistributedRegionFunctionExecutor distributedRegionFunctionExecutor, Object args) {
        super(distributedRegionFunctionExecutor);
        this.region = distributedRegionFunctionExecutor.getRegion();
        this.filter.clear();
        this.filter.addAll(distributedRegionFunctionExecutor.filter);
        this.sender = distributedRegionFunctionExecutor.getServerResultSender();
        this.args = args;
    }

    private DistributedRegionFunctionExecutor(DistributedRegionFunctionExecutor distributedRegionFunctionExecutor, Set filter2) {
        super(distributedRegionFunctionExecutor);
        this.region = distributedRegionFunctionExecutor.getRegion();
        this.sender = distributedRegionFunctionExecutor.getServerResultSender();
        this.filter.clear();
        this.filter.addAll(filter2);
    }

    private DistributedRegionFunctionExecutor(DistributedRegionFunctionExecutor drfe, boolean isReExecute) {
        super(drfe);
        this.region = drfe.region;
        if (drfe.filter != null) {
            this.filter.clear();
            this.filter.addAll(drfe.filter);
        }
        this.sender = drfe.sender;
        this.isReExecute = isReExecute;
    }

    @Override
    public ResultCollector execute(String functionName, long timeout, TimeUnit unit) {
        if (functionName == null) {
            throw new FunctionException("The input function for the execute function request is null");
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            throw new FunctionException(String.format("Function named %s is not registered to FunctionService", functionName));
        }
        if (this.region.getAttributes().getDataPolicy().isNormal()) {
            throw new FunctionException("Function execution on region with DataPolicy.NORMAL is not supported");
        }
        return this.executeFunction(functionObject, timeout, unit);
    }

    @Override
    public ResultCollector execute(String functionName) {
        return this.execute(functionName, (long)this.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ResultCollector execute(Function function, long timeout, TimeUnit unit) {
        if (function == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "function instance"));
        }
        if (function.isHA() && !function.hasResult()) {
            throw new FunctionException("For Functions with isHA true, hasResult must also be true.");
        }
        if (this.region.getAttributes().getDataPolicy().isNormal()) {
            throw new FunctionException("Function execution on region with DataPolicy.NORMAL is not supported");
        }
        String id = function.getId();
        if (id == null) {
            throw new FunctionException("The Function#getID() returned null");
        }
        this.isFnSerializationReqd = true;
        return this.executeFunction(function, timeout, unit);
    }

    @Override
    public ResultCollector execute(Function function) {
        return this.execute(function, (long)this.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected ResultCollector executeFunction(Function function, long timeout, TimeUnit unit) {
        if (!function.hasResult()) {
            this.region.executeFunction(this, function, this.args, null, this.filter, this.sender);
            return new NoResult();
        }
        ResultCollector inRc = this.rc == null ? new DefaultResultCollector() : this.rc;
        ResultCollector rcToReturn = this.region.executeFunction(this, function, this.args, inRc, this.filter, this.sender);
        if (timeout > 0L) {
            try {
                rcToReturn.getResult(timeout, unit);
            }
            catch (Exception exception) {
                throw new FunctionException(exception);
            }
        }
        return rcToReturn;
    }

    public Execution withFilter(Set filter) {
        if (filter == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "filter"));
        }
        return new DistributedRegionFunctionExecutor(this, filter);
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        if (bucketIDs != null && !bucketIDs.isEmpty()) {
            throw new IllegalArgumentException(String.format("Buckets as filter cannot be applied to a non partitioned region: %s", this.region.getName()));
        }
        return this;
    }

    public LocalRegion getRegion() {
        return this.region;
    }

    public ServerToClientFunctionResultSender getServerResultSender() {
        return this.sender;
    }

    public Execution setArguments(Object args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "Args"));
        }
        return new DistributedRegionFunctionExecutor(this, args);
    }

    public Execution withArgs(Object args) {
        return this.setArguments(args);
    }

    public Execution withCollector(ResultCollector rs) {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "Result Collector"));
        }
        return new DistributedRegionFunctionExecutor(this, rs);
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "MemberMappedArgument"));
        }
        return new DistributedRegionFunctionExecutor(this, argument);
    }

    @Override
    public AbstractExecution setIsReExecute() {
        return new DistributedRegionFunctionExecutor(this, true);
    }

    public String toString() {
        return "[DistributedRegionFunctionExecutor:args=" + this.args + ";region=" + this.region.getName() + "]";
    }

    public void validateExecution(Function function, Set targetMembers) {
        MemoryThresholdInfo info;
        InternalCache cache = this.region.getGemFireCache();
        if (cache != null && cache.getTxManager().getTXState() != null) {
            if (targetMembers.size() > 1) {
                throw new TransactionException("Function inside a transaction cannot execute on more than one node");
            }
            assert (targetMembers.size() == 1);
            DistributedMember funcTarget = (DistributedMember)targetMembers.iterator().next();
            DistributedMember target = cache.getTxManager().getTXState().getTarget();
            if (target == null) {
                cache.getTxManager().getTXState().setTarget(funcTarget);
            } else if (!target.equals(funcTarget)) {
                throw new TransactionDataNotColocatedException(String.format("Function execution is not colocated with transaction. The transactional data is hosted on node %s, but you are trying to target node %s", target, funcTarget));
            }
        }
        if (!MemoryThresholds.isLowMemoryExceptionDisabled() && function.optimizeForWrite() && (info = this.region.getAtomicThresholdInfo()).isMemoryThresholdReached()) {
            InternalResourceManager.getInternalResourceManager(this.region.getCache()).getHeapMonitor().updateStateAndSendEvent();
            Set<DistributedMember> criticalMembers = info.getMembersThatReachedThreshold();
            throw new LowMemoryException(String.format("Function: %s cannot be executed because the members %s are running low on memory", function.getId(), criticalMembers), criticalMembers);
        }
    }
}

