/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.geode.GemFireIOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.ByteBufferSharing;
import org.apache.geode.internal.net.ByteBufferVendor;
import org.apache.geode.internal.net.NioFilter;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class NioSslEngine
implements NioFilter {
    @Immutable
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final Logger logger = LogService.getLogger();
    private final BufferPool bufferPool;
    private boolean closed;
    SSLEngine engine;
    private final ByteBufferVendor outputBufferVendor;
    private final ByteBufferVendor inputBufferVendor;

    NioSslEngine(SSLEngine engine, BufferPool bufferPool) {
        SSLSession session = engine.getSession();
        int appBufferSize = session.getApplicationBufferSize();
        int packetBufferSize = engine.getSession().getPacketBufferSize();
        this.closed = false;
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.outputBufferVendor = new ByteBufferVendor(bufferPool.acquireDirectSenderBuffer(packetBufferSize), BufferPool.BufferType.TRACKED_SENDER, bufferPool);
        this.inputBufferVendor = new ByteBufferVendor(bufferPool.acquireNonDirectReceiveBuffer(appBufferSize), BufferPool.BufferType.TRACKED_RECEIVER, bufferPool);
    }

    /*
     * Unable to fully structure code
     */
    public boolean handshake(SocketChannel socketChannel, int timeout, ByteBuffer peerNetData) throws IOException {
        if (peerNetData.capacity() < this.engine.getSession().getPacketBufferSize()) {
            throw new IllegalArgumentException(String.format("Provided buffer is too small to perform SSL handshake.  Buffer capacity is %s but need %s", new Object[]{peerNetData.capacity(), this.engine.getSession().getPacketBufferSize()}));
        }
        handshakeBuffer = peerNetData;
        handshakeBuffer.clear();
        myAppData = ByteBuffer.wrap(new byte[0]);
        if (NioSslEngine.logger.isDebugEnabled()) {
            NioSslEngine.logger.debug("Starting TLS handshake with {}.  Timeout is {}ms", (Object)socketChannel.socket(), (Object)timeout);
        }
        timeoutNanos = -1L;
        if (timeout > 0) {
            timeoutNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        }
        this.engine.beginHandshake();
        status = this.engine.getHandshakeStatus();
        engineResult = null;
        while (status != SSLEngineResult.HandshakeStatus.FINISHED && status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (socketChannel.socket().isClosed()) {
                NioSslEngine.logger.info("Handshake terminated because socket is closed");
                throw new SocketException("handshake terminated - socket is closed");
            }
            if (timeoutNanos > 0L && timeoutNanos < System.nanoTime()) {
                NioSslEngine.logger.info("TLS handshake is timing out");
                throw new SocketTimeoutException("handshake timed out");
            }
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[status.ordinal()]) {
                case 1: {
                    inputSharing = this.inputBufferVendor.open();
                    var11_10 = null;
                    peerAppData = inputSharing.getBuffer();
                    dataRead = socketChannel.read(handshakeBuffer);
                    handshakeBuffer.flip();
                    engineResult = this.engine.unwrap(handshakeBuffer, peerAppData);
                    handshakeBuffer.compact();
                    status = engineResult.getHandshakeStatus();
                    if (peerAppData.remaining() == 0 && dataRead == 0 && status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        Thread.yield();
                    }
                    if (engineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        inputSharing.expandWriteBufferIfNeeded(peerAppData.capacity() * 2);
                    }
                    if (inputSharing == null) break;
                    if (var11_10 == null) ** GOTO lbl48
                    try {
                        inputSharing.close();
                    }
                    catch (Throwable var14_16) {
                        var11_10.addSuppressed(var14_16);
                    }
                    break;
lbl48:
                    // 1 sources

                    inputSharing.close();
                    break;
                    catch (Throwable peerAppData) {
                        try {
                            var11_10 = peerAppData;
                            throw peerAppData;
                        }
                        catch (Throwable var15_17) {
                            if (inputSharing != null) {
                                if (var11_10 != null) {
                                    try {
                                        inputSharing.close();
                                    }
                                    catch (Throwable var16_18) {
                                        var11_10.addSuppressed(var16_18);
                                    }
                                } else {
                                    inputSharing.close();
                                }
                            }
                            throw var15_17;
                        }
                    }
                }
                case 2: {
                    outputSharing = this.outputBufferVendor.open();
                    var11_10 = null;
                    myNetData = outputSharing.getBuffer();
                    myNetData.clear();
                    engineResult = this.engine.wrap(myAppData, myNetData);
                    status = engineResult.getHandshakeStatus();
                    switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[engineResult.getStatus().ordinal()]) {
                        case 1: {
                            outputSharing.expandWriteBufferIfNeeded(myNetData.capacity() * 2);
                            break;
                        }
                        case 2: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                socketChannel.write(myNetData);
                            }
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            NioSslEngine.logger.info("handshake terminated with illegal state due to {}", (Object)status);
                            throw new IllegalStateException("Unknown SSLEngineResult status: " + (Object)engineResult.getStatus());
                        }
                    }
                    if (outputSharing == null) break;
                    if (var11_10 == null) ** GOTO lbl100
                    try {
                        outputSharing.close();
                    }
                    catch (Throwable var13_15) {
                        var11_10.addSuppressed(var13_15);
                    }
                    break;
lbl100:
                    // 1 sources

                    outputSharing.close();
                    break;
                    catch (Throwable var12_13) {
                        try {
                            var11_10 = var12_13;
                            throw var12_13;
                        }
                        catch (Throwable var17_19) {
                            if (outputSharing != null) {
                                if (var11_10 != null) {
                                    try {
                                        outputSharing.close();
                                    }
                                    catch (Throwable var18_20) {
                                        var11_10.addSuppressed(var18_20);
                                    }
                                } else {
                                    outputSharing.close();
                                }
                            }
                            throw var17_19;
                        }
                    }
                }
                case 3: {
                    this.handleBlockingTasks();
                    status = this.engine.getHandshakeStatus();
                    break;
                }
                default: {
                    NioSslEngine.logger.info("handshake terminated with illegal state due to {}", (Object)status);
                    throw new IllegalStateException("Unknown SSL Handshake state: " + (Object)status);
                }
            }
            Thread.yield();
        }
        if (status != SSLEngineResult.HandshakeStatus.FINISHED) {
            NioSslEngine.logger.info("handshake terminated with exception due to {}", (Object)status);
            throw new SSLHandshakeException("SSL Handshake terminated with status " + (Object)status);
        }
        if (NioSslEngine.logger.isDebugEnabled()) {
            if (engineResult != null) {
                NioSslEngine.logger.debug("TLS handshake successful.  result={} and handshakeResult={}", (Object)engineResult.getStatus(), (Object)this.engine.getHandshakeStatus());
            } else {
                NioSslEngine.logger.debug("TLS handshake successful.  handshakeResult={}", (Object)this.engine.getHandshakeStatus());
            }
        }
        return true;
    }

    void handleBlockingTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
    }

    @Override
    public ByteBufferSharing wrap(ByteBuffer appData) throws IOException {
        try (ByteBufferSharing outputSharing = this.outputBufferVendor.open();){
            ByteBuffer myNetData = outputSharing.getBuffer();
            myNetData.clear();
            while (appData.hasRemaining()) {
                SSLEngineResult wrapResult = this.engine.wrap(appData, myNetData);
                switch (wrapResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        int newCapacity = myNetData.position() + this.engine.getSession().getPacketBufferSize();
                        myNetData = outputSharing.expandWriteBufferIfNeeded(newCapacity);
                        break;
                    }
                    case CLOSED: 
                    case BUFFER_UNDERFLOW: {
                        throw new SSLException("Error encrypting data: " + wrapResult);
                    }
                }
                if (wrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.handleBlockingTasks();
            }
            myNetData.flip();
            ByteBufferSharing byteBufferSharing = this.outputBufferVendor.open();
            return byteBufferSharing;
        }
    }

    @Override
    public ByteBufferSharing unwrap(ByteBuffer wrappedBuffer) throws IOException {
        try (ByteBufferSharing inputSharing = this.inputBufferVendor.open();){
            ByteBuffer peerAppData = inputSharing.getBuffer();
            peerAppData.limit(peerAppData.capacity());
            boolean stopDecryption = false;
            block17: while (wrappedBuffer.hasRemaining() && !stopDecryption) {
                SSLEngineResult unwrapResult = this.engine.unwrap(wrappedBuffer, peerAppData);
                switch (unwrapResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        int newCapacity = (peerAppData.capacity() - peerAppData.position()) * 2 + peerAppData.position();
                        newCapacity = Math.max(newCapacity, peerAppData.capacity() / 2 * 3);
                        peerAppData = inputSharing.expandWriteBufferIfNeeded(newCapacity);
                        peerAppData.limit(peerAppData.capacity());
                        continue block17;
                    }
                    case BUFFER_UNDERFLOW: {
                        wrappedBuffer.compact();
                        ByteBufferSharing byteBufferSharing = this.inputBufferVendor.open();
                        return byteBufferSharing;
                    }
                    case OK: {
                        continue block17;
                    }
                }
                if (peerAppData.position() <= 0) {
                    throw new SSLException("Error decrypting data: " + unwrapResult);
                }
                stopDecryption = true;
            }
            wrappedBuffer.clear();
            ByteBufferSharing byteBufferSharing = this.inputBufferVendor.open();
            return byteBufferSharing;
        }
    }

    @Override
    public ByteBuffer ensureWrappedCapacity(int amount, ByteBuffer wrappedBuffer, BufferPool.BufferType bufferType) {
        ByteBuffer buffer = wrappedBuffer;
        int requiredSize = this.engine.getSession().getPacketBufferSize();
        if (buffer == null) {
            buffer = this.bufferPool.acquireDirectBuffer(bufferType, requiredSize);
        } else if (buffer.capacity() < requiredSize) {
            buffer = this.bufferPool.expandWriteBufferIfNeeded(bufferType, buffer, requiredSize);
        }
        return buffer;
    }

    @Override
    public ByteBufferSharing readAtLeast(SocketChannel channel, int bytes, ByteBuffer wrappedBuffer) throws IOException {
        try (ByteBufferSharing inputSharing = this.inputBufferVendor.open();){
            ByteBuffer peerAppData = inputSharing.getBuffer();
            if (peerAppData.capacity() > bytes && peerAppData.capacity() - peerAppData.position() < bytes) {
                peerAppData.compact();
                peerAppData.flip();
            }
            while (peerAppData.remaining() < bytes) {
                wrappedBuffer.limit(wrappedBuffer.capacity());
                int amountRead = channel.read(wrappedBuffer);
                if (amountRead < 0) {
                    throw new EOFException();
                }
                if (amountRead <= 0) continue;
                wrappedBuffer.flip();
                peerAppData.compact();
                ByteBufferSharing inputSharing2 = this.unwrap(wrappedBuffer);
                Throwable throwable = null;
                try {
                    ByteBuffer peerAppDataNew = inputSharing2.getBuffer();
                    peerAppDataNew.flip();
                    peerAppData = peerAppDataNew;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputSharing2 == null) continue;
                    if (throwable != null) {
                        try {
                            inputSharing2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputSharing2.close();
                }
            }
            ByteBufferSharing byteBufferSharing = this.inputBufferVendor.open();
            return byteBufferSharing;
        }
    }

    @Override
    public ByteBufferSharing getUnwrappedBuffer() throws IOException {
        return this.inputBufferVendor.open();
    }

    @Override
    public void doneReadingDirectAck(ByteBuffer unwrappedBuffer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(SocketChannel socketChannel) {
        assert (socketChannel.isBlocking());
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.inputBufferVendor.destruct();
        try (ByteBufferSharing outputSharing2 = this.outputBufferVendor.open(1L, TimeUnit.MINUTES);){
            ByteBuffer myNetData = outputSharing2.getBuffer();
            this.engine.closeOutbound();
            SSLEngineResult result = null;
            while (!this.engine.isOutboundDone()) {
                myNetData.clear();
                result = this.engine.wrap(EMPTY_BYTE_BUFFER, myNetData);
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) break;
                myNetData.flip();
                while (myNetData.hasRemaining()) {
                    socketChannel.write(myNetData);
                }
            }
            if (result != null && result.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new SSLHandshakeException("Error closing SSL session.  Status=" + (Object)((Object)result.getStatus()));
            }
        }
        catch (ClosedChannelException outputSharing2) {
        }
        catch (IOException e) {
            throw new GemFireIOException("exception closing SSL session", e);
        }
        catch (ByteBufferVendor.OpenAttemptTimedOut _unused) {
            logger.info(String.format("Couldn't get output lock in time, eliding TLS close message", new Object[0]));
            if (!this.engine.isOutboundDone()) {
                this.engine.closeOutbound();
            }
        }
        finally {
            this.outputBufferVendor.destruct();
        }
    }

    @VisibleForTesting
    public ByteBufferVendor getOutputBufferVendorForTestingOnly() {
        return this.outputBufferVendor;
    }

    @VisibleForTesting
    public ByteBufferVendor getInputBufferVendorForTestingOnly() {
        return this.inputBufferVendor;
    }
}

