/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.functions.RestoreRedundancyFunction;
import org.apache.geode.management.internal.operation.OperationPerformer;
import org.apache.geode.management.internal.operation.RebalanceOperationPerformer;
import org.apache.geode.management.internal.operation.RestoreRedundancyResultsImpl;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.management.operation.RestoreRedundancyRequest;
import org.apache.geode.management.runtime.RestoreRedundancyResults;
import org.apache.geode.util.internal.UncheckedUtils;

public class RestoreRedundancyPerformer
implements OperationPerformer<RestoreRedundancyRequest, RestoreRedundancyResults> {
    @Immutable
    @VisibleForTesting
    static final KnownVersion ADDED_VERSION = KnownVersion.GEODE_1_13_0;
    private static final String NO_MEMBERS_WITH_VERSION_FOR_REGION = "No members with a version greater than or equal to %s were found for region %s";
    private static final String EXCEPTION_MEMBER_MESSAGE = "Exception occurred on member %s: %s";
    public static final String SUCCESS_STATUS_MESSAGE = "Success";

    @Override
    public RestoreRedundancyResults perform(Cache cache, RestoreRedundancyRequest operation) {
        return this.perform(cache, operation, false);
    }

    public RestoreRedundancyResults perform(Cache cache, RestoreRedundancyRequest operation, boolean isStatusCommand) {
        ArrayList<RebalanceOperationPerformer.MemberPRInfo> membersForEachRegion = new ArrayList<RebalanceOperationPerformer.MemberPRInfo>();
        ArrayList<String> includedRegionsWithNoMembers = new ArrayList<String>();
        this.populateLists(membersForEachRegion, includedRegionsWithNoMembers, operation.getIncludeRegions(), operation.getExcludeRegions(), (InternalCache)cache);
        for (RebalanceOperationPerformer.MemberPRInfo prInfo : membersForEachRegion) {
            List<DistributedMember> viableMembers = this.filterViableMembers(prInfo);
            if (!viableMembers.isEmpty()) {
                prInfo.dsMemberList = viableMembers;
                continue;
            }
            RestoreRedundancyResultsImpl results = new RestoreRedundancyResultsImpl();
            results.setStatusMessage(String.format(NO_MEMBERS_WITH_VERSION_FOR_REGION, ADDED_VERSION.getName(), prInfo.region));
            results.setSuccess(false);
            return results;
        }
        ArrayList<RestoreRedundancyResults> functionResults = new ArrayList<RestoreRedundancyResults>();
        Object[] functionArgs = new Object[]{operation, isStatusCommand};
        ArrayList<DistributedMember> completedMembers = new ArrayList<DistributedMember>();
        for (RebalanceOperationPerformer.MemberPRInfo memberPRInfo : membersForEachRegion) {
            if (!Collections.disjoint(completedMembers, memberPRInfo.dsMemberList)) continue;
            DistributedMember targetMember = memberPRInfo.dsMemberList.get(0);
            RestoreRedundancyResults functionResult = this.executeFunctionAndGetFunctionResult(new RestoreRedundancyFunction(), functionArgs, targetMember);
            if (!functionResult.getSuccess()) {
                RestoreRedundancyResultsImpl results = new RestoreRedundancyResultsImpl();
                String errorString = String.format(EXCEPTION_MEMBER_MESSAGE, targetMember.getName(), functionResult.getStatusMessage());
                results.setStatusMessage(errorString);
                results.setSuccess(false);
                return results;
            }
            functionResults.add(functionResult);
            completedMembers.add(targetMember);
        }
        RestoreRedundancyResultsImpl finalResult = new RestoreRedundancyResultsImpl();
        finalResult.addIncludedRegionsWithNoMembers(includedRegionsWithNoMembers);
        for (RestoreRedundancyResults functionResult : functionResults) {
            finalResult.addRegionResults(functionResult);
        }
        finalResult.setSuccess(true);
        finalResult.setStatusMessage(SUCCESS_STATUS_MESSAGE);
        return finalResult;
    }

    public RestoreRedundancyResults executeFunctionAndGetFunctionResult(Function<?> function, Object args, DistributedMember targetMember) {
        ResultCollector<?, ?> rc = ManagementUtils.executeFunction(function, args, Collections.singleton(targetMember));
        List results = (List)UncheckedUtils.uncheckedCast(rc.getResult());
        return results.isEmpty() ? null : (RestoreRedundancyResults)results.get(0);
    }

    List<DistributedMember> filterViableMembers(RebalanceOperationPerformer.MemberPRInfo prInfo) {
        return prInfo.dsMemberList.stream().map(InternalDistributedMember.class::cast).filter(member -> member.getVersion().compareTo((Object)ADDED_VERSION) >= 0).collect(Collectors.toList());
    }

    void populateLists(List<RebalanceOperationPerformer.MemberPRInfo> membersForEachRegion, List<String> noMemberRegions, List<String> includeRegions, List<String> excludeRegions, InternalCache cache) {
        if (includeRegions == null) {
            List<RebalanceOperationPerformer.MemberPRInfo> memberRegionList = this.getMembersForEachRegion(cache, excludeRegions);
            membersForEachRegion.addAll(memberRegionList);
        } else {
            for (String regionName : includeRegions) {
                DistributedMember memberForRegion = this.getOneMemberForRegion(cache, regionName);
                if (memberForRegion == null) {
                    noMemberRegions.add(regionName);
                    continue;
                }
                RebalanceOperationPerformer.MemberPRInfo memberPRInfo = new RebalanceOperationPerformer.MemberPRInfo();
                memberPRInfo.region = regionName;
                memberPRInfo.dsMemberList.add(memberForRegion);
                membersForEachRegion.add(memberPRInfo);
            }
        }
    }

    private List<RebalanceOperationPerformer.MemberPRInfo> getMembersForEachRegion(InternalCache cache, List<String> excludedRegionList) {
        return RebalanceOperationPerformer.getMemberRegionList(ManagementService.getManagementService(cache), cache, excludedRegionList);
    }

    private DistributedMember getOneMemberForRegion(InternalCache cache, String regionName) {
        String regionNameWithSeparator = regionName;
        if (!regionName.startsWith("/")) {
            regionNameWithSeparator = "/" + regionName;
        }
        return RebalanceOperationPerformer.getAssociatedMembers(regionNameWithSeparator, cache);
    }
}

